/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.tools.webappconfig.tasks.PropertyData;
import com.sas.tools.webappconfig.tasks.WebappBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class invtoptsrvcModeledProperties
extends WebappBaseModeledProperties {
    private static final String GL_IOW_TRANS_LIBREF = "GL_IOW_TRANS_LIBREF";
    private static final String DBMS_LIBREF_PROPERTY = "data.invtoptsrvc.dbms.libref";
    private static final String DBMS_USERID_PROPERTY = "data.invtoptsrvc.database.userid";
    private static final String DBMS_DOMAIN_PROPERTY = "data.invtoptsrvc.dbms.domain";
    private static final String DBMS_DATABASE_PROPERTY = "data.invtoptsrvc.database.name";
    private static final String POSTGRES_DATABASE_PROPERTYNAME = "DATABASE";
    private static final List _propData = new ArrayList();

    @Override
    public List getPropertyData() {
        return _propData;
    }

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = new Properties();
        SoftwareComponent configObject = (SoftwareComponent)root;
        Properties librefProperties = super.getModeledProperties(root);
        String libRef = librefProperties.getProperty(DBMS_LIBREF_PROPERTY);
        Logger.log(2, null, "Libref: \"" + libRef + "\"");
        try {
            MdObjectStore mdStore = (MdObjectStore)configObject.getObjectStore();
            String reposId = "A0000001." + configObject.getRepositoryID();
            String mdType = "SASLibrary";
            String xmlSelect = "<XMLSELECT Search=\"@Libref='" + libRef + "'\"/>";
            Logger.log(2, null, reposId);
            Logger.log(2, null, mdType);
            Logger.log(2, null, xmlSelect);
            List found = invtoptsrvcModeledProperties.findMetadataObjects(mdStore, reposId, mdType, xmlSelect);
            if (found != null && found.size() > 0) {
                SASLibrary transLib = (SASLibrary)found.get(0);
                Logger.log(2, null, "SASLibrary: " + transLib.getName());
                retval.setProperty(DBMS_USERID_PROPERTY, transLib.getDefaultLogin().getUserID());
                retval.setProperty(DBMS_DOMAIN_PROPERTY, transLib.getDefaultLogin().getDomain().getName());
                SASClientConnection connection = transLib.getLibraryConnection();
                AssociationList properties = transLib.getProperties();
                retval.setProperty(DBMS_DATABASE_PROPERTY, this.getPropertyByPropertyName((List)properties, POSTGRES_DATABASE_PROPERTYNAME).getDefaultValue().replace("\"", ""));
            } else {
                Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + libRef);
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, "invtoptsrvcModeledProperties: " + e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, "invtoptsrvcModeledProperties: " + e.getMessage());
        }
        return retval;
    }

    public static List findMetadataObjects(MdObjectStore mdObjectStore, String reposId, String mdType, String xmlSelect) throws MdException, RemoteException {
        MdFactory factory = mdObjectStore.getFactory();
        MdOMIUtil util = factory.getOMIUtil();
        List objectList = util.getMetadataObjectsSubset((MdStore)mdObjectStore, reposId, mdType, 384, xmlSelect);
        return objectList;
    }

    private DatabaseSchema getDatabaseSchema(SASLibrary owner) throws RemoteException, MdException {
        DatabaseSchema retval = null;
        AssociationList usingPackages = owner.getUsingPackages();
        for (Root usingPackage : usingPackages) {
            if (!(usingPackage instanceof DatabaseSchema)) continue;
            retval = (DatabaseSchema)usingPackage;
            break;
        }
        return retval;
    }

    private Property getPropertyByPropertyName(List properties, String propertyName) throws RemoteException {
        Property retval = null;
        for (Property property : properties) {
            if (!property.getPropertyName().equals(propertyName)) continue;
            retval = property;
            break;
        }
        return retval;
    }

    static {
        _propData.add(new PropertyData(GL_IOW_TRANS_LIBREF, DBMS_LIBREF_PROPERTY));
    }
}

