/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.Properties;

public class ddcfmidModeledProperties
implements ModeledPropertyInterface {
    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = new Properties();
        try {
            TCPIPConnection sourceConnection;
            String twelveByte = this.getClassId(root);
            String contextRootProperty = "webapp." + twelveByte + ".contextroot";
            DeployedComponent deployedComponent = this.getDeployedComponentNamed(root, "Registered SAS Application");
            if (deployedComponent != null && (sourceConnection = this.getSourceConnectionNamed(deployedComponent, "Connection URI")) != null) {
                String service = sourceConnection.getService().substring(1);
                retval.setProperty(contextRootProperty, service);
                Logger.log(2, null, "TCPIP Service: " + service);
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, e.getMessage());
        }
        return retval;
    }

    private DeployedComponent getDeployedComponentNamed(Root owner, String name) throws RemoteException, MdException {
        DeployedComponent retval = null;
        SoftwareComponent sc = (SoftwareComponent)owner;
        AssociationList deployedComponents = sc.getDeployedComponents();
        for (DeployedComponent deployedComponent : deployedComponents) {
            if (!deployedComponent.getName().equals(name)) continue;
            retval = deployedComponent;
            break;
        }
        return retval;
    }

    private TCPIPConnection getSourceConnectionNamed(DeployedComponent owner, String name) throws RemoteException, MdException {
        TCPIPConnection retval = null;
        AssociationList sourceConnections = owner.getSourceConnections();
        for (TCPIPConnection sourceConnection : sourceConnections) {
            if (!sourceConnection.getName().equals(name)) continue;
            retval = sourceConnection;
            break;
        }
        return retval;
    }

    private String getClassId(Root configObject) throws RemoteException {
        SoftwareComponent sc = (SoftwareComponent)configObject;
        String classId = sc.getClassIdentifier();
        return classId;
    }
}

