/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.tools.webappconfig.tasks.ConnectionAntProperties;
import com.sas.tools.webappconfig.tasks.WebappBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class bihpgrdcModeledProperties
extends WebappBaseModeledProperties {
    private static ConnectionAntProperties _connectionAntProperties = null;
    private static final String LASR_HOST_PROPERTY = "used.by";
    private static final String LASR_SERVER_PUBLIC_TYPE = "Server.LASR";
    private static final String LASR_SERVER_TYPE = "ServerComponent";
    private static final String LASR_CONNECTION_TYPE = "SASClientConnection";
    private static final String PUBLIC_LASR_SERVER_IDENTIFIER = "va_public";
    private static final String PUBLIC_LASR_SERVER_PORT_PROPERTY = "bihpgrdc.autoload.server.port";
    private static final String PRIVATE_LASR_SERVER_IDENTIFIER = "va_private";
    private static final String PRIVATE_LASR_SERVER_PORT_PROPERTY = "bihpgrdc.lasrserver.port";
    private static List _propData = null;

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = super.getModeledProperties(root);
        try {
            String privatePort;
            String repository = "A0000001." + root.getRepositoryID();
            MdFactory factory = root.getObjectStore().getFactory();
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            String publicPort = bihpgrdcModeledProperties.getLASRServerPort(PUBLIC_LASR_SERVER_IDENTIFIER, factory, store, repository);
            if (publicPort != null) {
                retval.setProperty(PUBLIC_LASR_SERVER_PORT_PROPERTY, publicPort);
            }
            if ((privatePort = bihpgrdcModeledProperties.getLASRServerPort(PRIVATE_LASR_SERVER_IDENTIFIER, factory, store, repository)) != null) {
                retval.setProperty(PRIVATE_LASR_SERVER_PORT_PROPERTY, privatePort);
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, "RemoteException encountered - Using textstore values");
            e.printStackTrace();
        }
        catch (MdException e) {
            Logger.log(0, null, "MdException encountered - Using textstore values");
            e.printStackTrace();
        }
        catch (Throwable t) {
            Logger.log(0, null, "Throwable encountered - Using textstore values");
            t.printStackTrace();
        }
        return retval;
    }

    @Override
    public List getPropertyData() {
        return _propData;
    }

    @Override
    public ConnectionAntProperties getConnectionAntProperties() {
        return _connectionAntProperties;
    }

    public static String getLASRServerPort(String uniqueIdentifier, MdFactory factory, MdObjectStore store, String repository) throws RemoteException, MdException {
        String serverPort = null;
        int my_flags = 385;
        String filter = "<XMLSelect search=\"SASClientConnection[Source/ServerComponent[@PublicType='Server.LASR']/Extensions/Extension[@Name='used.by' and @Value='" + uniqueIdentifier + "']]\" />";
        Logger.log(2, null, "Filter was: " + filter + " for type: " + LASR_CONNECTION_TYPE);
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository, LASR_CONNECTION_TYPE, my_flags, filter);
        if (list == null || list.size() != 1) {
            Logger.log(2, null, "No single LASR server connection found for " + uniqueIdentifier + " identifer. Using textstore values");
        } else {
            SASClientConnection connection = (SASClientConnection)list.get(0);
            serverPort = String.valueOf(connection.getPort());
            Logger.log(2, null, "For Connection " + connection.getName() + " using port: " + serverPort);
        }
        return serverPort;
    }
}

