/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.tasks.ConnectionAntProperties;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.VaBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TemplateWebappModeledProperties
extends VaBaseModeledProperties {
    private static List _propData = null;
    private static ConnectionAntProperties _connectionAntProperties = null;

    @Override
    public Properties getModeledProperties(Root root) {
        String twelvebyte = null;
        TextStore privateConf = ObjectPropertiesUtil.getTextStore(null, root, false);
        if (privateConf != null) {
            Logger.log(2, null, "Private Text Store: ");
            Properties privateProps = this.createProperties(privateConf);
            twelvebyte = privateProps.getProperty("12byte");
            Logger.log(2, null, "12byte name: " + twelvebyte);
        }
        _connectionAntProperties = new ConnectionAntProperties(twelvebyte + ".protocol", twelvebyte + ".host", twelvebyte + ".port", twelvebyte + ".url");
        Properties retval = super.getModeledProperties(root);
        String contextRoot = super.getContextRootFromURI(retval.getProperty(twelvebyte + ".url"));
        if (contextRoot != null) {
            retval.put(twelvebyte + ".contextroot", contextRoot);
        }
        Logger.log(2, null, "protocol: " + retval.getProperty(twelvebyte + ".protocol"));
        Logger.log(2, null, "host: " + retval.getProperty(twelvebyte + ".host"));
        Logger.log(2, null, "port: " + retval.getProperty(twelvebyte + ".port"));
        Logger.log(2, null, "url: " + retval.getProperty(twelvebyte + ".url"));
        Logger.log(2, null, "contextroot: " + retval.getProperty(twelvebyte + ".contextroot"));
        return retval;
    }

    @Override
    public List getPropertyData() {
        return _propData;
    }

    @Override
    public ConnectionAntProperties getConnectionAntProperties() {
        return _connectionAntProperties;
    }

    private Properties createProperties(TextStore textStore) {
        Properties props = new Properties();
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                Logger.log(3, null, propName + "=" + propValue);
                props.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, null, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, null, " TextStore: " + textStore);
            return null;
        }
        return props;
    }
}

