/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.password;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class PasswordRule {
    private static final String _DOUBLE_SLASH = "doubleSlash";
    private static final String _MATCH_AT_LEAST_ONE = "matchAtLeastOne";
    private static final String _REVERSED = "reversed";
    private static final String _AFTER = "after";
    private static final String _MIDDLE = "middle";
    private static final String _BEFORE = "before";
    private static final String _CLOSE_PAREN = ")";
    private static final String _REPLACE_PATTERN = ")\\S*(";
    private static final String _OPEN_PAREN = "(";
    private static final String _SEARCH_PATTERN = "(\\S*)";
    private static final Set _attributeNames;
    private final String _before;
    private final String _middle;
    private final String _after;
    private final int _commonLength;
    private final boolean _reversed;
    private final boolean _matchAtLeastOne;
    private final boolean _doubleSlash;

    static String getElementName() {
        return "password";
    }

    static Iterator getAttributeNames() {
        return _attributeNames.iterator();
    }

    PasswordRule(Map attributes) {
        this._before = this.getStringValue(attributes.get(_BEFORE));
        this._middle = this.getStringValue(attributes.get(_MIDDLE));
        this._after = this.getStringValue(attributes.get(_AFTER));
        this._commonLength = this._before.length() + this._middle.length() + this._after.length();
        this._reversed = this.getBooleanValue(attributes.get(_REVERSED));
        this._matchAtLeastOne = this.getBooleanValue(attributes.get(_MATCH_AT_LEAST_ONE));
        this._doubleSlash = this.getBooleanValue(attributes.get(_DOUBLE_SLASH));
    }

    private String getStringValue(Object param) {
        return param == null ? "" : param.toString();
    }

    private boolean getBooleanValue(Object param) {
        return param == null ? false : "true".equals(param.toString());
    }

    Pattern getPasswordSearchPattern() {
        int length = this._commonLength + 2 * _SEARCH_PATTERN.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(this._before);
        buffer.append(_SEARCH_PATTERN);
        buffer.append(this._middle);
        buffer.append(_SEARCH_PATTERN);
        buffer.append(this._after);
        return Pattern.compile(buffer.toString(), 32);
    }

    Pattern getPasswordReplacementPattern(String useridLit, String useridLitDS) {
        String userid = this._doubleSlash ? useridLitDS : useridLit;
        int length = this._commonLength + _OPEN_PAREN.length() + _REPLACE_PATTERN.length() + _CLOSE_PAREN.length() + userid.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(_OPEN_PAREN);
        buffer.append(this._before);
        if (this.isReversed()) {
            buffer.append(_REPLACE_PATTERN);
            buffer.append(this._middle);
            buffer.append(userid);
        } else {
            buffer.append(userid);
            buffer.append(this._middle);
            buffer.append(_REPLACE_PATTERN);
        }
        buffer.append(this._after);
        buffer.append(_CLOSE_PAREN);
        return Pattern.compile(buffer.toString(), 32);
    }

    boolean isReversed() {
        return this._reversed;
    }

    boolean getMatchAtLeastOne() {
        return this._matchAtLeastOne;
    }

    static {
        HashSet<String> names = new HashSet<String>(6);
        names.add(_BEFORE);
        names.add(_MIDDLE);
        names.add(_AFTER);
        names.add(_REVERSED);
        names.add(_MATCH_AT_LEAST_ONE);
        names.add(_DOUBLE_SLASH);
        _attributeNames = Collections.unmodifiableSet(names);
    }
}

