/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.password;

import com.sas.tools.webappconfig.password.ChangeRequest;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public class InputFile {
    private final String _fileName;
    private static final Set _passwordIdentifiers;
    private static final Set _useridIdentifiers;

    public InputFile(String fileName) {
        this._fileName = fileName;
    }

    public List getChangeRequests(Task task) throws WebAppConfigException {
        BufferedReader reader;
        LinkedList results = new LinkedList();
        try {
            reader = new BufferedReader(new FileReader(this._fileName));
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, this._fileName), e);
        }
        Pattern pattern = Pattern.compile("(?:\\s*(\\S+)\\s*=\\s*\"(.*)\")(?:\\s*(\\S+)\\s*=\\s*\"(.*)\")");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(task, new File(this._fileName), results, line, pattern);
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(task, this._fileName), e);
        }
        finally {
            CommonUtils.closeReader(reader);
        }
        return results;
    }

    private void processLine(Task task, File file, List results, String line, Pattern pattern) throws WebAppConfigException {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches() || matcher.groupCount() % 2 != 0) {
            throw new WebAppConfigException(ErrorHandling.generateUnrecognizedSyntaxInFileErrorMessage(task, line, file), new IllegalStateException());
        }
        ChangeRequest request = new ChangeRequest();
        for (int i = 0; i < matcher.groupCount(); i += 2) {
            String keyword = matcher.group(i + 1);
            String value = matcher.group(i + 2);
            if (this.isUserID(keyword)) {
                request.setUserID(value);
                continue;
            }
            if (this.isPassword(keyword)) {
                request.setPassword(value);
                continue;
            }
            throw new WebAppConfigException(ErrorHandling.generateUnrecognizedKeywordInFileErrorMessage(task, keyword, file), new IllegalStateException());
        }
        results.add(request);
    }

    private boolean isPassword(String keyword) {
        return this.isInSetOfIdentifiers(keyword, _passwordIdentifiers);
    }

    private boolean isUserID(String keyword) {
        return this.isInSetOfIdentifiers(keyword, _useridIdentifiers);
    }

    private boolean isInSetOfIdentifiers(String keyword, Set identifiers) {
        String key = keyword.toUpperCase();
        Iterator iter = identifiers.iterator();
        while (iter.hasNext()) {
            if (!key.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> passwordIdentifiers = new HashSet<String>();
        passwordIdentifiers.add("PASSWORD");
        passwordIdentifiers.add("PWD");
        passwordIdentifiers.add("PW");
        passwordIdentifiers.add("PASSWD");
        passwordIdentifiers.add("LOGIN:PASSWORD");
        _passwordIdentifiers = Collections.unmodifiableSet(passwordIdentifiers);
        HashSet<String> useridIdentifiers = new HashSet<String>();
        useridIdentifiers.add("USERID");
        useridIdentifiers.add("UID");
        useridIdentifiers.add("LOGIN");
        useridIdentifiers.add("ID");
        useridIdentifiers.add("LOGIN:USERID");
        _useridIdentifiers = Collections.unmodifiableSet(useridIdentifiers);
    }
}

