/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.password;

import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public class FileUtil {
    static CharSequence fromFile(Task task, File file) throws WebAppConfigException {
        FileReader reader;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, file), e);
        }
        int toBeRead = (int)file.length();
        char[] cbuf = new char[toBeRead];
        try {
            int charsRead;
            for (int actuallyRead = 0; actuallyRead < toBeRead; actuallyRead += charsRead) {
                charsRead = ((Reader)reader).read(cbuf, actuallyRead, toBeRead - actuallyRead);
                if (charsRead != -1) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(task, file), e);
        }
        finally {
            CommonUtils.closeReader(reader);
        }
        return CharBuffer.wrap(cbuf);
    }

    static void toFile(Task task, File file, CharSequence sequence) throws WebAppConfigException {
        FileWriter fw;
        try {
            fw = new FileWriter(file);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, file), e);
        }
        try {
            fw.write(sequence.toString());
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotWriteToFileErrorMessage(task, file), e);
        }
        finally {
            CommonUtils.closeWriter(fw);
        }
    }

    static List recursiveMatch(String prefix, String suffix) {
        ArrayList<File> list = new ArrayList<File>();
        File candidateFile = new File(suffix == null ? prefix : prefix + "/" + suffix);
        if (candidateFile.exists()) {
            list.add(candidateFile);
            return list;
        }
        if (suffix == null) {
            return list;
        }
        String[] split = suffix.split("/", 2);
        if (split[0].indexOf(42) == -1) {
            return FileUtil.recursiveMatch(prefix + "/" + split[0], split.length == 1 ? null : split[1]);
        }
        String[] expanded = FileUtil.ls(prefix, split[0]);
        if (expanded != null) {
            for (int i = 0; i < expanded.length; ++i) {
                List more = FileUtil.recursiveMatch(prefix + "/" + expanded[i], split.length == 1 ? null : split[1]);
                list.addAll(more);
            }
        }
        return list;
    }

    private static String[] ls(String dirName, String wildcard) {
        final Pattern pattern = Pattern.compile(wildcard.replaceAll("\\*", ".*").replaceAll("\\.", "\\."));
        return new File(dirName).list(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return pattern.matcher(name).matches();
            }
        });
    }
}

