/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.password;

import com.sas.tools.webappconfig.password.ChangeRequest;
import com.sas.tools.webappconfig.password.FileUtil;
import com.sas.tools.webappconfig.password.PasswordRule;
import com.sas.tools.webappconfig.password.PwTuple;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;

public class FileRule {
    private static final String _CONFIG_LEVEL_TOKEN = "<LEV>";
    private static final String _ELEMENT_NAME = "file";
    private static final String _PATTERN = "pattern";
    private static final String _ROOT = "root";
    private final String _filePattern;
    private List _passwordRules = new LinkedList();
    private static final Set _attributeNames;

    static Iterator getAttributeNames() {
        return _attributeNames.iterator();
    }

    static String getElementName() {
        return _ELEMENT_NAME;
    }

    FileRule(Properties properties, Map attributeValues, String configLevel) {
        String temp = properties.getProperty((String)attributeValues.get(_ROOT)) + "/" + attributeValues.get(_PATTERN);
        temp = temp.replaceAll(_CONFIG_LEVEL_TOKEN, configLevel);
        this._filePattern = temp = temp.replaceAll("\\\\", "/").replaceAll("([^/])//+", "$1/");
    }

    public List findPasswords(Task task) throws WebAppConfigException {
        LinkedList matches = new LinkedList();
        List files = this.getMatchingFiles(task);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            this.findPasswordsInFile(task, matches, (File)iter.next());
        }
        return matches;
    }

    private void findPasswordsInFile(Task task, List matches, File file) throws WebAppConfigException {
        boolean isLinked = false;
        boolean haveLinkedPasswords = false;
        CharSequence contents = FileUtil.fromFile(task, file);
        String canonicalPath = file.getAbsolutePath();
        for (PasswordRule password : this._passwordRules) {
            Pattern pattern = password.getPasswordSearchPattern();
            Matcher matcher = pattern.matcher(contents);
            boolean isMatched = false;
            haveLinkedPasswords |= password.getMatchAtLeastOne();
            while (matcher.find()) {
                if (password.isReversed()) {
                    matches.add(new PwTuple(matcher.group(2), matcher.group(1), canonicalPath));
                } else {
                    matches.add(new PwTuple(matcher.group(1), matcher.group(2), canonicalPath));
                }
                if (password.getMatchAtLeastOne()) {
                    isLinked = true;
                    continue;
                }
                isMatched = true;
            }
            if (isMatched || password.getMatchAtLeastOne()) continue;
            Logger.log(0, task, ErrorHandling.generatePasswordDefinitionNotFoundInFile(task, pattern, canonicalPath));
        }
        if (haveLinkedPasswords && !isLinked) {
            Logger.log(0, task, ErrorHandling.generateNoPasswordsFoundInFileErrorMessage(task, canonicalPath));
        }
    }

    public boolean applyChanges(Task task, List changeRequests) throws WebAppConfigException {
        boolean result = false;
        List files = this.getMatchingFiles(task);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            result |= this.applyChangesToFile(task, changeRequests, (File)iter.next());
        }
        return result;
    }

    private boolean applyChangesToFile(Task task, List changeRequests, File file) throws WebAppConfigException {
        ModifiableContents contents = new ModifiableContents(FileUtil.fromFile(task, file));
        Iterator requestIter = changeRequests.iterator();
        while (requestIter.hasNext()) {
            this.applyChangeRequestToFile(task, file, contents, (ChangeRequest)requestIter.next());
        }
        if (contents.isDirty()) {
            FileUtil.toFile(task, file, contents.getContents());
        } else {
            Logger.log(2, task, ErrorHandling.generateNoChangesMadeToFileMessage(task, file.getPath()));
        }
        return contents.isDirty();
    }

    private void applyChangeRequestToFile(Task task, File file, ModifiableContents contents, ChangeRequest request) throws WebAppConfigException {
        String userID = request.getUserID();
        String useridLit = this.regexpEscape(userID);
        String useridLitDS = this.regexpEscape(userID.replaceAll("\\\\", "\\\\\\\\"));
        String passwordLit = this.regexpEscape(request.getEncryptedPassword(task));
        for (PasswordRule password : this._passwordRules) {
            Pattern pattern = password.getPasswordReplacementPattern(useridLit, useridLitDS);
            Matcher matcher = pattern.matcher(contents.getContents());
            if (!matcher.find()) continue;
            contents.setContents(matcher.replaceAll("$1" + passwordLit + "$2"));
            Logger.log(2, task, ErrorHandling.generatePasswordChangedMessage(task, userID, file.getPath()));
        }
    }

    private String regexpEscape(String literal) {
        return literal.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\.", "\\\\\\.").replaceAll("\\^", "\\\\\\^").replaceAll("\\[", "\\\\\\[").replaceAll("\\(", "\\\\\\(").replaceAll("\\$", "\\\\\\$").replaceAll("\\*", "\\\\\\*");
    }

    private List getMatchingFiles(Task task) {
        LinkedList<File> files = new LinkedList<File>();
        File candidateFile = new File(this._filePattern);
        if (candidateFile.exists()) {
            files.add(candidateFile);
        } else {
            String[] split = this._filePattern.split("/", 2);
            files.addAll(FileUtil.recursiveMatch(split[0], split.length == 1 ? null : split[1]));
        }
        if (files.isEmpty()) {
            Logger.log(1, task, ErrorHandling.generateNoFilesFoundMatchingPatternWarning(task, this._filePattern));
        }
        return files;
    }

    void addPasswordRule(PasswordRule password) {
        this._passwordRules.add(password);
    }

    static {
        HashSet<String> names = new HashSet<String>(2);
        names.add(_ROOT);
        names.add(_PATTERN);
        _attributeNames = Collections.unmodifiableSet(names);
    }

    private static class ModifiableContents {
        private CharSequence _contents;
        private boolean _dirty;

        ModifiableContents(CharSequence contents) {
            this._contents = contents;
            this._dirty = false;
        }

        CharSequence getContents() {
            return this._contents;
        }

        void setContents(CharSequence contents) {
            this._contents = contents;
            this._dirty = true;
        }

        boolean isDirty() {
            return this._dirty;
        }
    }
}

