/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.logging;

import com.sas.tools.webappconfig.logging.DateTimestampTransform;
import com.sas.tools.webappconfig.logging.DecodedPasswordTransform;
import com.sas.tools.webappconfig.logging.ITransform;
import com.sas.tools.webappconfig.logging.PostgresMD5Transform;
import com.sas.tools.webappconfig.logging.SAS00NTransform;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;

public class LogTransformer
extends DefaultLogger {
    private List<ITransform> transforms = new ArrayList<ITransform>(4);

    public LogTransformer() {
        this.transforms.add(new SAS00NTransform());
        this.transforms.add(new PostgresMD5Transform());
        this.transforms.add(new DecodedPasswordTransform());
        this.transforms.add(new DateTimestampTransform());
    }

    private String transformLogMessage(String message) {
        String newMessage = message;
        for (ITransform transform : this.transforms) {
            newMessage = transform.transform(newMessage);
        }
        return newMessage;
    }

    public void messageLogged(BuildEvent event) {
        String message = event.getMessage();
        int priority = event.getPriority();
        message = this.transformLogMessage(message);
        event.setMessage(message, priority);
        super.messageLogged(event);
    }
}

