/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.foundationservers;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataServerUtil {
    public static final String CONNECTION_TCPIP = "TCPIPConnection";
    public static final String CONNECTION_SASCLIENT = "SASClientConnection";
    public static final String PROTOCOL_OPERATOR = "Operator";
    public static final String PROTOCOL_BRIDGE = "Bridge";
    private static final String SPAWNER_CLASS_IDENTIFIER = "IOM Spawner";

    private MetadataServerUtil() {
    }

    public static ServerComponent getLogicalServer(ServerComponent server) {
        LogicalServer logicalServer = null;
        ServerComponent component = null;
        try {
            AssociationList logicalServers = server.getUsedByComponents();
            if (logicalServers != null && logicalServers.size() > 0) {
                for (int index = 0; index < logicalServers.size(); ++index) {
                    component = (ServerComponent)logicalServers.get(index);
                    if (!(component instanceof LogicalServer)) continue;
                    logicalServer = (LogicalServer)component;
                }
            }
        }
        catch (MdException exception) {
            Logger.log(0, null, (Object)exception);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return logicalServer;
    }

    public static ServerComponent getServerComponent(LogicalServer server) {
        boolean isFound;
        ServerComponent component;
        block4: {
            Object logicalServer = null;
            component = null;
            isFound = false;
            try {
                AssociationList servers = server.getUsingComponents();
                if (servers == null || servers.size() <= 0) break block4;
                for (int index = 0; index < servers.size(); ++index) {
                    component = (ServerComponent)servers.get(index);
                    if (!(component instanceof ServerComponent)) continue;
                    isFound = true;
                    break;
                }
            }
            catch (MdException exception) {
                Logger.log(0, null, (Object)exception);
            }
            catch (RemoteException exception) {
                Logger.log(0, null, exception);
            }
        }
        return isFound ? component : null;
    }

    public static ServerContext getServerContext(ServerComponent server) {
        ServerContext serverContext;
        block5: {
            serverContext = null;
            AssociationList contexts = null;
            Object context = null;
            try {
                if (server == null) break block5;
                ServerComponent logicalServer = MetadataServerUtil.getLogicalServer(server);
                if (logicalServer != null) {
                    contexts = logicalServer.getUsedByComponents();
                }
                if (contexts == null || contexts.size() <= 0) break block5;
                for (int index = 0; index < contexts.size(); ++index) {
                    context = contexts.get(index);
                    if (!(context instanceof ServerContext)) continue;
                    serverContext = (ServerContext)contexts.get(index);
                    break;
                }
            }
            catch (MdException exception) {
                Logger.log(0, null, (Object)exception);
            }
            catch (RemoteException exception) {
                Logger.log(0, null, exception);
            }
        }
        return serverContext;
    }

    public static String getConfigCommand(ServerComponent server) {
        String configCommand = null;
        try {
            AssociationList properties = server.getProperties();
            Property property = null;
            if (properties != null && properties.size() > 0) {
                for (int index = 0; index < properties.size(); ++index) {
                    property = (Property)properties.get(index);
                    String name = property.getName();
                    if (!"Command".equalsIgnoreCase(name)) continue;
                    configCommand = property.getDefaultValue();
                }
            }
        }
        catch (MdException exception) {
            Logger.log(0, null, (Object)exception);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return configCommand;
    }

    public static Map getProperties(ServerComponent server) {
        HashMap<String, String> props = null;
        String name = null;
        String value = null;
        try {
            AssociationList properties = server.getProperties();
            Property property = null;
            if (properties != null && properties.size() > 0) {
                props = new HashMap<String, String>();
                for (int index = 0; index < properties.size(); ++index) {
                    property = (Property)properties.get(index);
                    name = property.getPropertyName();
                    value = property.getDefaultValue();
                    props.put(name, value);
                }
            }
        }
        catch (MdException exception) {
            Logger.log(0, null, (Object)exception);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return props;
    }

    public static TCPIPConnection getTCPIPConnection(ServerComponent server) {
        return (TCPIPConnection)MetadataServerUtil.getConnection(server, CONNECTION_TCPIP);
    }

    public static SASClientConnection getSasClientConnection(ServerComponent server) {
        return (SASClientConnection)MetadataServerUtil.getConnection(server, CONNECTION_SASCLIENT);
    }

    private static Connection getConnection(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size() && !MetadataServerUtil.isSpecifiedServer(serverConnection = (Connection)connectionList.get(index), connectionType); ++index) {
                }
            }
        }
        catch (Exception exception) {
            Logger.log(0, null, exception);
        }
        return serverConnection;
    }

    public static TCPIPConnection getConnectionByType(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    if (!serverConnection.getApplicationProtocol().equalsIgnoreCase(connectionType) || !MetadataServerUtil.isSpecifiedServer(serverConnection, CONNECTION_TCPIP)) continue;
                    return (TCPIPConnection)serverConnection;
                }
            }
        }
        catch (MdException exception) {
            Logger.log(0, null, (Object)exception);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return null;
    }

    public static TCPIPConnection getOperatorConnection(ServerComponent server) {
        return MetadataServerUtil.getConnectionByType(server, PROTOCOL_OPERATOR);
    }

    public static TCPIPConnection getBridgeConnection(ServerComponent server) {
        return MetadataServerUtil.getConnectionByType(server, PROTOCOL_BRIDGE);
    }

    private static boolean isSpecifiedServer(Connection ServerConnection, String type) {
        Class serverClass = ServerConnection.getClass();
        Class<?>[] interfaces = serverClass.getInterfaces();
        String interfaceName = null;
        boolean isSpecified = false;
        for (int index = 0; index < interfaces.length && !(isSpecified = (interfaceName = interfaces[index].getName()).endsWith(type)); ++index) {
        }
        return isSpecified;
    }

    public static String getAuthenticationDomain(Connection serverConnection) {
        AuthenticationDomain domain = null;
        String domainName = null;
        try {
            if (serverConnection != null) {
                domain = serverConnection.getDomain();
                domainName = domain.getName();
            }
        }
        catch (MdException e) {
            Logger.log(0, null, (Object)e);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return domainName;
    }

    public static String getLoginID(AuthenticationDomain domain, String loginName) {
        String userID = null;
        try {
            if (domain != null) {
                MdFactory factory = domain.getObjectStore().getFactory();
                int flags = 8584;
                String reposId = "A0000001." + domain.getRepositoryID();
                String search = "<XMLSELECT search=\"Login[@Name='" + loginName + "'][Domain/*[@Id='" + domain.getId() + "']]\"/>";
                List objects = factory.getOMIUtil().getFastMetadataObjects("Login", reposId, search, flags);
                if (objects != null && !objects.isEmpty()) {
                    userID = ((FastMetadata)objects.get(0)).getAttribute("UserID");
                }
            }
        }
        catch (MdException e) {
            Logger.log(0, null, (Object)e);
        }
        catch (RemoteException exception) {
            Logger.log(0, null, exception);
        }
        return userID;
    }

    private static boolean isSpecifiedServer(String serverName, String serverType) {
        Pattern pattern = Pattern.compile(serverType);
        Matcher match = pattern.matcher(serverName);
        return match.matches();
    }

    public static ServerComponent getObjectSpawner(ServerComponent server) {
        ServerComponent spawner;
        block4: {
            spawner = null;
            AssociationList usingComponents = null;
            try {
                usingComponents = server.getUsingComponents();
                Object component = null;
                if (usingComponents == null) break block4;
                for (int index = 0; index < usingComponents.size(); ++index) {
                    component = usingComponents.get(index);
                    if (!(component instanceof ServerComponent) || !((ServerComponent)component).getClassIdentifier().equalsIgnoreCase(SPAWNER_CLASS_IDENTIFIER)) continue;
                    spawner = (ServerComponent)component;
                    break;
                }
            }
            catch (MdException exception) {
                Logger.log(0, null, (Object)exception);
            }
            catch (RemoteException exception) {
                Logger.log(0, null, exception);
            }
        }
        return spawner;
    }
}

