/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.foundationservers;

import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.tools.webappconfig.foundationservers.MetadataServerUtil;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FoundationServersProperties
implements ModeledPropertyInterface {
    private static Map _12ByteReslover = new HashMap();
    private static Map _propertyPrefix;
    private static final String PROP_LOGICAL_SERVER = ".logical.name";
    private static final String PROP_SERVER_CONTEXT = ".servercontext.name";
    private static final String PROP_BRIDGE_PORT_NO = ".port";
    private static final String PROP_HOST = ".host";
    private static final String PROP_SERVER_NAME = ".name";
    private static final String PROP_AUTH_DOMAIN = ".authdomain";
    private static final String PROP_DEFAULT_PREFIX = "iomsrv.";
    private static final String PROP_PRODUCT_PREFIX = ".prefix";
    private static final String PROP_GENSRV_LOGINID = ".gensrvusr.login.userid";

    private ServerComponent getServerComponent(Root component) {
        ServerComponent server = (ServerComponent)component;
        if (component instanceof LogicalServer) {
            server = MetadataServerUtil.getServerComponent((LogicalServer)component);
        }
        return server;
    }

    @Override
    public Properties getModeledProperties(Root arg0) {
        Properties props;
        block13: {
            ServerComponent server = this.getServerComponent(arg0);
            props = null;
            String productName = null;
            try {
                String classId = server.getClassIdentifier();
                Logger.log(2, null, "CONFIGURABLE OBJECT : " + arg0.getName() + " SERVER COMPONENT : " + server.getName());
                if (_12ByteReslover.containsKey(classId)) {
                    productName = (String)_12ByteReslover.get(classId);
                    props = new Properties();
                    TCPIPConnection connection = MetadataServerUtil.getBridgeConnection(server);
                    if (connection != null) {
                        props.put(this.getPropertyName(PROP_HOST, productName), connection.getHostName());
                        props.put(this.getPropertyName(PROP_AUTH_DOMAIN, productName), MetadataServerUtil.getAuthenticationDomain((Connection)connection));
                        props.put(this.getPropertyName(PROP_BRIDGE_PORT_NO, productName), String.valueOf(connection.getPort()));
                        if (_12ByteReslover.get(classId).equals("storprocsrv") || _12ByteReslover.get(classId).equals("workspacpool")) {
                            try {
                                String userID = MetadataServerUtil.getLoginID(connection.getDomain(), "Login.SAS General Servers.86");
                                if (userID != null) {
                                    props.put(this.getPropertyName(PROP_GENSRV_LOGINID, productName), userID);
                                }
                            }
                            catch (MdException e) {
                                Logger.log(0, null, (Object)e);
                            }
                        }
                    } else {
                        TCPIPConnection operatorConnection = MetadataServerUtil.getOperatorConnection(server);
                        if (operatorConnection != null) {
                            props.put(this.getPropertyName(PROP_HOST, productName), operatorConnection.getHostName());
                            props.put(this.getPropertyName(PROP_AUTH_DOMAIN, productName), MetadataServerUtil.getAuthenticationDomain((Connection)operatorConnection));
                            props.put(this.getPropertyName(PROP_BRIDGE_PORT_NO, productName), String.valueOf(operatorConnection.getPort()));
                        }
                    }
                    ServerContext context = MetadataServerUtil.getServerContext(server);
                    ServerComponent logicalServer = MetadataServerUtil.getLogicalServer(server);
                    if (logicalServer != null) {
                        props.put(this.getPropertyName(PROP_LOGICAL_SERVER, productName), logicalServer.getName());
                    }
                    if (context != null) {
                        props.put(this.getPropertyName(PROP_SERVER_CONTEXT, productName), context.getName());
                    }
                    props.put(this.getPropertyName(PROP_SERVER_NAME, productName), server.getName());
                    break block13;
                }
                Logger.log(0, null, "No Class identifier found for the server : " + server.getName());
            }
            catch (RemoteException exception) {
                Logger.log(0, null, "EXCEPTION Occured : " + exception.getMessage());
            }
        }
        return props;
    }

    private String getPropertyName(String property, String product) {
        String prefix = null;
        String temppropertyname = null;
        prefix = _propertyPrefix.containsKey(product) ? (String)_propertyPrefix.get(product) : PROP_DEFAULT_PREFIX;
        temppropertyname = prefix + product + property;
        if ("spawner.objectspawnr.port".equals(temppropertyname)) {
            temppropertyname = "spawner.objectspawnr.operator.port";
        }
        if ("spawner.objectspawnr.name".equals(temppropertyname)) {
            temppropertyname = "spawner.objectspawnr.servercomponent.name";
        }
        if ("server.sharesrv.name".equals(temppropertyname)) {
            temppropertyname = "server.sharesrv.servercomponent.name";
        }
        return temppropertyname;
    }

    static {
        _12ByteReslover.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", "olapserver");
        _12ByteReslover.put("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8", "dsbatchsrv");
        _12ByteReslover.put("440196D4-90F0-11D0-9F41-00A024BB830C", "workspacesrv");
        _12ByteReslover.put("15931E31-667F-11D5-8804-00C04F35AC8C", "storprocsrv");
        _12ByteReslover.put("SHARE", "sharesrv");
        _12ByteReslover.put("IOM Spawner", "objectspawnr");
        _12ByteReslover.put("b379c9c1-89e0-4e72-ba43-6a416899b5dd", "ossrvsched");
        _12ByteReslover.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", "workspacpool");
        _propertyPrefix = new HashMap(6);
        _propertyPrefix.put("objectspawnr", "spawner.");
        _propertyPrefix.put("sharesrv", "server.");
        _propertyPrefix.put("dsbatchsrv", "server.");
    }
}

