/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deploy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

@Deprecated
public class SASRuntimeWrapper {
    private static SASRuntimeWrapper currentRuntime = new SASRuntimeWrapper();
    protected static Logger log = Logger.getLogger(SASRuntimeWrapper.class.getName());
    private Runtime javaRuntime = Runtime.getRuntime();

    public static SASRuntimeWrapper getRuntime() {
        return currentRuntime;
    }

    private SASRuntimeWrapper() {
    }

    public void exit(int status) {
        this.javaRuntime.exit(status);
    }

    public void addShutdownHook(Thread hook) {
        this.javaRuntime.addShutdownHook(hook);
    }

    public boolean removeShutdownHook(Thread hook) {
        return this.javaRuntime.removeShutdownHook(hook);
    }

    public void halt(int status) {
        this.javaRuntime.halt(status);
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean value) {
        Runtime.runFinalizersOnExit((boolean)value);
    }

    public static String[] convertToCmdArray(String command) {
        String[] ret = new String[]{};
        List<String> cmdList = SASRuntimeWrapper.convertToCmdList(command);
        ret = cmdList.toArray(ret);
        return ret;
    }

    public static List<String> convertToCmdList(String command) {
        if (command == null) {
            throw new NullPointerException("The command specified is null!");
        }
        ArrayList<String> cmdArrayList = new ArrayList<String>();
        SASRuntimeWrapper.recurseBuildCmdArray(command, cmdArrayList);
        String cmd = cmdArrayList.get(0).replace("\"", "");
        if (cmd.contains(File.separator)) {
            File file = new File(cmd);
            while (!file.isFile() && cmdArrayList.size() > 1) {
                String newCmd = cmdArrayList.remove(0) + " " + cmdArrayList.remove(0);
                cmdArrayList.add(0, newCmd);
                file = new File(newCmd.replace("\"", ""));
            }
            if (!file.isFile()) {
                log.info("SASRuntimeWrapper::convertToCmdList() could not find valid command file, " + file.getPath());
            }
        }
        log.finer("SASRuntimeWrapper::convertToCmdList() returning: " + cmdArrayList.toString());
        return cmdArrayList;
    }

    private static void recurseBuildCmdArray(String command, List<String> cmdList) {
        if ((command = command.trim()).length() > 0) {
            int indexStart = 0;
            int indexNextDelimiter = SASRuntimeWrapper.findSpaceForNextArgument(command);
            if (indexNextDelimiter == -1) {
                command = command.replace("\"", "");
                cmdList.add(command);
            } else {
                String arg = command.substring(indexStart, indexNextDelimiter);
                arg = arg.replace("\"", "");
                cmdList.add(arg);
                command = command.substring(indexNextDelimiter + 1);
                SASRuntimeWrapper.recurseBuildCmdArray(command, cmdList);
            }
        }
    }

    private static int findSpaceForNextArgument(String command) {
        int ret = -1;
        if (command != null) {
            for (int i = 0; i < command.length(); ++i) {
                char c = command.charAt(i);
                int endQuote = -1;
                switch (c) {
                    case '\"': {
                        endQuote = command.indexOf(34, i + 1);
                        if (endQuote == -1) {
                            throw new IllegalArgumentException("This portion of the command is missing an end quote: " + command);
                        }
                        i = endQuote;
                        break;
                    }
                    case '\'': {
                        endQuote = command.indexOf(39, i + 1);
                        if (endQuote == -1) {
                            throw new IllegalArgumentException("This portion of the command is missing an end quote: " + command);
                        }
                        i = endQuote;
                        break;
                    }
                    case ' ': {
                        ret = i;
                        break;
                    }
                }
                if (ret != -1) break;
            }
        }
        return ret;
    }

    public Process exec(String command) throws IOException {
        Process ret = null;
        try {
            ret = this.javaRuntime.exec(SASRuntimeWrapper.convertToCmdArray(command));
        }
        catch (IOException ioe) {
            ret = this.javaRuntime.exec(command);
        }
        return ret;
    }

    public int waitForExec(String command, final PrintStream out) throws IOException {
        int ret = 0;
        List<String> cmdList = SASRuntimeWrapper.convertToCmdList(command);
        log.finer("SASRuntimeWrapper::waitForExec() calling ProcessBuilder with: " + cmdList.toString());
        if (out != null) {
            out.println("SASRuntimeWrapper::waitForExec() calling ProcessBuilder with: " + cmdList.toString());
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(cmdList);
            pb.redirectErrorStream(true);
            final Process p = pb.start();
            if (out != null) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        try {
                            while ((line = input.readLine()) != null) {
                                out.println(line);
                            }
                            input.close();
                        }
                        catch (Exception e) {
                            out.println(e.getMessage());
                        }
                    }
                });
            }
            ret = p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ret = -1;
        }
        return ret;
    }

    public Process exec(String command, String[] envp) throws IOException {
        Process ret = null;
        try {
            ret = this.javaRuntime.exec(SASRuntimeWrapper.convertToCmdArray(command), envp);
        }
        catch (IOException ioe) {
            ret = this.javaRuntime.exec(command, envp);
        }
        return ret;
    }

    public Process exec(String command, String[] envp, File dir) throws IOException {
        Process ret = null;
        try {
            ret = this.javaRuntime.exec(SASRuntimeWrapper.convertToCmdArray(command), envp, dir);
        }
        catch (IOException ioe) {
            ret = this.javaRuntime.exec(command, envp, dir);
        }
        return ret;
    }

    public Process exec(String[] cmdarray) throws IOException {
        return this.javaRuntime.exec(cmdarray);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        return this.javaRuntime.exec(cmdarray, envp);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return this.javaRuntime.exec(cmdarray, envp, dir);
    }

    public int availableProcessors() {
        return this.javaRuntime.availableProcessors();
    }

    public long freeMemory() {
        return this.javaRuntime.freeMemory();
    }

    public long totalMemory() {
        return this.javaRuntime.totalMemory();
    }

    public long maxMemory() {
        return this.javaRuntime.maxMemory();
    }

    public void gc() {
        this.javaRuntime.gc();
    }

    public void runFinalization() {
        this.javaRuntime.runFinalization();
    }

    public void traceInstructions(boolean on) {
        this.javaRuntime.traceInstructions(on);
    }

    public void traceMethodCalls(boolean on) {
        this.javaRuntime.traceMethodCalls(on);
    }

    public void load(String filename) {
        this.javaRuntime.load(filename);
    }

    public void loadLibrary(String libname) {
        this.javaRuntime.loadLibrary(libname);
    }

    @Deprecated
    public InputStream getLocalizedInputStream(InputStream in) {
        return this.javaRuntime.getLocalizedInputStream(in);
    }

    @Deprecated
    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return this.javaRuntime.getLocalizedOutputStream(out);
    }
}

