/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.exceptions;

import com.sas.svcs.exceptions.ThrowableFilter;
import java.util.regex.Pattern;

public class ThrowablePatternFilter
implements ThrowableFilter {
    private final Pattern[] includes;
    private final Pattern[] excludes;
    private final boolean defaultResponse;

    public ThrowablePatternFilter() {
        this.defaultResponse = true;
        this.includes = new Pattern[]{Pattern.compile("jakarta.transaction.*"), Pattern.compile("jakarta.persistence.*")};
        this.excludes = new Pattern[]{Pattern.compile("com\\.sas\\..*"), Pattern.compile("java.*"), Pattern.compile("javax.*")};
    }

    public ThrowablePatternFilter(Pattern[] includes, Pattern[] excludes, boolean defaultResponse) {
        this.includes = includes;
        this.excludes = excludes;
        this.defaultResponse = defaultResponse;
    }

    @Override
    public boolean accept(Throwable t) {
        if (this.matches(t.getClass(), this.includes) != null) {
            return true;
        }
        if (this.matches(t.getClass(), this.excludes) != null) {
            return false;
        }
        return this.defaultResponse;
    }

    private Pattern matches(Class<? extends Throwable> clazz, Pattern[] patterns) {
        if (null != patterns) {
            for (Pattern p : patterns) {
                if (!p.matcher(clazz.getName()).matches()) continue;
                return p;
            }
        }
        return null;
    }
}

