/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.util;

import com.sas.svcs.commons.util.EventingMap;
import com.sas.svcs.commons.util.EventingMapEvent;
import com.sas.svcs.commons.util.EventingMapListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HashEventingMap<K, V>
extends HashMap<K, V>
implements EventingMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final List<EventingMapListener<K, V>> listeners = new ArrayList<EventingMapListener<K, V>>();

    public HashEventingMap() {
    }

    public HashEventingMap(int paramInt, float paramFloat) {
        super(paramInt, paramFloat);
    }

    public HashEventingMap(int paramInt) {
        super(paramInt);
    }

    public HashEventingMap(Map<? extends K, ? extends V> paramMap) {
        super(paramMap);
    }

    @Override
    public void addListener(EventingMapListener<K, V> listener) {
        this.listeners.add(listener);
    }

    private void fireAddListeners(EventingMapEvent<K, V> event) {
        for (EventingMapListener<K, V> listener : this.listeners) {
            listener.entryAdded(event);
        }
    }

    private void fireRemoveListeners(EventingMapEvent<K, V> event) {
        for (EventingMapListener<K, V> listener : this.listeners) {
            listener.entryRemoved(event);
        }
    }

    @Override
    public V put(K key, V value) {
        V ret = super.put(key, value);
        EventingMapEvent<K, V> event = new EventingMapEvent<K, V>(key, value, EventingMapEvent.EventType.ADDED);
        this.fireAddListeners(event);
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> paramMap) {
        super.putAll(paramMap);
        for (Map.Entry<K, V> entry : paramMap.entrySet()) {
            EventingMapEvent<K, V> event = new EventingMapEvent<K, V>(entry.getKey(), entry.getValue(), EventingMapEvent.EventType.ADDED);
            this.fireAddListeners(event);
        }
    }

    @Override
    public V remove(Object paramObject) {
        Object ret = super.remove(paramObject);
        if (ret != null) {
            this.fireRemoveListeners(new EventingMapEvent(paramObject, ret, EventingMapEvent.EventType.REMOVED));
        }
        return ret;
    }

    @Override
    public void clear() {
        HashSet events = new HashSet(super.size());
        for (Map.Entry entry : super.entrySet()) {
            events.add(new EventingMapEvent(entry.getKey(), entry.getValue(), EventingMapEvent.EventType.REMOVED));
        }
        super.clear();
        for (EventingMapEvent eventingMapEvent : events) {
            this.fireRemoveListeners(eventingMapEvent);
        }
    }
}

