/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons;

import com.sas.svcs.commons.Page;
import com.sas.svcs.commons.Pageable;
import com.sas.svcs.commons.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PageImpl<T>
implements Page<T>,
Serializable {
    private static final long serialVersionUID = 867755909294344406L;
    private final List<T> content = new ArrayList<T>();
    private final Pageable pageable;
    private final long total;

    public PageImpl(List<T> content, Pageable pageable, long total) {
        if (null == content) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        this.content.addAll(content);
        this.total = total;
        this.pageable = pageable;
    }

    public PageImpl(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size());
    }

    @Override
    public int getNumber() {
        return this.pageable == null ? 0 : this.pageable.getPageNumber();
    }

    @Override
    public int getSize() {
        return this.pageable == null ? 0 : this.pageable.getPageSize();
    }

    @Override
    public int getTotalPages() {
        return this.getSize() == 0 ? 0 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    @Override
    public int getNumberOfElements() {
        return this.content.size();
    }

    @Override
    public long getTotalElements() {
        return this.total;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.getNumber() > 0;
    }

    @Override
    public boolean isFirstPage() {
        return !this.hasPreviousPage();
    }

    @Override
    public boolean hasNextPage() {
        return (long)((this.getNumber() + 1) * this.getSize()) < this.total;
    }

    @Override
    public boolean isLastPage() {
        return !this.hasNextPage();
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @Override
    public Sort getSort() {
        return this.pageable == null ? null : this.pageable.getSort();
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.content.size() > 0) {
            contentType = this.content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber(), this.getTotalPages(), contentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageImpl)) {
            return false;
        }
        PageImpl that = (PageImpl)obj;
        boolean totalEqual = this.total == that.total;
        boolean contentEqual = this.content.equals(that.content);
        boolean pageableEqual = this.pageable == null ? that.pageable == null : this.pageable.equals(that.pageable);
        return totalEqual && contentEqual && pageableEqual;
    }

    public int hashCode() {
        int prime17 = 17;
        int prime31 = 31;
        int result = 17;
        int numBitShifts = 32;
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        result = 31 * result + (this.pageable == null ? 0 : this.pageable.hashCode());
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

