/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons;

import com.sas.svcs.commons.Identifiable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.springframework.util.Assert;

public final class ObjectIdentity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String objectType;
    private transient long objectTypeId;

    public ObjectIdentity() {
    }

    @Deprecated
    public ObjectIdentity(String objectTypeId, String identifier) {
        Assert.hasText((String)objectTypeId, (String)"ObjectType required");
        Assert.hasText((String)identifier, (String)"Identifier required");
        this.objectTypeId = Long.valueOf(objectTypeId);
        this.objectType = objectTypeId;
        this.identifier = identifier;
    }

    public ObjectIdentity(long objectTypeId, String identifier) {
        Assert.hasText((String)identifier, (String)"Identifier required");
        this.objectTypeId = objectTypeId;
        this.objectType = Long.toString(objectTypeId);
        this.identifier = identifier;
    }

    public ObjectIdentity(Identifiable identifiable) {
        this(identifiable.getObjectType(), identifiable.getId());
    }

    public long getObjectType() {
        return this.objectTypeId;
    }

    public String getId() {
        return this.identifier;
    }

    public void setId(String identifier) {
        this.identifier = identifier;
    }

    @Deprecated
    public void setObjectType(String objectTypeId) {
        this.objectTypeId = Long.valueOf(objectTypeId);
        this.objectType = objectTypeId;
    }

    public void setObjectType(long objectTypeId) {
        this.objectTypeId = objectTypeId;
        this.objectType = Long.toString(objectTypeId);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.objectType != null) {
            try {
                this.objectTypeId = Long.valueOf(this.objectType);
            }
            catch (Exception ex) {
                this.objectTypeId = -1L;
            }
        } else {
            this.objectTypeId = -1L;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectIdentity other = (ObjectIdentity)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.objectTypeId == other.objectTypeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + new Long(this.objectTypeId).hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(super.toString() + " [").append("identifier=" + this.getId() + "; ").append("objectType=" + this.getObjectType());
        return sb.toString();
    }
}

