/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.aop.cache;

import com.sas.svcs.aop.cache.CacheInterceptor;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;

public class ExpiringCacheInterceptor
extends CacheInterceptor
implements MethodInterceptor {
    private static final int DEFAULT_EXPIRATION_HOURS = 24;
    long timeToExpiration = TimeUnit.HOURS.toMillis(24L);

    public void setTimeToExpiration(long t) {
        this.timeToExpiration = t;
    }

    @Override
    public boolean validElement(Object key) {
        CacheElement element = (CacheElement)this.getCache().get(key);
        if (null != element) {
            if (element.isExpired()) {
                this.getCache().remove(key);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void saveElement(Object key, Object element) {
        this.getCache().put(key, new CacheElement(element));
    }

    @Override
    public Object retrieveElement(Object key) {
        CacheElement element = (CacheElement)this.getCache().get(key);
        return element.getValue();
    }

    class CacheElement {
        private final Object value;
        private final long time;

        public CacheElement(Object v) {
            this.value = v;
            this.time = System.currentTimeMillis();
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.time > ExpiringCacheInterceptor.this.timeToExpiration;
        }
    }
}

