/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.result;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.xml.DocumentBuilderFactoryUtils;

public class DomResultFactory
implements ResultFactory {
    private final DocumentBuilderFactory documentBuilderFactory;
    private final Lock documentBuilderFactoryMonitor = new ReentrantLock();
    private final Lock lock = new ReentrantLock();

    public DomResultFactory() {
        this(DocumentBuilderFactoryUtils.newInstance());
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public DomResultFactory(DocumentBuilderFactory documentBuilderFactory) {
        Assert.notNull((Object)documentBuilderFactory, (String)"'documentBuilderFactory' must not be null.");
        this.documentBuilderFactory = documentBuilderFactory;
    }

    @Override
    public Result createResult(Object payload) {
        this.lock.lock();
        try {
            DOMResult dOMResult = new DOMResult(this.getNewDocumentBuilder().newDocument());
            return dOMResult;
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("failed to create Result for payload type [" + payload.getClass().getName() + "]", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        this.documentBuilderFactoryMonitor.lock();
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        finally {
            this.documentBuilderFactoryMonitor.unlock();
        }
    }
}

