/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MarshallingTransformerParser
extends AbstractTransformerParser {
    protected String getTransformerClassName() {
        return "org.springframework.integration.xml.transformer.MarshallingTransformer";
    }

    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String extractPayload;
        String resultTransformer = element.getAttribute("result-transformer");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"result-type", (String)"resultType");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"result-factory", (String)"resultFactoryName");
        String marshaller = element.getAttribute("marshaller");
        Assert.hasText((String)marshaller, (String)"the 'marshaller' attribute is required");
        builder.addConstructorArgReference(marshaller);
        if (StringUtils.hasText((String)resultTransformer)) {
            builder.addConstructorArgReference(resultTransformer);
        }
        if (StringUtils.hasText((String)(extractPayload = element.getAttribute("extract-payload")))) {
            builder.addPropertyValue("extractPayload", (Object)extractPayload);
        }
    }
}

