/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.iom.SAS.IWorkspace;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SchedulingDetailsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SchedulingDetailsPanel.class);
    private JLabel m_lblsascommand;
    private JTextField m_txtsascommand;
    private JButton m_btnReset;
    private JLabel m_lblsasbatchserver;
    private JTextField m_txtsasbatchserver;
    private JLabel m_lbldirectory;
    private JTextField m_txtdirectory;
    private JLabel m_lblsasfilename;
    private JTextField m_txtsasfilename;
    private JLabel m_lbljclfilename;
    private JTextField m_txtjclfilename;
    private JButton m_btnEditJCL;
    private JButton m_btnAdvance;
    private ServerFlowInfo m_flow;
    private ServerJobInfo m_jobinfo;
    private JobInfo m_job;
    private String m_sascommand;
    private String m_sascommand_multiline;
    private String m_batchservername;
    private ScheduleManager m_schmgr;
    private Frame m_frame;
    private IWorkspace m_iworkspace = null;

    public SchedulingDetailsPanel(ScheduleManager plugin, ServerJobInfo job, ServerFlowInfo flow, boolean enableButtons) {
        this.m_schmgr = plugin;
        this.m_frame = plugin.getMainFrame();
        this.m_jobinfo = job;
        this.m_job = job.getJobInfo() instanceof JobInfo ? (JobInfo)job.getJobInfo() : null;
        this.m_flow = flow;
        this.m_sascommand = "";
        this.__initialize(enableButtons);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_frame = null;
        this.m_iworkspace = null;
        this.m_lblsascommand = null;
        this.m_txtsascommand = null;
        this.m_lblsasbatchserver = null;
        this.m_txtsasbatchserver = null;
        this.m_lbldirectory = null;
        this.m_txtdirectory = null;
        this.m_lblsasfilename = null;
        this.m_txtsasfilename = null;
        this.m_lbljclfilename = null;
        this.m_txtjclfilename = null;
        this.m_btnEditJCL = null;
        this.m_btnAdvance = null;
        this.m_flow = null;
        this.m_job = null;
        this.m_sascommand = null;
        this.m_sascommand_multiline = null;
        this.m_batchservername = null;
    }

    public boolean moveViewToData() {
        this.m_jobinfo.resetInfo(this.m_job);
        if (this.m_flow != null) {
            this.m_flow.resetJobInfo(this.m_job);
        }
        return this.m_jobinfo.commitChangesToOMR();
    }

    public boolean moveDataToView() {
        this.setListeningForChanges(false);
        DirectoryInfo directory = null;
        String sasfilename = null;
        String jclfilename = null;
        if (this.m_job != null) {
            this.m_sascommand = this.m_job.getCommandLine();
            if (this.m_job.isCommandLineDerived()) {
                if (this.m_sascommand == null) {
                    this.m_schmgr.updateJobCommandline(this.m_job, this.m_flow != null ? this.m_flow.getName() : null);
                    this.m_sascommand = this.m_job.getCommandLine();
                }
                this.m_btnReset.setEnabled(false);
            } else {
                this.m_btnReset.setEnabled(true);
            }
            sasfilename = this.m_job.getSourceFile();
            if (sasfilename != null) {
                directory = this.m_job.getSourceDir();
            }
            try {
                this.m_batchservername = this.m_job.getBatchServer().getName();
            }
            catch (NullPointerException npe) {
                this.m_batchservername = null;
            }
            if (this.m_job.getJCL() != null) {
                String baseName;
                String normFilename = CommandUtilities.normalizePath((String)this.m_schmgr.getJCLFile(this.m_jobinfo), (int)-1);
                int index = normFilename.lastIndexOf(47);
                jclfilename = (baseName = normFilename.substring(++index)).endsWith("\"") ? baseName.substring(0, baseName.length() - 1) : baseName;
            }
        }
        this.m_txtsascommand.setText(this.m_sascommand);
        this.m_txtsascommand.setToolTipText(this.m_sascommand_multiline);
        this.m_txtsasbatchserver.setText(this.m_batchservername);
        this.m_txtdirectory.setText(directory != null ? directory.getName() : null);
        this.m_txtdirectory.setToolTipText(directory != null ? directory.getPath() : null);
        this.m_txtsasfilename.setText(sasfilename);
        if (jclfilename != null) {
            this.m_txtjclfilename.setText(jclfilename);
            this.m_lbljclfilename.setVisible(true);
            this.m_txtjclfilename.setVisible(true);
            this.m_btnEditJCL.setVisible(true);
        } else {
            this.m_lbljclfilename.setVisible(false);
            this.m_txtjclfilename.setVisible(false);
            this.m_btnEditJCL.setVisible(false);
        }
        this.setListeningForChanges(true);
        return true;
    }

    public boolean validateData() {
        if (this.m_txtsascommand.getText().length() == 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.SASCommandError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            this.m_btnAdvance.grabFocus();
            return false;
        }
        if (this.m_batchservername == null) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidBatchServerError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        if (!this.isValidFileName()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidFilenameError.fmt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        int filenamelength = this.m_txtsasfilename.getText().length();
        int dirnamelength = this.m_txtdirectory.getText().length();
        if (filenamelength > 0 && dirnamelength == 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.SASFileAndNoDirectoryError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        if (filenamelength == 0 && dirnamelength > 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.NoSASFileAndDirectoryError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        return true;
    }

    private boolean isValidFileName() {
        String fileName = this.m_txtsasfilename.getText();
        if (fileName.length() == 0) {
            return true;
        }
        return this.m_schmgr.isValidFilename(fileName);
    }

    public void __initialize(boolean enableButtons) {
        StandardPanel pnldetails = new StandardPanel();
        this.m_txtsascommand = new JTextField();
        this.m_txtsascommand.setEditable(false);
        String sascommandText = m_bundle.getString("SchedulingDetailsPanel.sascommand.txt");
        this.m_lblsascommand = new JLabel(Util.getLabelWithoutMnemonic((String)sascommandText));
        this.m_lblsascommand.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sascommandText));
        this.m_lblsascommand.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.sascommand.ToolTip.txt"));
        this.m_lblsascommand.setLabelFor(this.m_txtsascommand);
        String resetText = m_bundle.getString("SchedulingDetailsPanel.ResetButton.txt");
        this.m_btnReset = new JButton(Util.getLabelWithoutMnemonic((String)resetText));
        this.m_btnReset.setMnemonic(Util.getDisplayedMnemonic((String)resetText));
        this.m_btnReset.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)resetText));
        this.m_btnReset.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.ResetButton.ToolTip.txt"));
        this.m_btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulingDetailsPanel.this.m_btnResetOnclicked();
            }
        });
        this.m_txtsasbatchserver = new JTextField();
        this.m_txtsasbatchserver.setEditable(false);
        String item = m_bundle.getString("SchedulingDetailsPanel.sasbatchserver.txt");
        String text = Util.getLabelWithoutMnemonic((String)item);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        this.m_lblsasbatchserver = new JLabel(text);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            this.m_lblsasbatchserver.setDisplayedMnemonic(mnemonic);
            this.m_lblsasbatchserver.setDisplayedMnemonicIndex(index);
        }
        this.m_lblsasbatchserver.setLabelFor(this.m_txtsasbatchserver);
        this.m_txtdirectory = new JTextField();
        this.m_txtdirectory.setEditable(false);
        String directoryText = m_bundle.getString("SchedulingDetailsPanel.directory.txt");
        this.m_lbldirectory = new JLabel(Util.getLabelWithoutMnemonic((String)directoryText));
        this.m_lbldirectory.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)directoryText));
        this.m_lbldirectory.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.directory.ToolTip.txt"));
        this.m_lbldirectory.setLabelFor(this.m_txtdirectory);
        this.m_txtsasfilename = new JTextField();
        this.m_txtsasfilename.setEditable(false);
        String sasfilenameText = m_bundle.getString("SchedulingDetailsPanel.sasfilename.txt");
        this.m_lblsasfilename = new JLabel(Util.getLabelWithoutMnemonic((String)sasfilenameText));
        this.m_lblsasfilename.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sasfilenameText));
        this.m_lblsasfilename.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.sasfilename.ToolTip.txt"));
        this.m_lblsasfilename.setLabelFor(this.m_txtsasfilename);
        this.m_txtjclfilename = new JTextField();
        this.m_txtjclfilename.setEditable(false);
        String jclfilenameText = m_bundle.getString("SchedulingDetailsPanel.jclfilename.txt");
        this.m_lbljclfilename = new JLabel(Util.getLabelWithoutMnemonic((String)jclfilenameText));
        this.m_lbljclfilename.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)jclfilenameText));
        this.m_lbljclfilename.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.jclfilename.ToolTip.txt"));
        this.m_lbljclfilename.setLabelFor(this.m_txtjclfilename);
        String editjclText = m_bundle.getString("SchedulingDetailsPanel.EditJCLButton.txt");
        this.m_btnEditJCL = new JButton(Util.getLabelWithoutMnemonic((String)editjclText));
        this.m_btnEditJCL.setMnemonic(Util.getDisplayedMnemonic((String)editjclText));
        this.m_btnEditJCL.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)editjclText));
        this.m_btnEditJCL.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.EditJCLButton.ToolTip.txt"));
        this.m_btnEditJCL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulingDetailsPanel.this.m_btnEditJCLOnclicked();
            }
        });
        pnldetails.setLayout((LayoutManager)new GridBagLayout());
        pnldetails.add((Component)this.m_lblsascommand, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_txtsascommand, (Object)new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_btnReset, (Object)new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 12, 0, new Insets(5, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_lblsasbatchserver, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(30, 0, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_txtsasbatchserver, (Object)new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 18, 2, new Insets(30, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_lbldirectory, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_txtdirectory, (Object)new GridBagConstraints(1, 3, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_lblsasfilename, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_txtsasfilename, (Object)new GridBagConstraints(1, 4, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_lbljclfilename, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_txtjclfilename, (Object)new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        pnldetails.add((Component)this.m_btnEditJCL, (Object)new GridBagConstraints(3, 5, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 12, 0, 0), 0, 0));
        StandardPanel pnlButtons = new StandardPanel();
        String advanceText = m_bundle.getString("SchedulingDetailsPanel.AdvanceButton.txt");
        this.m_btnAdvance = new JButton(Util.getLabelWithoutMnemonic((String)advanceText));
        this.m_btnAdvance.setMnemonic(Util.getDisplayedMnemonic((String)advanceText));
        this.m_btnAdvance.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)advanceText));
        this.m_btnAdvance.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.AdvanceButton.ToolTip.txt"));
        this.enableButtons(enableButtons);
        this.m_btnAdvance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulingDetailsPanel.this.m_btnAdvanceOnclicked();
            }
        });
        pnlButtons.setLayout((LayoutManager)new ButtonsLayout(0, 4));
        pnlButtons.add((Component)this.m_btnAdvance);
        this.setLayout(new GridBagLayout());
        this.add((Component)pnldetails, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)pnlButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(20, 150, 0, 0), 0, 0));
    }

    public void enableButtons(boolean enableButtons) {
        if (enableButtons) {
            this.m_btnEditJCL.setEnabled(true);
            this.m_btnAdvance.setEnabled(true);
        } else {
            this.m_btnReset.setEnabled(false);
            this.m_btnEditJCL.setEnabled(false);
            this.m_btnAdvance.setEnabled(false);
        }
    }

    private void m_btnResetOnclicked() {
        try {
            this.m_sascommand = this.m_jobinfo.resetCommandLine();
        }
        catch (InvalidParameterException ipe) {
            this.m_sascommand = ipe.getMessage();
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.CannotResetMustRedeploy.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ResetDialog.Title.txt"), (int)2);
        }
        this.m_txtsascommand.setText(this.m_sascommand);
        this.m_sascommand_multiline = this.m_sascommand;
        this.m_btnReset.setEnabled(false);
    }

    private void m_btnEditJCLOnclicked() {
        int PANE_WIDTH = 550;
        int PANE_HEIGHT = 300;
        int PANE_ROWS = 10;
        try {
            String jclText;
            StandardPanel zOSPanel = new StandardPanel();
            JTextArea editpanel = new JTextArea();
            editpanel.setLineWrap(false);
            editpanel.setRows(PANE_ROWS);
            JScrollPane scrollpane = new JScrollPane(editpanel);
            scrollpane.setPreferredSize(new Dimension(PANE_WIDTH, PANE_HEIGHT));
            GridBagConstraints gbc_editpanel = new GridBagConstraints(0, 0, 1, 10, 1.0, 1.0, 14, 1, new Insets(0, 5, 0, 0), 0, 0);
            zOSPanel.setLayout((LayoutManager)new GridBagLayout());
            zOSPanel.add((Component)scrollpane, (Object)gbc_editpanel);
            this.setCursor(Cursor.getPredefinedCursor(3));
            BatchServerInfo batchserver = this.m_job.getBatchServer();
            this.m_iworkspace = this.m_schmgr.checkConnectionToWorkspaceServer(batchserver);
            String jclFile = this.m_schmgr.getJCLFile(this.m_jobinfo);
            String jcl = this.m_schmgr.readJCL(this.m_iworkspace, jclFile);
            editpanel.setText(jcl.toString());
            this.setCursor(Cursor.getDefaultCursor());
            StandardDialog dia = new StandardDialog(this.m_frame, m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), true);
            dia.setMainPanel(zOSPanel);
            dia.setHelpProduct("scheduler");
            dia.setHelpTopic("jcl");
            dia.makeVisible();
            if (dia.getReturnValue() == 1 && !this.m_schmgr.writeJCL(this.m_iworkspace, jclFile, jclText = editpanel.getText())) {
                String message = m_bundle.getString("AdvanceJobPropertiesDialog.ErrorMessage.UnableToSaveContents.txt");
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
            }
        }
        catch (SchedulerException ex) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        catch (RemoteException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
    }

    private void m_btnAdvanceOnclicked() {
        if (this.m_schmgr.checkSchedulerConnectionForProperties(this.m_flow)) {
            String title = m_bundle.getString("SchedulingDetailsPanel.AdvanceDialog.Title.txt");
            SchedulerServerInfo scheduler = this.m_flow != null ? this.m_flow.getInfo().getScheduler() : null;
            JobInfo resetJob = new JobInfo();
            resetJob.setName(this.m_job.getName());
            resetJob.setCommandLine(this.m_job.getCommandLine());
            resetJob.setCommandLineDerived(this.m_job.isCommandLineDerived());
            resetJob.setSchedulerProperties(this.m_job.getSchedulerProperties());
            resetJob.setSchedulerResources(this.m_job.getSchedulerResources());
            resetJob.setUserId(this.m_job.getUserId());
            int rc = this.m_schmgr.showJobAdvanceProperties(title, this.m_job, this.m_flow, scheduler);
            if (rc == 1) {
                String cmdLine = this.m_job.getCommandLine();
                if (cmdLine != null && !cmdLine.equals(this.m_txtsascommand.getText())) {
                    this.m_txtsascommand.setText(cmdLine);
                    this.m_job.setCommandLine(cmdLine, false);
                    this.m_job.setCommandLineDerived(false);
                    this.m_sascommand = cmdLine;
                    this.m_sascommand_multiline = GeneralUtilities.replaceString((String)this.m_sascommand, (String)" ", (String)"\n");
                    this.m_txtsascommand.setToolTipText(this.m_sascommand_multiline);
                    this.m_btnReset.setEnabled(true);
                }
            } else {
                this.m_job.setName(resetJob.getName());
                this.m_job.setCommandLine(resetJob.getCommandLine(), resetJob.isCommandLineDerived());
                this.m_job.setCommandLineDerived(resetJob.isCommandLineDerived());
                this.m_job.setSchedulerProperties(resetJob.getSchedulerProperties());
                this.m_job.setSchedulerResources(resetJob.getSchedulerResources());
                this.m_job.setUserId(resetJob.getUserId());
            }
        } else {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.CannotConnectToShowAdvanceProperties.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.AdvanceDialog.Title.txt"), (int)0);
        }
    }
}

