/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.net.crypto.SealedString;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.FlowDefinitionPanel;
import com.sas.scheduler.schmgr.visuals.FlowHistoriesPanel;
import com.sas.scheduler.schmgr.visuals.JobRenderersPanel;
import com.sas.scheduler.schmgr.visuals.RunningJobsPanel;
import com.sas.scheduler.schmgr.visuals.ScheduledFlowsPanel;
import com.sas.scheduler.schmgr.visuals.ShowBufferDialog;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.LoginDialog;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.SchedulerServerPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class SchedulerConsolePanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SchedulerConsolePanel.class);
    private ScheduleManager m_schmgr;
    private Scheduler m_scheduler;
    private SchedulerServerInfo m_ssi;
    private SchedulerServerPanel m_pnlSchedulerServerPanel;
    private ScheduledFlowsPanel m_pnlScheduledFlowsPanel;
    private FlowHistoriesPanel m_pnlFlowHistoryPanel;
    private FlowDefinitionPanel m_pnlFlowDefinitionPanel;
    private RunningJobsPanel m_pnlRunningJobsPanel;
    private JobRenderersPanel m_pnlJobRenderersPanel;
    private String m_message = "";

    public SchedulerConsolePanel(ScheduleManager plugin, List<SchedulerServerInfo> serverList, String defaultSch) {
        this.m_schmgr = plugin;
        this._initialize(serverList, defaultSch);
        this._layout();
    }

    private void _initialize(List<SchedulerServerInfo> serverList, String defaultSch) {
        ArrayList<SchedulerServerInfo> myList;
        block9: {
            this.m_ssi = null;
            myList = new ArrayList<SchedulerServerInfo>(serverList);
            if (defaultSch != null) {
                try {
                    for (SchedulerServerInfo sinfo : serverList) {
                        if (!defaultSch.equalsIgnoreCase(sinfo.getName())) continue;
                        this.m_ssi = sinfo;
                        break;
                    }
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    this.m_message = ex.getLocalizedMessage();
                    if (this.m_message != null) break block9;
                    this.m_message = ex.toString();
                }
            }
        }
        myRefreshListener refreshListener = new myRefreshListener();
        myTriggerListener triggerListener = new myTriggerListener();
        myDeleteListener deleteListener = new myDeleteListener();
        myHoldListener holdListener = new myHoldListener();
        myReleaseListener releaseListener = new myReleaseListener();
        myKillListener killListener = new myKillListener();
        myStdoutListener stdoutListener = new myStdoutListener();
        myStderrListener stderrListener = new myStderrListener();
        this.m_pnlSchedulerServerPanel = new SchedulerServerPanel(myList, this.m_ssi);
        ArrayList<ScheduledFlowInfo> flows = null;
        ArrayList<RunHistory> jobs = null;
        List<JobRendererInfo> renderers = null;
        if (this.m_ssi != null) {
            flows = this.getFlows(this.m_ssi);
            jobs = this.getRunningJobs(this.m_ssi);
            if (this.m_ssi.hasJobRenderers()) {
                renderers = this.getRenderers(this.m_ssi);
            }
        } else {
            flows = new ArrayList();
            jobs = new ArrayList();
        }
        this.m_pnlScheduledFlowsPanel = new ScheduledFlowsPanel(flows, triggerListener, holdListener, releaseListener, deleteListener, refreshListener);
        List<FlowHistory> histories = null;
        this.m_pnlFlowHistoryPanel = new FlowHistoriesPanel(histories, refreshListener, triggerListener, killListener);
        this.m_pnlFlowDefinitionPanel = new FlowDefinitionPanel();
        this.m_pnlRunningJobsPanel = new RunningJobsPanel(jobs, refreshListener, stdoutListener, stderrListener, killListener);
        this.m_pnlJobRenderersPanel = new JobRenderersPanel(renderers);
        if (this.m_ssi != null && this.m_ssi.hasJobRenderers()) {
            this.m_pnlJobRenderersPanel.setEnabled(true);
        } else {
            this.m_pnlJobRenderersPanel.setEnabled(false);
        }
        ActionListener schedulerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulerConsolePanel.this.refreshScheduledFlows();
            }
        };
        this.m_pnlSchedulerServerPanel.addComboListener(schedulerListener);
        ActionListener flowListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScheduledFlowInfo flow = (ScheduledFlowInfo)e.getSource();
                if (flow != null) {
                    String str1 = m_bundle.getString("SchedulerConsolePanel.UpdateUIProgressIndicator.Message.txt");
                    String str2 = m_bundle.getString("SchedulerConsolePanel.UpdateUIProgressIndicator.Title.txt");
                    ProgressIndicator request = new ProgressIndicator(SchedulerConsolePanel.this.m_schmgr.getMainFrame(), str1, str2);
                    request.setDelayBeforeProgressCancelDialog(100);
                    CRunnable_UpdateFlowUI updateUI = new CRunnable_UpdateFlowUI(flow);
                    request.execute((Runnable)updateUI);
                }
            }
        };
        this.m_pnlScheduledFlowsPanel.setListener(flowListener);
    }

    private void refreshScheduledFlows() {
        SchedulerServerInfo sch = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (sch != null) {
            this.m_ssi = sch;
            IConsole console = this.getConsole(sch);
            if (console != null) {
                String str1 = m_bundle.getString("SchedulerConsolePanel.UpdateUIProgressIndicator.Message.txt");
                String str2 = m_bundle.getString("SchedulerConsolePanel.UpdateUIProgressIndicator.Title.txt");
                ProgressIndicator request = new ProgressIndicator(this.m_schmgr.getMainFrame(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(100);
                CRunnable_UpdateFlowsUI updateUI = new CRunnable_UpdateFlowsUI();
                request.execute((Runnable)updateUI);
            }
        } else if (ScheduleManager.isDebug()) {
            System.out.println("Failed to connect to scheduler.");
        }
    }

    private void _layout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints pnlSchedulerServerPanel_contraints = new GridBagConstraints();
        pnlSchedulerServerPanel_contraints.gridx = 0;
        pnlSchedulerServerPanel_contraints.gridy = 0;
        pnlSchedulerServerPanel_contraints.gridwidth = 4;
        pnlSchedulerServerPanel_contraints.gridheight = 1;
        pnlSchedulerServerPanel_contraints.weightx = 1.0;
        pnlSchedulerServerPanel_contraints.weighty = 1.0;
        pnlSchedulerServerPanel_contraints.anchor = 18;
        pnlSchedulerServerPanel_contraints.fill = 2;
        pnlSchedulerServerPanel_contraints.insets = new Insets(0, 0, 5, 0);
        pnlSchedulerServerPanel_contraints.ipadx = 0;
        pnlSchedulerServerPanel_contraints.ipady = 0;
        this.add((Component)this.m_pnlSchedulerServerPanel, pnlSchedulerServerPanel_contraints);
        GridBagConstraints pnlScheduledFlowsPanel_contraints = new GridBagConstraints();
        pnlScheduledFlowsPanel_contraints.gridx = 0;
        pnlScheduledFlowsPanel_contraints.gridy = 1;
        pnlScheduledFlowsPanel_contraints.gridwidth = 1;
        pnlScheduledFlowsPanel_contraints.gridheight = 3;
        pnlScheduledFlowsPanel_contraints.anchor = 18;
        pnlScheduledFlowsPanel_contraints.fill = 2;
        pnlScheduledFlowsPanel_contraints.insets = new Insets(0, 0, 0, 0);
        pnlScheduledFlowsPanel_contraints.ipadx = 0;
        pnlScheduledFlowsPanel_contraints.ipady = 0;
        this.add((Component)((Object)this.m_pnlScheduledFlowsPanel), pnlScheduledFlowsPanel_contraints);
        GridBagConstraints pnlFlowHistoryPanel_contraints = new GridBagConstraints();
        pnlFlowHistoryPanel_contraints.gridx = 1;
        pnlFlowHistoryPanel_contraints.gridy = 1;
        pnlFlowHistoryPanel_contraints.gridwidth = 2;
        pnlFlowHistoryPanel_contraints.gridheight = 3;
        pnlFlowHistoryPanel_contraints.anchor = 18;
        pnlFlowHistoryPanel_contraints.fill = 2;
        pnlFlowHistoryPanel_contraints.insets = new Insets(0, 0, 0, 0);
        pnlFlowHistoryPanel_contraints.ipadx = 0;
        pnlFlowHistoryPanel_contraints.ipady = 0;
        this.add((Component)((Object)this.m_pnlFlowHistoryPanel), pnlFlowHistoryPanel_contraints);
        GridBagConstraints pnlFlowDefinitionPanel_contraints = new GridBagConstraints();
        pnlFlowDefinitionPanel_contraints.gridx = 3;
        pnlFlowDefinitionPanel_contraints.gridy = 1;
        pnlFlowDefinitionPanel_contraints.gridwidth = 1;
        pnlFlowDefinitionPanel_contraints.gridheight = 2;
        pnlFlowDefinitionPanel_contraints.anchor = 18;
        pnlFlowDefinitionPanel_contraints.fill = 2;
        pnlFlowDefinitionPanel_contraints.insets = new Insets(0, 0, 0, 0);
        pnlFlowDefinitionPanel_contraints.ipadx = 0;
        pnlFlowDefinitionPanel_contraints.ipady = 0;
        this.add((Component)((Object)this.m_pnlFlowDefinitionPanel), pnlFlowDefinitionPanel_contraints);
        GridBagConstraints pnlRunningJobsPanel_contraints = new GridBagConstraints();
        pnlRunningJobsPanel_contraints.gridx = 3;
        pnlRunningJobsPanel_contraints.gridy = 3;
        pnlRunningJobsPanel_contraints.gridwidth = 1;
        pnlRunningJobsPanel_contraints.gridheight = 2;
        pnlRunningJobsPanel_contraints.anchor = 18;
        pnlRunningJobsPanel_contraints.fill = 2;
        pnlRunningJobsPanel_contraints.insets = new Insets(0, 0, 0, 0);
        pnlRunningJobsPanel_contraints.ipadx = 0;
        pnlRunningJobsPanel_contraints.ipady = 0;
        this.add((Component)((Object)this.m_pnlRunningJobsPanel), pnlRunningJobsPanel_contraints);
        GridBagConstraints pnlJobRenderersPanel_contraints = new GridBagConstraints();
        pnlJobRenderersPanel_contraints.gridx = 0;
        pnlJobRenderersPanel_contraints.gridy = 4;
        pnlJobRenderersPanel_contraints.gridwidth = 3;
        pnlJobRenderersPanel_contraints.gridheight = 1;
        pnlJobRenderersPanel_contraints.anchor = 18;
        pnlJobRenderersPanel_contraints.fill = 2;
        pnlJobRenderersPanel_contraints.insets = new Insets(0, 0, 0, 0);
        pnlJobRenderersPanel_contraints.ipadx = 0;
        pnlJobRenderersPanel_contraints.ipady = 0;
        this.add((Component)((Object)this.m_pnlJobRenderersPanel), pnlJobRenderersPanel_contraints);
    }

    public SchedulerServerInfo getScheduler() {
        if (this.m_pnlSchedulerServerPanel != null) {
            return this.m_pnlSchedulerServerPanel.getSelectedServer();
        }
        return null;
    }

    public boolean validateData() {
        if (this.m_pnlSchedulerServerPanel != null) {
            return this.m_pnlSchedulerServerPanel.validateData();
        }
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    private IConsole getConsole(SchedulerServerInfo sch) {
        block8: {
            if (this.m_scheduler != null && this.m_scheduler.isConnected() && this.m_scheduler.getServerComponent().getId().equals(sch.getId())) {
                IConsole console = (IConsole)this.m_scheduler;
                return console;
            }
            if (this.m_scheduler == null || !this.m_scheduler.getServerComponent().getId().equals(sch.getId())) {
                try {
                    ServerUtilities serverUtil = this.m_schmgr.getServerUtilities();
                    this.m_scheduler = serverUtil.getSchedulingServer(sch);
                }
                catch (SchedulerException e) {
                    if (!ScheduleManager.isDebug()) break block8;
                    System.err.println("ERROR: getFlows: " + e.toString());
                }
            }
        }
        if (this.m_scheduler.isConnected()) {
            IConsole console = (IConsole)this.m_scheduler;
            return console;
        }
        boolean keepTrying = true;
        String user = sch.getUsername();
        SealedString pass = ((SchedulerIMPL)this.m_scheduler).getSchServerInfoPasswordSealedString();
        while (keepTrying) {
            if (this.m_schmgr.connectToSchedulingServer(sch, user, pass)) {
                keepTrying = false;
                IConsole console = (IConsole)this.m_scheduler;
                return console;
            }
            String loginTitle = m_bundle.messageString("SchedulerConsolePanel.Logon.title.fmt", (Object)sch.getName());
            LoginDialog dialog = new LoginDialog(this.m_schmgr.getMainFrame(), loginTitle);
            dialog.setUserName(sch.getUsername());
            dialog.setPasswordSealedString(((SchedulerIMPL)this.m_scheduler).getSchServerInfoPasswordSealedString());
            dialog.makeVisible();
            if (dialog.getReturnValue() == 1) {
                user = dialog.getUserName();
                pass = dialog.getPasswordSealedString();
                if (!this.m_schmgr.isAllowPasswordCache()) continue;
                sch.setUsername(user);
                sch.setPassword(pass != null ? String.valueOf(pass.getCharacters()) : null);
                continue;
            }
            if (dialog.getReturnValue() != 2) continue;
            keepTrying = false;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ScheduledFlowInfo> getFlows(SchedulerServerInfo sch) {
        IConsole console = this.getConsole(sch);
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (console != null) {
                List list = console.getScheduledFlows(sch.getId(), sch.getUsername());
                return list;
            }
            List<ScheduledFlowInfo> list = null;
            return list;
        }
        catch (Exception e) {
            List<ScheduledFlowInfo> list = null;
            return list;
        }
        finally {
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FlowHistory> getHistories(ScheduledFlowInfo flow) {
        ArrayList<FlowHistory> list;
        block10: {
            list = new ArrayList<FlowHistory>();
            SchedulerServerInfo sch = this.getScheduler();
            IConsole console = this.getConsole(sch);
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (console != null) {
                    List histories = console.getFlowHistoryList(flow.getName(), flow.getScheduledUserIdDataBinding(), 0);
                    if (histories != null && histories.size() > 0) {
                        for (com.sas.scheduler.api.servers.FlowHistory hist : histories) {
                            GregorianCalendar time;
                            if (!hist.getFlowName().equals(flow.getName())) continue;
                            FlowHistory history = new FlowHistory();
                            history.setFlowNameDataBinding(hist.getFlowName());
                            history.setErrorCodeDataBinding(hist.getErrorCode());
                            history.setInstanceNameDataBinding(hist.getInstanceName());
                            history.setSchedulerFlowNameDataBinding(hist.getSchedulerFlowName());
                            history.setStateDataBinding(hist.getState());
                            history.setStatusDataBinding(hist.getStatus());
                            history.setIdDataBinding(hist.getID());
                            if (hist.getStartTime() != null) {
                                time = new GregorianCalendar();
                                time.setTime(hist.getStartTime());
                                history.setStartTimeDataBinding((Calendar)time);
                            }
                            if (hist.getFinishTime() != null) {
                                time = new GregorianCalendar();
                                time.setTime(hist.getFinishTime());
                                history.setFinishTimeDataBinding((Calendar)time);
                            }
                            list.add(history);
                        }
                    }
                    break block10;
                }
                List<FlowHistory> histories = null;
                return histories;
            }
            catch (Exception e) {
                List<FlowHistory> list2 = null;
                return list2;
            }
            finally {
                this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInfo(ScheduledFlowInfo flow) {
        SchedulerServerInfo sch = this.getScheduler();
        IConsole console = this.getConsole(sch);
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (console != null && flow.getFlowDefinitionIdDataBinding() != null) {
                String string = console.getFlowDefinition(flow.getFlowDefinitionIdDataBinding());
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RunHistory> getRunningJobs(SchedulerServerInfo sch) {
        IConsole console = this.getConsole(sch);
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (console != null) {
                List list = console.getRunningJobs(sch.getId(), sch.getUsername());
                return list;
            }
            List<RunHistory> list = null;
            return list;
        }
        catch (Exception e) {
            List<RunHistory> list = null;
            return list;
        }
        finally {
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobRendererInfo> getRenderers(SchedulerServerInfo sch) {
        List retValue = null;
        IConsole console = this.getConsole(sch);
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            retValue = console != null ? console.getJobRenderers(sch.getId()) : new ArrayList();
        }
        catch (Exception e) {
            List<JobRendererInfo> list = null;
            return list;
        }
        finally {
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
        return retValue;
    }

    private class myRefreshListener
    implements ActionListener {
        private myRefreshListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (ae.getSource() instanceof FlowHistory) {
                try {
                    ScheduledFlowInfo flow = SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.getSelectedFlow();
                    if (flow == null) return;
                    List histories = SchedulerConsolePanel.this.getHistories(flow);
                    SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(histories);
                    return;
                }
                finally {
                    SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (ae.getSource() instanceof ScheduledFlowInfo) {
                List flows = SchedulerConsolePanel.this.getFlows(SchedulerConsolePanel.this.m_ssi);
                SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.setFlows(flows);
                return;
            }
            if (!(ae.getSource() instanceof RunHistory)) return;
            try {
                List jobs = SchedulerConsolePanel.this.getRunningJobs(SchedulerConsolePanel.this.m_ssi);
                SchedulerConsolePanel.this.m_pnlRunningJobsPanel.setJobs(jobs);
                return;
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myTriggerListener
    implements ActionListener {
        private myTriggerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                List histories;
                ScheduledFlowInfo flow = null;
                String flowDefId = "";
                Object obj = ae.getSource();
                if (obj instanceof ScheduledFlowInfo) {
                    flow = (ScheduledFlowInfo)obj;
                    flowDefId = flow.getFlowDefinitionIdDataBinding();
                } else if (obj instanceof FlowHistory) {
                    flow = SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.getSelectedFlow();
                    flowDefId = flow.getFlowDefinitionIdDataBinding();
                }
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                boolean rc = console.triggerFlow(flowDefId);
                if (rc && (histories = SchedulerConsolePanel.this.getHistories(flow)) != null) {
                    SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(histories);
                }
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myDeleteListener
    implements ActionListener {
        private myDeleteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                ScheduledFlowInfo flow;
                boolean rc;
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                Object obj = ae.getSource();
                if (obj instanceof ScheduledFlowInfo && (rc = console.deleteFlow((flow = (ScheduledFlowInfo)obj).getFlowDefinitionIdDataBinding()))) {
                    SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.removeFlow(flow);
                    SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(null);
                    SchedulerConsolePanel.this.m_pnlFlowDefinitionPanel.setText("");
                }
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myHoldListener
    implements ActionListener {
        private myHoldListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                ScheduledFlowInfo flow = (ScheduledFlowInfo)ae.getSource();
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                try {
                    console.holdFlow(flow.getFlowDefinitionIdDataBinding());
                    flow.setDisplayOnly(true);
                    SchedulerConsolePanel.this.refreshScheduledFlows();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myReleaseListener
    implements ActionListener {
        private myReleaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                ScheduledFlowInfo flow = (ScheduledFlowInfo)ae.getSource();
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                console.releaseFlow(flow.getFlowDefinitionIdDataBinding());
                flow.setDisplayOnly(false);
                SchedulerConsolePanel.this.refreshScheduledFlows();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myKillListener
    implements ActionListener {
        private myKillListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                ScheduledFlowInfo flow;
                FlowHistory hist;
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                Object obj = ae.getSource();
                boolean rc = false;
                if (obj instanceof ScheduledFlowInfo) {
                    ScheduledFlowInfo flow2 = (ScheduledFlowInfo)ae.getSource();
                    rc = console.killFlowInstance(flow2.getScheduleIdDataBinding());
                    if (rc) {
                        List flows = SchedulerConsolePanel.this.getFlows(SchedulerConsolePanel.this.m_ssi);
                        SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.setFlows(flows);
                    }
                } else if (obj instanceof FlowHistory && (rc = console.killFlowInstance((hist = (FlowHistory)ae.getSource()).getInstanceName())) && (flow = SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.getSelectedFlow()) != null) {
                    List histories = SchedulerConsolePanel.this.getHistories(flow);
                    SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(histories);
                }
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myStdoutListener
    implements ActionListener {
        private myStdoutListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                RunHistory history = (RunHistory)ae.getSource();
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                StringBuffer buf = console.getStandardOut(history.getParentNameDataBinding(), history.getUniqueIdDataBinding());
                String title = m_bundle.getString("SchedulerConsolePanel.Stdout.Title.txt");
                ShowBufferDialog dia = new ShowBufferDialog(SchedulerConsolePanel.this.m_schmgr, buf, title);
                dia.makeVisible();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myStderrListener
    implements ActionListener {
        private myStderrListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                RunHistory history = (RunHistory)ae.getSource();
                IConsole console = SchedulerConsolePanel.this.getConsole(SchedulerConsolePanel.this.m_pnlSchedulerServerPanel.getSelectedServer());
                StringBuffer buf = console.getStandardError(history.getParentNameDataBinding(), history.getUniqueIdDataBinding());
                String title = m_bundle.getString("SchedulerConsolePanel.Stderr.Title.txt");
                ShowBufferDialog dia = new ShowBufferDialog(SchedulerConsolePanel.this.m_schmgr, buf, title);
                dia.makeVisible();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
            finally {
                SchedulerConsolePanel.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class CRunnable_UpdateFlowsUI
    implements Runnable {
        @Override
        public void run() {
            SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.setFlows(null);
            List flows = SchedulerConsolePanel.this.getFlows(SchedulerConsolePanel.this.m_ssi);
            SchedulerConsolePanel.this.m_pnlScheduledFlowsPanel.setFlows(flows);
            SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(null);
            SchedulerConsolePanel.this.m_pnlFlowDefinitionPanel.setText("");
            List jobs = SchedulerConsolePanel.this.getRunningJobs(SchedulerConsolePanel.this.m_ssi);
            if (jobs != null) {
                SchedulerConsolePanel.this.m_pnlRunningJobsPanel.setJobs(jobs);
            }
            if (SchedulerConsolePanel.this.m_ssi.hasJobRenderers()) {
                List renderers = SchedulerConsolePanel.this.getRenderers(SchedulerConsolePanel.this.m_ssi);
                if (renderers != null) {
                    SchedulerConsolePanel.this.m_pnlJobRenderersPanel.setJobRenderers(renderers);
                }
                SchedulerConsolePanel.this.m_pnlJobRenderersPanel.setEnabled(true);
            } else {
                SchedulerConsolePanel.this.m_pnlJobRenderersPanel.setJobRenderers(null);
                SchedulerConsolePanel.this.m_pnlJobRenderersPanel.setEnabled(false);
            }
        }
    }

    private class CRunnable_UpdateFlowUI
    implements Runnable {
        ScheduledFlowInfo mc_flow;

        public CRunnable_UpdateFlowUI(ScheduledFlowInfo flow) {
            this.mc_flow = flow;
        }

        @Override
        public void run() {
            String text;
            List histories = SchedulerConsolePanel.this.getHistories(this.mc_flow);
            if (histories != null) {
                SchedulerConsolePanel.this.m_pnlFlowHistoryPanel.setHistories(histories);
            }
            if ((text = SchedulerConsolePanel.this.getInfo(this.mc_flow)) != null) {
                SchedulerConsolePanel.this.m_pnlFlowDefinitionPanel.setText(text);
            }
        }
    }
}

