/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.SchedulerConsolePanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import java.util.List;

public class SchedulerConsoleDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SchedulerConsoleDialog.class);
    private ScheduleManager m_plugin;
    private SchedulerConsolePanel m_pnlSchedulerConsolePanel;
    List<SchedulerServerInfo> m_schedulers;

    public SchedulerConsoleDialog(ScheduleManager plugin, List<SchedulerServerInfo> schedulers) {
        super(plugin.getMainFrame(), m_bundle.getString("SchedulerConsoleDialog.Title.txt"), false);
        this.m_plugin = plugin;
        this.m_schedulers = schedulers;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("");
        this.init();
    }

    private void init() {
        this.setCancelButtonVisible(false);
        this.setApplyButtonVisible(false);
        this.m_pnlSchedulerConsolePanel = new SchedulerConsolePanel(this.m_plugin, this.m_schedulers, this.m_plugin.getLastSchedulingServer());
        this.setMainPanel(this.m_pnlSchedulerConsolePanel);
    }

    protected boolean validateData() {
        if (this.m_pnlSchedulerConsolePanel != null) {
            if (this.m_pnlSchedulerConsolePanel.validateData()) {
                SchedulerServerInfo lastSchedulingServer = this.m_pnlSchedulerConsolePanel.getScheduler();
                if (lastSchedulingServer != null) {
                    this.m_plugin.setLastSchedulingServer(lastSchedulingServer.getId());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean onOK() throws SchedulerException {
        return this.validateData() && super.onOK();
    }

    public void dispose() {
        if (this.m_pnlSchedulerConsolePanel != null) {
            this.m_pnlSchedulerConsolePanel.saveSettingsAndCleanUp();
        }
        this.m_pnlSchedulerConsolePanel = null;
        super.dispose();
    }
}

