/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPropertyTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PlatformComputingOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(PlatformComputingOptionsTab.class);
    private UserOptions m_userOptions;
    private JTextField m_flowOutputDir;
    private JTextField m_defaultStdout;
    private JTextField m_defaultStderr;
    private JCheckBox m_timezone;
    private JCheckBox m_appServerResource;
    private JCheckBox m_portableTimeEvent;
    private JCheckBox m_scoping;

    public PlatformComputingOptionsTab(UserOptions userOptions) {
        this.m_userOptions = userOptions;
        this.setName(m_bundle.getString("PlatformComputingOptionsTab.Name.txt"));
        this.setHelpProduct("scheduler");
        this.setHelpTopic("platform_sched_tab");
        this._initialize();
    }

    public void moveDataToView() {
        this.m_flowOutputDir.setText(this.m_userOptions.getFlowDefinitionDirectory());
        this.m_flowOutputDir.setToolTipText(this.m_userOptions.getFlowDefinitionDirectory());
        this.m_defaultStdout.setText(this.m_userOptions.getDefaultStandardOutfile());
        this.m_defaultStdout.setToolTipText(this.m_userOptions.getDefaultStandardOutfile());
        this.m_defaultStderr.setText(this.m_userOptions.getDefaultStandardErrfile());
        this.m_defaultStderr.setToolTipText(this.m_userOptions.getDefaultStandardErrfile());
        this.m_timezone.setSelected(this.m_userOptions.isTimezoneOrientationToClient());
        this.m_appServerResource.setSelected(this.m_userOptions.isAppServerResource());
        this.m_portableTimeEvent.setSelected(this.m_userOptions.usePortableTimeEvent());
        this.m_scoping.setSelected(this.m_userOptions.useFlowScoping());
    }

    public void moveDataToStore() {
        this.m_userOptions.setFlowDefinitionDirectory(this.m_flowOutputDir.getText());
        this.m_userOptions.setDefaultStandardOutfile(this.m_defaultStdout.getText());
        this.m_userOptions.setDefaultStandardErrfile(this.m_defaultStderr.getText());
        this.m_userOptions.setTimezoneOrientationToClient(this.m_timezone.isSelected());
        this.m_userOptions.setAppServerResource(this.m_appServerResource.isSelected());
        this.m_userOptions.setPortableTimeEvent(this.m_portableTimeEvent.isSelected());
        this.m_userOptions.setFlowScoping(this.m_scoping.isSelected());
        this.m_userOptions.saveExisting();
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _initialize() {
        this.m_flowOutputDir = new JTextField();
        String outdirText = m_bundle.getString("PlatformComputingOptionsTab.FlowOutputDir.Label.txt");
        JLabel outdirLabel = new JLabel(Util.getLabelWithoutMnemonic((String)outdirText));
        outdirLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)outdirText));
        outdirLabel.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.FlowOutputDir.ToolTip.txt"));
        outdirLabel.setLabelFor(this.m_flowOutputDir);
        this.m_defaultStdout = new JTextField();
        String stdoutText = m_bundle.getString("PlatformComputingOptionsTab.Stdout.Label.txt");
        JLabel stdoutLabel = new JLabel(Util.getLabelWithoutMnemonic((String)stdoutText));
        stdoutLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)stdoutText));
        stdoutLabel.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.Stdout.ToolTip.txt"));
        stdoutLabel.setLabelFor(this.m_defaultStdout);
        this.m_defaultStderr = new JTextField();
        String stderrText = m_bundle.getString("PlatformComputingOptionsTab.Stderr.Label.txt");
        JLabel stderrLabel = new JLabel(Util.getLabelWithoutMnemonic((String)stderrText));
        stderrLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)stderrText));
        stderrLabel.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.Stderr.ToolTip.txt"));
        stderrLabel.setLabelFor(this.m_defaultStderr);
        this.m_timezone = new JCheckBox(m_bundle.getString("PlatformComputingOptionsTab.TimezoneOrientation.txt"));
        this.m_timezone.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.TimezoneOrientation.ToolTip.txt"));
        this.m_appServerResource = new JCheckBox(m_bundle.getString("PlatformComputingOptionsTab.AppServerResource.txt"));
        this.m_appServerResource.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.AppServerResource.ToolTip.txt"));
        this.m_portableTimeEvent = new JCheckBox(m_bundle.getString("PlatformComputingOptionsTab.PortableTimeEvent.txt"));
        this.m_portableTimeEvent.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.PortableTimeEvent.ToolTip.txt"));
        this.m_scoping = new JCheckBox(m_bundle.getString("PlatformComputingOptionsTab.Scoping.txt"));
        this.m_scoping.setToolTipText(m_bundle.getString("PlatformComputingOptionsTab.Scoping.ToolTip.txt"));
        this.setLayout(new GridBagLayout());
        this.add(outdirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_flowOutputDir, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(stdoutLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_defaultStdout, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(stderrLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_defaultStderr, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_timezone, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_appServerResource, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_portableTimeEvent, new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_scoping, new GridBagConstraints(0, 6, 4, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 7, 4, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
    }
}

