/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.DataStepProgramRedeployerAction;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ListOfJobs;
import com.sas.scheduler.schmgr.PropertyAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SetBatchServerAction;
import com.sas.scheduler.schmgr.SetJobAction;
import com.sas.scheduler.schmgr.visuals.SetBatchServerDialog;
import com.sas.scheduler.schmgr.visuals.SetJobDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MaxDimension;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ManageJobDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ManageJobDialog.class);
    private boolean m_isRemoved = false;
    private DefaultTreeModel m_treeModel;
    private JTree m_tree;
    private Frame m_frame;
    private ScheduleManager m_schmgr;
    private static HashMap<String, JobNode> m_jobNodeList = new HashMap();

    public ManageJobDialog(ScheduleManager plugin) {
        super(plugin.getMainFrame(), m_bundle.getString("ManageJobDialog.Title.txt"), true);
        this.m_frame = plugin.getMainFrame();
        this.m_schmgr = plugin;
        this.__initialize(plugin);
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_manage_jobs");
    }

    public void dispose() {
        super.dispose();
        this.m_tree = null;
        this.m_treeModel = null;
    }

    public boolean isRemoved() {
        return this.m_isRemoved;
    }

    private void removeData(DefaultMutableTreeNode node) throws SchedulerException {
        ServerJobInfo info = (ServerJobInfo)node.getUserObject();
        info.delete();
        this.m_treeModel.removeNodeFromParent(node);
        node.setUserObject(null);
        node.setParent(null);
        info.commitChangesToOMR();
    }

    private void __initialize(ScheduleManager plugin) {
        StandardPanel mainPanel = new StandardPanel();
        JScrollPane scrollpane = null;
        JLabel textmsg1 = new JLabel(m_bundle.getString("ManageJobDialog.Info1.txt"));
        JLabel textmsg2 = new JLabel(m_bundle.getString("ManageJobDialog.Info2.txt"));
        JButton setServerbtn = new JButton(m_bundle.getString("ManageJobDialog.Button.SetServer.txt"));
        JButton setJobbtn = new JButton(m_bundle.getString("ManageJobDialog.Button.SetJob.txt"));
        JButton redeploybtn = new JButton(m_bundle.getString("ManageJobDialog.Button.Redeploy.txt"));
        JButton deletebtn = new JButton(m_bundle.getString("ManageJobDialog.Button.Delete.txt"));
        try {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(m_bundle.getString("ManageJobDialog.TreeTopName.txt"));
            this.m_treeModel = new DefaultTreeModel(top);
            DefaultMutableTreeNode inFlows = new DefaultMutableTreeNode(m_bundle.getString("ManageJobDialog.TreeInFlowsName.txt"));
            DefaultMutableTreeNode notInFlow = new DefaultMutableTreeNode(m_bundle.getString("ManageJobDialog.TreeNotInFlowsName.txt"));
            top.add(inFlows);
            top.add(notInFlow);
            String str1 = m_bundle.getString("ManageJobDialog.BuildMetadataProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("ManageJobDialog.ProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(this.m_frame, str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            ListOfJobs jobs = new ListOfJobs(this.m_schmgr, null, true, false);
            request.execute((Runnable)jobs);
            if (jobs.isError()) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)jobs.getErrorMessage(), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
            }
            request.setMessage(m_bundle.getString("ManageJobDialog.BuildTreeProgressIndicator.Message.txt"));
            CRunnable build = new CRunnable(jobs, plugin, top, inFlows, notInFlow);
            request.execute((Runnable)build);
            this.m_tree = new JTree(this.m_treeModel);
            this.m_tree.setEditable(false);
            this.m_tree.setScrollsOnExpand(true);
            this.m_tree.setCellRenderer(new cMyRenderer());
            this.m_tree.addTreeSelectionListener(new cSelectionListener());
            this.m_tree.addMouseListener(new cMouseListener());
            this.m_tree.expandPath(new TreePath(inFlows.getPath()));
            this.m_tree.expandPath(new TreePath(notInFlow.getPath()));
            scrollpane = new JScrollPane(this.m_tree, 20, 30);
            scrollpane.setPreferredSize(new Dimension(200, 350));
            setServerbtn.addActionListener(new defaultActionListener(3));
            setJobbtn.addActionListener(new defaultActionListener(2));
            redeploybtn.addActionListener(new defaultActionListener(1));
            deletebtn.addActionListener(new deleteActionListener());
            MaxDimension dim = new MaxDimension(0, 0);
            dim.max(setServerbtn.getPreferredSize());
            dim.max(setJobbtn.getPreferredSize());
            dim.max(redeploybtn.getPreferredSize());
            dim.max(deletebtn.getPreferredSize());
            setServerbtn.setPreferredSize((Dimension)dim);
            setJobbtn.setPreferredSize((Dimension)dim);
            redeploybtn.setPreferredSize((Dimension)dim);
            deletebtn.setPreferredSize((Dimension)dim);
        }
        catch (RuntimeException ex) {
            String message = ex.toString();
            String lmessage = ex.getLocalizedMessage();
            if (lmessage != null && lmessage.length() > 0) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)lmessage, (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
        }
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        mainPanel.add((Component)textmsg1, (Object)new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
        mainPanel.add((Component)textmsg2, (Object)new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        mainPanel.add(scrollpane, (Object)new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 5, 0), 0, 0));
        mainPanel.add((Component)setServerbtn, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 15, 10, 0), 0, 0));
        mainPanel.add((Component)setJobbtn, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        mainPanel.add((Component)redeploybtn, (Object)new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        mainPanel.add((Component)deletebtn, (Object)new GridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.setMainPanel(mainPanel);
    }

    private static class CRunnable
    implements Runnable {
        ListOfJobs mc_jobs;
        ScheduleManager mc_schmgr;
        DefaultMutableTreeNode mc_top;
        DefaultMutableTreeNode mc_inFlows;
        DefaultMutableTreeNode mc_notInFlow;

        public CRunnable(ListOfJobs jobs, ScheduleManager plugin, DefaultMutableTreeNode top, DefaultMutableTreeNode inFlows, DefaultMutableTreeNode notInFlow) {
            this.mc_jobs = jobs;
            this.mc_schmgr = plugin;
            this.mc_top = top;
            this.mc_inFlows = inFlows;
            this.mc_notInFlow = notInFlow;
        }

        @Override
        public void run() {
            ServerJobInfo job = null;
            List<JobInfo> jobList = this.mc_jobs.getList();
            int len = jobList.size();
            for (int i = 0; i < len; ++i) {
                job = new ServerJobInfo((DisplayInfo)jobList.get(i), null, this.mc_schmgr.getServerUtilities());
                m_jobNodeList.put(job.getId(), new JobNode((PluginNavigationInterface)this.mc_schmgr, job.getName(), job));
                DefaultMutableTreeNode jobNode = null;
                try {
                    job.reevaluateErrors();
                    jobNode = new DefaultMutableTreeNode(job);
                    List flows = job.getListOfFlows();
                    int num = flows.size();
                    if (num > 0) {
                        this.mc_inFlows.add(jobNode);
                        for (int j = 0; j < num; ++j) {
                            ServerFlowInfo flow = (ServerFlowInfo)flows.get(j);
                            DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(flow);
                            flowNode.setAllowsChildren(false);
                            jobNode.add(flowNode);
                        }
                        continue;
                    }
                    this.mc_notInFlow.add(jobNode);
                    continue;
                }
                catch (SchedulerException re) {
                    jobNode = new DefaultMutableTreeNode(m_bundle.getString("ManageJobDialog.AbortMessage.txt"));
                    this.mc_top.add(jobNode);
                    DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(re.getMessage());
                    jobNode.add(flowNode);
                    break;
                }
            }
        }
    }

    private static class cMyRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasfocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasfocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof ServerFlowInfo) {
                ServerFlowInfo flow = (ServerFlowInfo)node.getUserObject();
                try {
                    this.setIcon((Icon)IconUtil.getIcon((String)FlowInfo.getIconName((boolean)flow.isFlowSubmitted(), (boolean)flow.hasErrors())));
                }
                catch (RuntimeException ex) {
                    this.setIcon((Icon)IconUtil.getIcon((String)IconUtil.NODE_Flow));
                }
                this.setEnabled(false);
            } else if (node.getUserObject() instanceof ServerJobInfo) {
                ServerJobInfo job = (ServerJobInfo)node.getUserObject();
                this.setIcon(job.getIcon());
                String tip = job.getBatchServerName();
                this.setToolTipText(tip != null ? tip : "");
            } else {
                this.setEnabled(false);
            }
            return this;
        }
    }

    private class cSelectionListener
    implements TreeSelectionListener {
        private cSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            TreePath[] spaths = ManageJobDialog.this.m_tree.getSelectionPaths();
            TreePath[] tpaths = null;
            if (spaths != null) {
                int index = 0;
                int num = spaths.length;
                tpaths = new TreePath[num];
                for (int i = 0; i < num; ++i) {
                    TreePath path = spaths[i];
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(obj instanceof ServerJobInfo)) continue;
                    tpaths[index++] = path;
                }
            } else {
                tpaths = new TreePath[]{};
            }
            ManageJobDialog.this.m_tree.setSelectionPaths(tpaths);
        }
    }

    private class cMouseListener
    implements MouseListener {
        private cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int selectedRow;
            if ((e.getModifiers() & 4) != 0 && (selectedRow = ManageJobDialog.this.m_tree.getRowForLocation(e.getX(), e.getY())) != -1) {
                TreePath[] paths = ManageJobDialog.this.m_tree.getSelectionPaths();
                int num = paths != null ? paths.length : 0;
                for (int i = 0; i < num; ++i) {
                    TreePath path = paths[i];
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(obj instanceof ServerJobInfo)) continue;
                    ServerJobInfo info = (ServerJobInfo)obj;
                    JobNode jobnode = (JobNode)((Object)m_jobNodeList.get(info.getId()));
                    info.m_info = null;
                    jobnode.refresh();
                }
                JPopupMenu popMenu = this._buildPopupMenu(paths);
                popMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu _buildPopupMenu(TreePath[] paths) {
            ToolTipStrippingJPopupMenu popMenu = new ToolTipStrippingJPopupMenu();
            if (paths == null) {
                return popMenu;
            }
            int num = paths.length;
            if (num > 1) {
                Object[] elements = new ServerJobInfo[num];
                for (int i = 0; i < num; ++i) {
                    TreePath path = paths[i];
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(obj instanceof ServerJobInfo)) continue;
                    ServerJobInfo info = (ServerJobInfo)obj;
                    elements[i] = info;
                }
                SetBatchServerAction batchAction = new SetBatchServerAction(elements, ManageJobDialog.this.m_schmgr);
                popMenu.add(batchAction);
                SetJobAction jobAction = new SetJobAction(elements, ManageJobDialog.this.m_schmgr);
                popMenu.add(jobAction);
                ArrayList<Object> neojoblist = new ArrayList<Object>();
                for (int i = 0; i < elements.length; ++i) {
                    Object jobinfo = elements[i];
                    if (jobinfo.isRedeployable()) {
                        neojoblist.add(jobinfo);
                        continue;
                    }
                    MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)m_bundle.messageString("ManageJobDialog.Not.Redeployable.fmt", (Object)jobinfo.getName()), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)2, (int)-1);
                }
                if (elements.length != neojoblist.size()) {
                    elements = neojoblist.toArray(new ServerJobInfo[neojoblist.size()]);
                }
                DataStepProgramRedeployerAction reAction = new DataStepProgramRedeployerAction(elements, ManageJobDialog.this.m_schmgr);
                popMenu.add(reAction);
                popMenu.add(new deleteActionListener());
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                if (node.getUserObject() instanceof ServerJobInfo) {
                    ServerJobInfo info = (ServerJobInfo)node.getUserObject();
                    JobNode jobnode = (JobNode)((Object)m_jobNodeList.get(info.getId()));
                    SetBatchServerAction batchAction = new SetBatchServerAction(info, ManageJobDialog.this.m_schmgr, jobnode);
                    popMenu.add(batchAction);
                    SetJobAction jobAction = new SetJobAction(info, ManageJobDialog.this.m_schmgr, jobnode);
                    popMenu.add(jobAction);
                    if (info.isRedeployable()) {
                        DataStepProgramRedeployerAction reAction = new DataStepProgramRedeployerAction(info, ManageJobDialog.this.m_schmgr, jobnode);
                        popMenu.add(reAction);
                    }
                    popMenu.add(new deleteActionListener());
                    PropertyAction propertiesAction = new PropertyAction(jobnode, ManageJobDialog.this.m_schmgr);
                    popMenu.add(propertiesAction);
                }
            }
            return popMenu;
        }
    }

    private class defaultActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int mc_type = 0;

        public defaultActionListener(int type) {
            this.mc_type = type;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreePath[] spaths = ManageJobDialog.this.m_tree.getSelectionPaths();
            if (spaths == null) {
                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)m_bundle.getString("ManageJobDialog.NoSelection.txt"), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)2, (int)-1);
                return;
            }
            boolean found = false;
            Object[] joblist = null;
            int numJobs = spaths.length;
            if (numJobs > 0) {
                joblist = new ServerJobInfo[spaths.length];
                for (int i = 0; i < spaths.length; ++i) {
                    TreePath path = spaths[i];
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(obj instanceof ServerJobInfo)) continue;
                    ServerJobInfo jobinfo = (ServerJobInfo)obj;
                    joblist[i] = jobinfo;
                    found = true;
                }
            }
            try {
                if (found) {
                    switch (this.mc_type) {
                        case 1: {
                            ArrayList<Object> neojoblist = new ArrayList<Object>();
                            for (int i = 0; i < joblist.length; ++i) {
                                Object jobinfo = joblist[i];
                                if (jobinfo.isRedeployable()) {
                                    neojoblist.add(jobinfo);
                                    continue;
                                }
                                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)m_bundle.messageString("ManageJobDialog.Not.Redeployable.fmt", (Object)jobinfo.getName()), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)2, (int)-1);
                            }
                            if (joblist.length != neojoblist.size()) {
                                joblist = neojoblist.toArray(new ServerJobInfo[neojoblist.size()]);
                            }
                            DataStepProgramRedeployerAction newAction = new DataStepProgramRedeployerAction(joblist, ManageJobDialog.this.m_schmgr);
                            newAction.actionPerformed(null);
                            break;
                        }
                        case 2: {
                            StandardDialog dialog2;
                            try {
                                dialog2 = new SetJobDialog(ManageJobDialog.this.m_schmgr, joblist);
                                dialog2.makeVisible();
                            }
                            catch (NoSuchElementException dialog2) {
                            }
                            catch (RuntimeException ex) {
                                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
                            }
                            catch (RemoteException ex) {
                                if (!ScheduleManager.isDebug()) break;
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case 3: {
                            StandardDialog dialog2;
                            try {
                                dialog2 = new SetBatchServerDialog(ManageJobDialog.this.m_schmgr, joblist);
                                dialog2.makeVisible();
                            }
                            catch (RuntimeException ex) {
                                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
                            }
                            catch (RemoteException ex) {
                                if (!ScheduleManager.isDebug()) break;
                                ex.printStackTrace();
                            }
                            break;
                        }
                        default: {
                            RuntimeException ex = new RuntimeException();
                            ex.printStackTrace();
                        }
                    }
                    ManageJobDialog.this.m_tree.updateUI();
                }
            }
            catch (RuntimeException ex) {
                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
            }
        }
    }

    private class deleteActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public deleteActionListener() {
            String nameText = m_bundle.getString("ManageJobDialog.DeleteJobAction.Name.txt");
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
            this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Delete));
            this.putValue("ShortDescription", m_bundle.getString("ManageJobDialog.DeleteJobAction.ShortDescription.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreePath[] spaths = ManageJobDialog.this.m_tree.getSelectionPaths();
            if (spaths == null) {
                MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)m_bundle.getString("ManageJobDialog.NoSelection.txt"), (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)2, (int)-1);
                return;
            }
            int response1 = JOptionPane.showConfirmDialog(ManageJobDialog.this.m_frame, m_bundle.messageString("ManageJobDialog.DeleteConfirmation.fmt", (Object)String.valueOf(spaths.length)), m_bundle.getString("ManageJobDialog.Title.txt"), 0);
            if (response1 == 1) {
                return;
            }
            String str1 = m_bundle.getString("ManageJobDialog.DeleteProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("ManageJobDialog.ProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(ManageJobDialog.this.m_frame, str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            CRunnableDelete doDeletes = new CRunnableDelete(spaths);
            request.execute((Runnable)doDeletes);
        }
    }

    private class CRunnableDelete
    implements Runnable {
        private TreePath[] mc_spaths;

        public CRunnableDelete(TreePath[] spaths) {
            this.mc_spaths = spaths;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.mc_spaths.length; ++i) {
                TreePath path = this.mc_spaths[i];
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = node.getUserObject();
                if (!(obj instanceof ServerJobInfo)) continue;
                try {
                    ManageJobDialog.this.removeData(node);
                    continue;
                }
                catch (SchedulerException ex) {
                    String message = ex.toString();
                    String lmessage = ex.getLocalizedMessage();
                    if (lmessage != null && lmessage.length() > 0) {
                        MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)lmessage, (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
                        continue;
                    }
                    MessageUtil.displayMessage((Frame)ManageJobDialog.this.m_frame, (String)message, (String)m_bundle.getString("ManageJobDialog.Title.txt"), (int)0, (int)-1);
                }
            }
        }
    }
}

