/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.ui.JFExceptionHandlerBean;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class LSFExceptionHandler
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(LSFExceptionHandler.class);
    private String m_xml;
    private JFJob m_lsfjob;
    private JFExceptionHandlerBean m_lsfbean;

    LSFExceptionHandler(ScheduleManager plugin, FlowInfo flow, SchedulerServerInfo scheduler) throws SchedulerException {
        this.initialize(flow);
    }

    private void initialize(FlowInfo flow) throws SchedulerException {
        try {
            this.m_lsfjob = new JFJob("DEFAULTJOBNAME");
            this.m_xml = flow.getJobDefaultExceptionHandlers();
            if (this.m_xml != null && !this.m_xml.isEmpty()) {
                this.m_lsfjob.initHandlersFromDefinition(this.m_xml);
            }
            this.m_lsfbean = new JFExceptionHandlerBean();
            this.m_lsfbean.setEditable(true);
            this.m_lsfbean.setSource((Object)this.m_lsfjob);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lsfbean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            SchedulerException ex = new SchedulerException(m_bundle.getString("TimeEventDialog.UnableToInitialize.txt"));
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public String getHandlerXML() {
        return this.m_xml;
    }

    public void dispose() {
        this.saveSettingsAndCleanUp();
        this.m_lsfjob = null;
        this.m_lsfbean = null;
    }

    public boolean moveDataToView() {
        this.setDataChanged(false);
        return true;
    }

    public void moveDataToStore() {
        try {
            this.m_lsfbean.updateHandlers();
            this.m_xml = this.m_lsfbean.convertHandlersToXML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean validateData() {
        return true;
    }
}

