/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.schmgr.model.JobRendererTableModel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JobRenderersPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobRenderersPanel.class);
    private List<JobRendererInfo> m_renderers;
    private JobRendererTableModel m_model;
    private WsTable m_table;
    private JScrollPane m_pane = null;

    public JobRenderersPanel() {
        this(null);
    }

    public JobRenderersPanel(List<JobRendererInfo> renderers) {
        this.m_renderers = renderers;
        this.initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public boolean setJobRenderers(List<JobRendererInfo> renderers) {
        this.m_renderers = renderers;
        this.m_model.clear();
        if (this.m_renderers != null) {
            for (int i = 0; i < renderers.size(); ++i) {
                try {
                    this.m_model.addRow(renderers.get(i));
                    continue;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        this.resizeWindow();
        return false;
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        TitledBorder border = new TitledBorder(m_bundle.getString("JobRenderersPanel.BorderTitle.txt"));
        topPanel.setBorder(border);
        this.setDataChanged(false);
        this.m_model = new JobRendererTableModel();
        this.setJobRenderers(this.m_renderers);
        this.m_table = new WsTable(this.m_model){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                Object tip = null;
                if (rowIndex >= 0 && colIndex >= 0) {
                    try {
                        tip = this.getValueAt(rowIndex, colIndex);
                    }
                    catch (RuntimeException ex) {
                        tip = ex.getLocalizedMessage();
                    }
                }
                return tip != null ? tip.toString() : "";
            }
        };
        this.m_table.setEditable(false);
        this.m_table.setRowHeaderVisible(false);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_pane = new JScrollPane((Component)this.m_table, 20, 30);
        this.m_pane.setPreferredSize(new Dimension(800, 100));
        this.m_table.getRowModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        topPanel.add(this.m_pane);
        topPanel.setPreferredSize(new Dimension(800, 120));
        this.add(topPanel);
    }

    public boolean validateData() {
        return true;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    public void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }
}

