/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAIntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JobDependenciesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobDependenciesPanel.class);
    private ScheduleManager m_schmgr;
    private DisplayInfo m_job;
    private FlowInfo m_flow;
    private JLabel m_lblJfjoblist;
    private JComboBox m_cmbjfjob;
    private JLabel m_lbleventlist;
    private JComboBox m_cmbevents;
    private JLabel m_lbldescription;
    private JTextArea m_txtdescription;
    private JScrollPane m_scrdescription;
    private JLabel m_blankfield1;
    private JLabel m_blankfield2;
    private WAIntTextField m_txtMinutes;
    private JLabel m_lblMinutes;
    private JComboBox m_cmbReturnCodeCondition;
    private WAIntTextField m_txtReturnCode;
    private Object[] m_arr;
    private JobEventInfo m_condition;
    private JobInfo m_dependentJob;
    private JobInfo m_oDefaultJob = null;
    private int m_nDefaultOperator = -1;
    private String m_sDefaultDescription = null;
    private int m_nDefaultValue;
    private int m_nDefaultDependencyType = -1;
    private ArrayList<?> m_jobEvents;
    private boolean m_editmode = false;

    public JobDependenciesPanel(ScheduleManager plugin, ServerJobInfo job, ServerFlowInfo flow, ArrayList<?> jobEvents) {
        this.m_schmgr = plugin;
        this.m_job = job.getJobInfo();
        this.m_flow = flow.getInfo();
        this.m_jobEvents = jobEvents;
        this.m_editmode = false;
        this.__initialize();
    }

    public JobDependenciesPanel(ScheduleManager plugin, JobEventInfo oJobEvent, ServerJobInfo job, ServerFlowInfo flow, ArrayList<?> jobEvents) {
        this.m_schmgr = plugin;
        this.m_job = job.getJobInfo();
        this.m_flow = flow.getInfo();
        this.m_oDefaultJob = oJobEvent.getJobInfo();
        this.m_nDefaultValue = oJobEvent.getValue();
        this.m_nDefaultOperator = oJobEvent.getOperator();
        this.m_nDefaultDependencyType = oJobEvent.getEventType();
        this.m_sDefaultDescription = oJobEvent.getDescription();
        this.m_jobEvents = jobEvents;
        this.m_editmode = false;
        this.__initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_job = null;
        this.m_flow = null;
        this.m_lblJfjoblist = null;
        this.m_cmbjfjob = null;
        this.m_lbleventlist = null;
        this.m_cmbevents = null;
        this.m_lbldescription = null;
        this.m_txtdescription = null;
        this.m_scrdescription = null;
        this.m_txtMinutes = null;
        this.m_lblMinutes = null;
        this.m_cmbReturnCodeCondition = null;
        this.m_txtReturnCode = null;
        this.m_arr = null;
        this.m_dependentJob = null;
        this.m_oDefaultJob = null;
        this.m_sDefaultDescription = null;
        this.m_jobEvents = null;
    }

    public boolean moveViewToData() {
        this.m_condition.setJobInfo(this.m_dependentJob);
        this.m_condition.setDescription(this.m_txtdescription.getText());
        return true;
    }

    public boolean moveDataToView() {
        List jobs;
        JobInfo oSelectedJob = null;
        String sSelectedJobID = null;
        if (null != this.m_oDefaultJob) {
            sSelectedJobID = this.m_oDefaultJob.getId();
            oSelectedJob = this.m_oDefaultJob;
        }
        ArrayList<JobInfo> joblist = new ArrayList<JobInfo>();
        if (this.m_flow != null && (jobs = this.m_flow.getJobs()) != null) {
            for (Object obj : jobs) {
                JobInfo job;
                if (!(obj instanceof JobInfo) || (job = (JobInfo)obj).getId().equalsIgnoreCase(this.m_job.getId())) continue;
                joblist.add(job);
            }
        }
        this.m_arr = joblist.toArray();
        this.m_cmbjfjob.setModel(new DefaultComboBoxModel<Object>(this.m_arr));
        if (null != sSelectedJobID) {
            this.m_dependentJob = oSelectedJob;
            this.m_cmbjfjob.setSelectedItem(oSelectedJob);
        } else {
            this.m_dependentJob = (JobInfo)this.m_cmbjfjob.getSelectedItem();
        }
        if (null != this.m_sDefaultDescription) {
            this.m_txtdescription.setText(this.m_sDefaultDescription);
        }
        return true;
    }

    private void __initialize() {
        int x;
        String joblistText = m_bundle.getString("JobDependenciesPanel.JobList.Title.txt");
        this.m_lblJfjoblist = new JLabel(Util.getLabelWithoutMnemonic((String)joblistText));
        this.m_lblJfjoblist.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)joblistText));
        this.m_lblJfjoblist.setToolTipText(m_bundle.getString("JobDependenciesPanel.JobList.ToolTipText.txt"));
        this.m_cmbjfjob = new JComboBox();
        this.m_cmbjfjob.setToolTipText(m_bundle.getString("JobDependenciesPanel.JobList.ToolTipText.txt"));
        this.m_lblJfjoblist.setLabelFor(this.m_cmbjfjob);
        String eventlistText = m_bundle.getString("JobDependenciesPanel.EventList.Title.txt");
        this.m_lbleventlist = new JLabel(Util.getLabelWithoutMnemonic((String)eventlistText));
        this.m_lbleventlist.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)eventlistText));
        this.m_lbleventlist.setToolTipText(m_bundle.getString("JobDependenciesPanel.EventList.ToolTipText.txt"));
        this.m_cmbevents = new JComboBox();
        this.m_cmbevents.setToolTipText(m_bundle.getString("JobDependenciesPanel.EventList.ToolTipText.txt"));
        this.m_lbleventlist.setLabelFor(this.m_cmbevents);
        String descText = m_bundle.getString("JobDependenciesPanel.Description.Title.txt");
        this.m_lbldescription = new JLabel(Util.getLabelWithoutMnemonic((String)descText));
        this.m_lbldescription.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)descText));
        this.m_lbldescription.setToolTipText(m_bundle.getString("JobDependenciesPanel.Description.ToolTipText.txt"));
        this.m_txtdescription = new JTextArea();
        this.m_txtdescription.setToolTipText(m_bundle.getString("JobDependenciesPanel.Description.ToolTipText.txt"));
        this.m_lbldescription.setLabelFor(this.m_txtdescription);
        this.m_scrdescription = new JScrollPane(this.m_txtdescription);
        this.m_scrdescription.setPreferredSize(new Dimension(300, 100));
        this.m_blankfield1 = new JLabel("");
        this.m_blankfield2 = new JLabel("");
        this.m_lblMinutes = new JLabel(m_bundle.getString("JobDependenciesPanel.Minutes.txt"));
        this.m_lblMinutes.setVisible(false);
        this.m_txtMinutes = new WAIntTextField();
        this.m_txtMinutes.setVisible(false);
        this.m_cmbReturnCodeCondition = new JComboBox();
        this.m_cmbReturnCodeCondition.setVisible(false);
        this.m_txtReturnCode = new WAIntTextField();
        this.m_txtReturnCode.setVisible(false);
        ConditionMap oSelectedReturnCodeConditionCount = null;
        ArrayList<ConditionMap> alRCConditions = new ArrayList<ConditionMap>();
        ConditionMap map = null;
        map = new ConditionMap(FlowInfo.ArithmeticOperator_Equal_Text, 21, 0);
        alRCConditions.add(map);
        map = new ConditionMap(FlowInfo.ArithmeticOperator_NotEqual_Text, 22, 0);
        alRCConditions.add(map);
        map = new ConditionMap(FlowInfo.ArithmeticOperator_GreaterThan_Text, 23, 0);
        alRCConditions.add(map);
        map = new ConditionMap(FlowInfo.ArithmeticOperator_GreaterThanEqual_Text, 24, 0);
        alRCConditions.add(map);
        map = new ConditionMap(FlowInfo.ArithmeticOperator_LessThan_Text, 25, 0);
        alRCConditions.add(map);
        map = new ConditionMap(FlowInfo.ArithmeticOperator_LessThanEqual_Text, 26, 0);
        alRCConditions.add(map);
        if (-1 != this.m_nDefaultOperator) {
            Iterator i = alRCConditions.iterator();
            boolean found = false;
            while (!found && i.hasNext()) {
                map = (ConditionMap)i.next();
                int condition = map.getCondition();
                if (this.m_nDefaultOperator != condition) continue;
                oSelectedReturnCodeConditionCount = map;
                found = true;
            }
        }
        this.m_cmbReturnCodeCondition.setModel(new DefaultComboBoxModel<Object>(alRCConditions.toArray()));
        if (null != oSelectedReturnCodeConditionCount) {
            this.m_cmbReturnCodeCondition.setSelectedItem(oSelectedReturnCodeConditionCount);
        }
        ArrayList<JobEventInfo> alEvents = new ArrayList<JobEventInfo>();
        SchedulerServerInfo scheduler = this.m_flow.getScheduler();
        int[] events = SchedulerServerInfo.getAllJobEvents((String)scheduler.getClassId());
        for (x = 0; x < events.length; ++x) {
            JobEventInfo jei = new JobEventInfo();
            jei.setTypeDataBinding(events[x]);
            alEvents.add(jei);
        }
        this.m_cmbevents.setModel(new DefaultComboBoxModel<Object>(alEvents.toArray()));
        switch (this.m_nDefaultDependencyType) {
            case 3: {
                this.m_txtReturnCode.setValue(this.m_nDefaultValue);
                break;
            }
            case 4: 
            case 5: {
                this.m_txtMinutes.setValue(this.m_nDefaultValue);
            }
        }
        this.m_cmbevents.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JobDependenciesPanel.this.m_condition = (JobEventInfo)JobDependenciesPanel.this.m_cmbevents.getSelectedItem();
                    JobDependenciesPanel.this.conditionChanged();
                }
            }
        });
        this.m_cmbjfjob.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedJob = JobDependenciesPanel.this.m_cmbjfjob.getSelectedItem();
                    JobDependenciesPanel.this.m_dependentJob = (JobInfo)selectedJob;
                }
            }
        });
        if (-1 != this.m_nDefaultDependencyType) {
            this.m_condition = (JobEventInfo)alEvents.get(0);
            for (x = 0; x < alEvents.size(); ++x) {
                JobEventInfo je = (JobEventInfo)alEvents.get(x);
                if (je.getEventType() != this.m_nDefaultDependencyType) continue;
                this.m_condition = je;
                break;
            }
            this.m_cmbevents.setSelectedItem(this.m_condition);
        } else {
            this.m_condition = (JobEventInfo)this.m_cmbevents.getSelectedItem();
        }
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblJfjoblist, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 28, 0));
        this.add(this.m_cmbjfjob, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lbleventlist, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0));
        this.add(this.m_cmbevents, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_blankfield1, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_blankfield2, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.m_txtMinutes, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblMinutes, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_cmbReturnCodeCondition, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 50, 0));
        this.add((Component)this.m_txtReturnCode, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lbldescription, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 28, 0));
        this.add(this.m_scrdescription, new GridBagConstraints(1, 3, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void conditionChanged() {
        int nCondition = this.m_condition.getEventType();
        switch (nCondition) {
            case 3: {
                this.m_blankfield1.setVisible(false);
                this.m_blankfield2.setVisible(false);
                this.m_lblMinutes.setVisible(false);
                this.m_txtMinutes.setVisible(false);
                this.m_cmbReturnCodeCondition.setVisible(true);
                this.m_txtReturnCode.setVisible(true);
                break;
            }
            case 4: 
            case 5: {
                this.m_blankfield1.setVisible(false);
                this.m_blankfield2.setVisible(false);
                this.m_lblMinutes.setVisible(true);
                this.m_txtMinutes.setVisible(true);
                this.m_cmbReturnCodeCondition.setVisible(false);
                this.m_txtReturnCode.setVisible(false);
                break;
            }
            default: {
                this.m_blankfield1.setVisible(true);
                this.m_blankfield2.setVisible(true);
                this.m_lblMinutes.setVisible(false);
                this.m_txtMinutes.setVisible(false);
                this.m_cmbReturnCodeCondition.setVisible(false);
                this.m_txtReturnCode.setVisible(false);
            }
        }
    }

    public JobEventInfo getJobEvent() {
        return this.m_condition;
    }

    public boolean validateData() {
        int nConditionType = this.m_condition.getEventType();
        switch (nConditionType) {
            case 3: {
                if (this.m_txtReturnCode.getText().equalsIgnoreCase("")) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("JobDependenciesPanel.ReturnCodeBlank.txt"), (String)m_bundle.getString("JobDependenciesPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
                    return false;
                }
                ConditionMap entry = (ConditionMap)this.m_cmbReturnCodeCondition.getSelectedItem();
                this.m_condition.setOperator(entry.getCondition());
                this.m_condition.setValue(this.m_txtReturnCode.getValue());
                break;
            }
            case 4: 
            case 5: {
                if (this.m_txtMinutes.getText().equalsIgnoreCase("")) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("JobDependenciesPanel.MinutesBlank.txt"), (String)m_bundle.getString("JobDependenciesPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
                    return false;
                }
                this.m_condition.setValue(this.m_txtMinutes.getValue());
            }
        }
        if (!this.m_editmode) {
            this.m_condition.setJobInfo(this.m_dependentJob);
            String dependencyID = this.m_condition.toString() + this.m_dependentJob.getId();
            for (String id : this.m_jobEvents) {
                if (dependencyID.compareTo(id) != 0) continue;
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("JobDependenciesPanel.DuplicateEventError.txt"), (String)m_bundle.getString("JobDependenciesPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }
        try {
            this.m_schmgr.checkCircularDependencies(this.m_flow, this.m_dependentJob.getId());
        }
        catch (InvalidParameterException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("JobDependenciesPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
            return false;
        }
        catch (SchedulerException ex) {
            return false;
        }
        return true;
    }

    private class ConditionMap {
        private String m_displayText;
        private int m_mycondition;

        public ConditionMap(String displayText, int condition, int type) {
            this.m_displayText = displayText;
            this.m_mycondition = condition;
        }

        public String toString() {
            return this.m_displayText;
        }

        public int getCondition() {
            return this.m_mycondition;
        }
    }
}

