/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.iom.SAS.IWorkspace;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportFlowDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ImportFlowDialog.class);
    public static final int XML = 0;
    public static final int SAS = 1;
    public static final int CSV = 2;
    private cImportFlowPanel m_mainPanel;
    private int m_type = 0;
    private ScheduleManager m_schmgr;
    private SASAppServer m_selectedServer;
    private String m_sourceFile = null;
    private IWorkspace m_iworkspace = null;

    public ImportFlowDialog(ScheduleManager plugin) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("ImportFlowDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.setHelpProduct("scheduler");
        this.__initialize();
    }

    public void dispose() {
        if (this.m_mainPanel != null) {
            this.m_selectedServer = this.m_mainPanel.getSelectedServer();
            this.m_sourceFile = this.m_mainPanel.getSourceFile();
            this.m_type = this.m_mainPanel.getType();
        }
        super.dispose();
        this.m_mainPanel = null;
    }

    public SASAppServer getSelectedServer() {
        if (this.m_mainPanel != null) {
            this.m_selectedServer = this.m_mainPanel.getSelectedServer();
        }
        return this.m_selectedServer;
    }

    public IWorkspace getWorkspace() {
        return this.m_iworkspace;
    }

    public String getInputFile() {
        if (this.m_mainPanel != null) {
            this.m_sourceFile = this.m_mainPanel.getSourceFile();
        }
        return this.m_sourceFile;
    }

    public int getReportType() {
        if (this.m_mainPanel != null) {
            this.m_type = this.m_mainPanel.getType();
        }
        return this.m_type;
    }

    private boolean __initialize() {
        try {
            List<SASAppServer> servers = this.m_schmgr.getAppServersWithDeployedDirectories();
            this.m_mainPanel = new cImportFlowPanel(servers);
            this.setMainPanel(this.m_mainPanel);
            ActionListener browseListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = ImportFlowDialog.this.browseFileSystem();
                    if (filename != null) {
                        ImportFlowDialog.this.m_mainPanel.setSourceFile(filename);
                    }
                }
            };
            this.m_mainPanel.addBrowseListener(browseListener);
            return true;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private String browseFileSystem() {
        String file;
        SASAppServer bsinfo = this.m_mainPanel.getSelectedServer();
        try {
            if (!this.checkConnectionToServer(bsinfo)) {
                String message = m_bundle.getString("ImportFlowDialog.ErrorMsg.UnableToConnectToAppServer.txt");
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
                return null;
            }
        }
        catch (SchedulerException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ImportFlowDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
            return null;
        }
        catch (RemoteException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ImportFlowDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
            return null;
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ImportFlowDialog.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
            return null;
        }
        String msg = m_bundle.getString("ImportFlowDialog.BuildFileSelectorProgressIndicator.Message.txt");
        String title = m_bundle.getString("ImportFlowDialog.BuildFileSelectorProgressIndicator.Title.txt");
        ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, title);
        request.setDelayBeforeProgressCancelDialog(200);
        String initpath = null;
        cRunnable fileselector = new cRunnable(this.m_iworkspace, initpath);
        request.execute((Runnable)fileselector);
        if (request.hasErrors()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)request.getErrors(), (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
        }
        IFileServiceSelectorPanel pnlSelector = fileselector.getSelector();
        pnlSelector.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_ONLY);
        while (true) {
            ArrayList alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)this.m_frame, (String)m_bundle.getString("ImportFlowDialog.FileSelection.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)this.m_iworkspace, (boolean)true, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
            if (pnlSelector.isCancelled()) {
                return this.m_mainPanel.getSourceFile();
            }
            if (alFileList == null || alFileList.size() <= 0) continue;
            file = (String)alFileList.get(0);
            if (file != null && file.length() > 0) break;
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("ImportFlowDialog.ErrorMsg.MissingProgram.txt"), (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
        }
        return file;
    }

    public boolean onOK() throws SchedulerException {
        if (!this.m_mainPanel.validateData()) {
            String message = this.m_mainPanel.getErrorMessage();
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("ImportFlowDialog.Title.txt"), (int)0, (int)-1);
            return false;
        }
        return super.onOK();
    }

    private boolean checkConnectionToServer(SASAppServer sinfo) throws RemoteException, SchedulerException {
        this.m_iworkspace = this.m_schmgr.checkConnectionToWorkspaceServer(sinfo);
        return this.m_iworkspace != null;
    }

    private static class cImportFlowPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private SASAppServer mc_server;
        private List<?> mc_servers;
        private String mc_errormsg;
        private JComboBox mc_comboServers = new JComboBox();
        private JTextField mc_filename = new JTextField();
        private JButton mc_browse = new JButton();
        private JRadioButton mc_xmlImport;
        private JRadioButton mc_sasImport;
        private JRadioButton mc_csvImport;
        private static final int FIELD_WIDTH = 350;
        private static final int FIELD_HEIGHT = 20;

        public cImportFlowPanel(List<?> servers) {
            this.setName(m_bundle.getString("ImportFlowPanel.Title.txt"));
            this.mc_servers = servers;
            this._initialize();
        }

        public void saveSettingsAndCleanUp() {
            super.saveSettingsAndCleanUp();
            this.mc_servers = null;
            this.mc_comboServers = null;
            this.mc_filename = null;
            this.mc_browse = null;
            this.mc_xmlImport = null;
            this.mc_sasImport = null;
            this.mc_csvImport = null;
        }

        public SASAppServer getSelectedServer() {
            this.mc_server = (SASAppServer)this.mc_comboServers.getSelectedItem();
            return this.mc_server;
        }

        public String getSourceFile() {
            return this.mc_filename.getText();
        }

        public boolean setSourceFile(String filename) {
            this.mc_filename.setText(filename);
            return true;
        }

        public void addBrowseListener(ActionListener al) {
            this.mc_browse.addActionListener(al);
            this.mc_browse.setVisible(true);
            this.invalidate();
        }

        public int getType() {
            if (this.mc_csvImport.isSelected()) {
                return 2;
            }
            if (this.mc_sasImport.isSelected()) {
                return 1;
            }
            return 0;
        }

        public String getErrorMessage() {
            return this.mc_errormsg;
        }

        public boolean validateData() {
            try {
                String file = this.getSourceFile();
                if (file == null || file.length() <= 0) {
                    this.mc_errormsg = m_bundle.getString("ImportFlowPanel.Error.Invalid_FileName.txt");
                    return false;
                }
                this.mc_errormsg = null;
                return true;
            }
            catch (RuntimeException ex) {
                this.mc_errormsg = ex.getLocalizedMessage();
                if (this.mc_errormsg == null || this.mc_errormsg.length() == 0) {
                    this.mc_errormsg = ex.toString();
                }
                return false;
            }
        }

        private void _initialize() {
            for (SASAppServer server : this.mc_servers) {
                this.mc_comboServers.addItem(server);
            }
            String appText = m_bundle.getString("ImportFlowPanel.AppServerLabel.txt");
            JLabel serverlabel = new JLabel(Util.getLabelWithoutMnemonic((String)appText));
            serverlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)appText));
            serverlabel.setLabelFor(this.mc_comboServers);
            String fileText = m_bundle.getString("ImportFlowPanel.FilenameLabel.txt");
            JLabel filelabel = new JLabel(Util.getLabelWithoutMnemonic((String)fileText));
            filelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)fileText));
            filelabel.setLabelFor(this.mc_filename);
            this.mc_browse.setText(m_bundle.getString("ImportFlowPanel.Browse.txt"));
            JLabel importlabel = new JLabel(m_bundle.getString("ImportFlowPanel.ImportLabel.txt"));
            this.mc_xmlImport = new JRadioButton(m_bundle.getString("ImportFlowPanel.XMLImport.Option.txt"), true);
            this.mc_sasImport = new JRadioButton(m_bundle.getString("ImportFlowPanel.SASImport.Option.txt"), false);
            this.mc_csvImport = new JRadioButton(m_bundle.getString("ImportFlowPanel.CSVImport.Option.txt"), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_xmlImport);
            buttonGroup.add(this.mc_sasImport);
            buttonGroup.add(this.mc_csvImport);
            GridBagConstraints gbc_serversLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_servers = new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_fileLabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_filename = new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_browse = new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_importlabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(7, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_xmlimport = new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0);
            GridBagConstraints gbc_sasimport = new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0);
            GridBagConstraints gbc_csvimport = new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0);
            Dimension fielddim = new Dimension(350, 20);
            this.mc_comboServers.setPreferredSize(fielddim);
            this.setLayout(new GridBagLayout());
            this.add(serverlabel, gbc_serversLabel);
            this.add(this.mc_comboServers, gbc_servers);
            this.add(filelabel, gbc_fileLabel);
            this.add(this.mc_filename, gbc_filename);
            this.add(this.mc_browse, gbc_browse);
            this.add(importlabel, gbc_importlabel);
            this.add(this.mc_xmlImport, gbc_xmlimport);
            this.add(this.mc_sasImport, gbc_sasimport);
            this.add(this.mc_csvImport, gbc_csvimport);
            this.mc_browse.setVisible(false);
        }
    }

    private class cRunnable
    implements Runnable {
        IWorkspace m_workspace = null;
        String m_initialpath = "";
        IFileServiceSelectorPanel m_fileList = null;

        cRunnable(IWorkspace iworkspace, String initpath) {
            this.m_workspace = iworkspace;
            this.m_initialpath = initpath;
        }

        public IFileServiceSelectorPanel getSelector() {
            return this.m_fileList;
        }

        @Override
        public void run() {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            switch (ImportFlowDialog.this.getReportType()) {
                case 0: {
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.XMLFileTypeDesc.txt"), "xml");
                    break;
                }
                case 1: {
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.SASFileTypeDesc.txt"), "sas7bdat");
                    break;
                }
                case 2: {
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.CSVFileTypeDesc.txt"), "csv");
                    break;
                }
                default: {
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.XMLFileTypeDesc.txt"), "xml");
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.SASFileTypeDesc.txt"), "sas7bdat");
                    fileTypes.put(m_bundle.getString("ImportFlowDialog.CSVFileTypeDesc.txt"), "csv");
                }
            }
            this.m_fileList = new IFileServiceSelectorPanel(this.m_initialpath, this.m_workspace, fileTypes, false);
        }
    }
}

