/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;

public class FlowPropertiesGeneralTab
extends WAGeneralPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowPropertiesGeneralTab.class);
    private DeployedFlow m_myflow;
    private ScheduleManager m_schmgr;
    private ServerFlowInfo m_info;
    private boolean m_commitChanges = true;
    private boolean m_dirty = false;
    private WAGeneralPanel m_panel;
    private WATextField m_txtName;
    private WATextArea m_description;
    private Root m_localObject;
    public static final String NAMECHANGE_EVENT = "NAME";
    public static final String WRITE_EVENT = "WRITECHANGE";
    public static final String GATHER_FULL_METADATA = "GATHERMETADATA";

    public FlowPropertiesGeneralTab(ScheduleManager plugin, ServerFlowInfo info) throws RemoteException {
        super((CMetadata)info.getMetadataObject(plugin.getServerUtilities()), null, false, false, true, true);
        this.m_schmgr = plugin;
        this.m_info = info;
        this.m_myflow = info.getDeployedFlow();
        if (info.hasErrors()) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)info.errorConditions(), (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
        }
        this.setHelpProduct("shared");
        this.setHelpTopic("window_flow_general");
        this.m_localObject = info.getMetadataObject(plugin.getServerUtilities());
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof WAGeneralPanel) {
            this.m_panel = (WAGeneralPanel)this.getComponent(0);
            this.m_panel.setSelectFolderEnabled(true);
            this.m_txtName = (WATextField)this.m_panel.getNameComponent();
            this.m_description = (WATextArea)this.m_panel.getDescriptionComponent();
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_myflow = null;
        this.m_schmgr = null;
        this.m_panel.saveSettingsAndCleanUp();
        this.m_panel = null;
        this.m_txtName = null;
        this.m_description = null;
    }

    public boolean validateData() {
        if (super.validateData()) {
            String flowName = "";
            if (this.m_txtName != null) {
                flowName = this.m_txtName.getText();
            }
            try {
                JFJob jfjob = this.m_myflow.getMetadataObject();
                if (!DeployedFlow.isValidFlowName((String)flowName)) {
                    String errorMessage = m_bundle.getString("SchMgrFlowInfo.InvalidChars.Message.txt");
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
                    if (this.m_txtName != null) {
                        this.m_txtName.grabFocus();
                    }
                    return false;
                }
                if (!this.m_schmgr.isUniqueFlow(flowName, jfjob.getId())) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SchMgrFlowInfo.NonUnique.Message.txt"), (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
                    if (this.m_txtName != null) {
                        this.m_txtName.grabFocus();
                    }
                    return false;
                }
                boolean writechanges = false;
                if (jfjob.getName().compareTo(flowName) != 0) {
                    jfjob.setName(flowName);
                    this.m_localObject.setName(flowName);
                    this.m_localObject.fireMdObjectModified(new MdEvent((Object)NAMECHANGE_EVENT));
                    writechanges = true;
                }
                if (jfjob.getDesc().compareTo(this.m_description.getText()) != 0) {
                    jfjob.setDesc(this.m_description.getText());
                    writechanges = true;
                }
                Tree folder = this.m_panel.getOwningTree();
                AssociationList folders = jfjob.getTrees();
                if (folders.size() > 0) {
                    Tree t = (Tree)folders.get(0);
                    if (t.getFQID().compareTo(folder.getFQID()) != 0) {
                        folders.clear();
                        folders.add(folder);
                        writechanges = true;
                    }
                } else if (folder != null) {
                    folders.add(folder);
                    writechanges = true;
                }
                if (writechanges) {
                    jfjob.updateMetadataAll();
                    this.m_localObject.fireMdObjectModified(new MdEvent((Object)WRITE_EVENT));
                }
            }
            catch (MdException ex) {
                String errorMessage = m_bundle.messageString("SchMgrFlowInfo.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
                return false;
            }
            catch (RemoteException ex) {
                String errorMessage = m_bundle.messageString("SchMgrFlowInfo.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
                return false;
            }
            catch (RuntimeException ex) {
                String errorMessage = m_bundle.messageString("SchMgrFlowInfo.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
                return false;
            }
            return true;
        }
        String errorMessage = m_bundle.messageString("SchMgrFlowInfo.ValidationFailure.Message.txt");
        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("SchMgrFlowInfo.Title.txt"), (int)0);
        return false;
    }

    public void setCommitChanges(boolean value) {
        this.m_commitChanges = value;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void onParentOK() {
        super.onParentOK();
        if (this.m_commitChanges) {
            this.m_info.commitChangesToOMR();
            this.m_schmgr.refreshNodeFromInfo((DisplayInfo)this.m_info);
        } else {
            this.m_dirty = true;
        }
    }
}

