/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.LSFExceptionHandler;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.EnvironmentVariablesPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPropertyTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class FlowPropertiesDefaultJobAttributesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowPropertiesDefaultJobAttributesTab.class);
    private ScheduleManager m_schmgr;
    private Frame m_frame;
    private ServerFlowInfo m_info;
    private SchedulerServerInfo m_scheduler;
    private String m_message = "";
    private WAPropertyTab m_dependentTab = null;
    private StandardPanel m_pnlMisc;
    private JComboBox m_priority;
    private JLabel m_lblpriority;
    private JComboBox m_queues;
    private JLabel m_lblqueues;
    private String m_jobqueue;
    private int m_jobpriority;
    private EnvironmentVariablesPanel m_pnlEnvironmentVariables;
    private JobEmailNotificationPanel m_pnlEmailNotificationPanel;
    private LSFExceptionHandler m_pnlExceptionHandlers;

    public FlowPropertiesDefaultJobAttributesTab(ScheduleManager plugin, ServerFlowInfo flow) throws SchedulerException {
        this.m_schmgr = plugin;
        this.m_frame = plugin.getMainFrame();
        this.m_info = flow;
        this.m_scheduler = flow.getInfo().getScheduler();
        this.setHelpProduct("shared");
        this.setHelpTopic("jobprop_tab");
        this.initialize();
        this.setPanelEnabled();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_schmgr = null;
        this.m_frame = null;
        this.m_info = null;
        this.m_message = null;
        this.m_dependentTab = null;
        this.m_pnlMisc = null;
        this.m_priority = null;
        this.m_lblpriority = null;
        this.m_queues = null;
        this.m_lblqueues = null;
        this.m_pnlEnvironmentVariables = null;
        this.m_pnlEmailNotificationPanel = null;
    }

    public void initialize() {
        JLabel topDesc;
        block16: {
            topDesc = new JLabel(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Description.txt"));
            try {
                FlowInfo info = this.m_info.getInfo();
                this.m_pnlMisc = new StandardPanel();
                String top = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.TopLabel.txt");
                String high = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.HighLabel.txt");
                String normal = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.NormalLabel.txt");
                String medium = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.MediumLabel.txt");
                String low = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.LowLabel.txt");
                this.m_priority = new JComboBox();
                this.m_priority.setToolTipText(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.ToolTip.txt"));
                this.m_priority.addItem(top);
                this.m_priority.addItem(high);
                this.m_priority.addItem(normal);
                this.m_priority.addItem(medium);
                this.m_priority.addItem(low);
                String priorityText = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Priority.txt");
                this.m_lblpriority = new JLabel(Util.getLabelWithoutMnemonic((String)priorityText));
                this.m_lblpriority.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)priorityText));
                this.m_lblpriority.setLabelFor(this.m_priority);
                this.m_jobpriority = info.getJobDefaultPriority();
                switch (this.m_jobpriority) {
                    case 0: {
                        this.m_priority.setSelectedItem(top);
                        break;
                    }
                    case 1: {
                        this.m_priority.setSelectedItem(high);
                        break;
                    }
                    default: {
                        this.m_priority.setSelectedItem(normal);
                        break;
                    }
                    case 3: {
                        this.m_priority.setSelectedItem(medium);
                        break;
                    }
                    case 4: {
                        this.m_priority.setSelectedItem(low);
                    }
                }
                this.m_priority.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        switch (FlowPropertiesDefaultJobAttributesTab.this.m_priority.getSelectedIndex()) {
                            case 0: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = 0;
                                break;
                            }
                            case 1: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = 1;
                                break;
                            }
                            case 2: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = 2;
                                break;
                            }
                            case 3: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = 3;
                                break;
                            }
                            case 4: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = 4;
                                break;
                            }
                            default: {
                                FlowPropertiesDefaultJobAttributesTab.this.m_jobpriority = -1;
                            }
                        }
                    }
                });
                this.m_queues = new JComboBox();
                String queueText = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Queues.txt");
                this.m_queues.setToolTipText(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Queues.ToolTip.txt"));
                this.m_lblqueues = new JLabel(Util.getLabelWithoutMnemonic((String)queueText));
                this.m_lblqueues.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)queueText));
                this.m_lblqueues.setLabelFor(this.m_queues);
                this.m_queues.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        FlowPropertiesDefaultJobAttributesTab.this.m_jobqueue = (String)FlowPropertiesDefaultJobAttributesTab.this.m_queues.getSelectedItem();
                    }
                });
                SchedulerServerInfo scheduler = this.m_info.getInfo().getScheduler();
                if (scheduler != null) {
                    this.getJobPriority();
                    this.getQueues(this.m_info);
                } else {
                    this.m_lblpriority.setEnabled(false);
                    this.m_priority.setEnabled(false);
                    this.m_lblqueues.setEnabled(false);
                    this.m_queues.setModel(new DefaultComboBoxModel());
                    this.m_queues.setEnabled(false);
                }
                this.m_pnlMisc.setLayout((LayoutManager)new GridBagLayout());
                GridBagConstraints lblqueues_gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
                GridBagConstraints queues_gbc = new GridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
                GridBagConstraints lblpriority_gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
                GridBagConstraints priority_gbc = new GridBagConstraints(1, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
                this.m_pnlMisc.setBorder((Border)new EtchedBorder());
                this.m_pnlMisc.setLayout((LayoutManager)new GridBagLayout());
                this.m_pnlMisc.setBorder((Border)new EtchedBorder());
                this.m_pnlMisc.add((Component)this.m_lblqueues, (Object)lblqueues_gbc);
                this.m_pnlMisc.add((Component)this.m_queues, (Object)queues_gbc);
                this.m_pnlMisc.add((Component)this.m_lblpriority, (Object)lblpriority_gbc);
                this.m_pnlMisc.add((Component)this.m_priority, (Object)priority_gbc);
                if (this.m_scheduler.getClassId().equals("a1661499-5d7d-4fcc-8fc3-c6509853e116")) {
                    try {
                        this.m_pnlExceptionHandlers = new LSFExceptionHandler(this.m_schmgr, info, scheduler);
                        this.m_pnlExceptionHandlers.setEnabled(true);
                    }
                    catch (SchedulerException e) {
                        this.m_pnlExceptionHandlers = null;
                    }
                } else {
                    this.m_pnlExceptionHandlers = null;
                }
                String list = info.getJobDefaultEnvironmentVariables();
                this.m_pnlEnvironmentVariables = new EnvironmentVariablesPanel(this.m_frame, list);
                this.m_pnlEmailNotificationPanel = new JobEmailNotificationPanel(info);
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                this.m_message = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.UnableToReadFlowInformation.txt");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                this.m_message = ex.getLocalizedMessage();
                if (this.m_message != null) break block16;
                this.m_message = ex.toString();
            }
        }
        GridBagConstraints description_gbc = new GridBagConstraints(0, 0, 8, 0, 1.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints environment_gbc = new GridBagConstraints(0, 1, 4, 5, 1.0, 1.0, 18, 1, new Insets(40, 0, 0, 0), 0, 0);
        GridBagConstraints email_gbc = new GridBagConstraints(4, 1, 4, 1, 1.0, 1.0, 18, 1, new Insets(40, 0, 0, 0), 0, 0);
        GridBagConstraints misc_gbc = new GridBagConstraints(4, 2, 4, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints except_gbc = new GridBagConstraints(4, 4, 4, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add(topDesc, description_gbc);
        this.add((Component)this.m_pnlEnvironmentVariables, environment_gbc);
        this.add((Component)((Object)this.m_pnlEmailNotificationPanel), email_gbc);
        this.add((Component)this.m_pnlMisc, misc_gbc);
        if (this.m_pnlExceptionHandlers != null) {
            this.add((Component)((Object)this.m_pnlExceptionHandlers), except_gbc);
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setListeningForChanges(false);
        this.setStorePopulated(true);
        this.setListeningForChanges(true);
    }

    public void moveDataToView() {
        this.setDataChanged(false);
        this.m_pnlEmailNotificationPanel.moveDataToView();
        this.m_pnlEnvironmentVariables.moveDataToView();
        if (this.m_pnlExceptionHandlers != null) {
            this.m_pnlExceptionHandlers.moveDataToView();
        }
        this.setPanelEnabled();
    }

    public void moveDataToStore() {
        this.m_pnlEmailNotificationPanel.moveViewToData();
        FlowInfo info = this.m_pnlEmailNotificationPanel.getInfo();
        this.m_info.setJobDefaultEmailNotification(info);
        this.m_pnlEnvironmentVariables.moveViewToData();
        String vars = this.m_pnlEnvironmentVariables.getVariableList();
        this.m_info.setJobDefaultEnvironmentVariables(vars);
        if (this.m_pnlExceptionHandlers != null) {
            this.m_pnlExceptionHandlers.moveDataToStore();
            String xml = this.m_pnlExceptionHandlers.getHandlerXML();
            this.m_info.setJobDefaultExceptionHandlers(xml);
        }
        this.m_info.setJobDefaultPriority(this.m_jobpriority);
        this.m_info.setDefaultQueue(this.m_jobqueue);
        this.m_info.commitChangesToOMR();
    }

    public boolean validateData() {
        if (this.m_pnlMisc.validateData() && this.m_pnlEmailNotificationPanel.validateData() && this.m_pnlEnvironmentVariables.validateData()) {
            if (this.m_pnlExceptionHandlers != null) {
                return this.m_pnlExceptionHandlers.validateData();
            }
            return true;
        }
        return false;
    }

    public void onParentCancel() {
        super.onParentCancel();
    }

    public void onParentOK() {
        super.onParentOK();
    }

    public void setDependentTab(WAPropertyTab tab) {
        this.m_dependentTab = tab;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (bDataChanged) {
            this.m_schmgr.checkSchedulerConnectionForFlowEvents(this.m_info);
            this.setPanelEnabled();
            if (this.m_dependentTab != null) {
                this.m_dependentTab.setDataChanged(bDataChanged);
            }
        }
        super.setDataChanged(bDataChanged);
    }

    private void setPanelEnabled() {
        if (this.m_scheduler != null) {
            if (this.m_scheduler.isJobDefaultEmailNotificationSupported()) {
                this.m_pnlEmailNotificationPanel.setEnabled(true);
            } else {
                this.m_pnlEmailNotificationPanel.setEnabled(false);
            }
            if (this.m_scheduler.isJobDefaultEnvironmentVariablesSupported()) {
                this.m_pnlEnvironmentVariables.setEnabled(true);
            } else {
                this.m_pnlEnvironmentVariables.setEnabled(false);
            }
            if (this.m_pnlExceptionHandlers != null) {
                this.m_pnlExceptionHandlers.setEnabled(true);
            }
            if (this.m_scheduler.areQueues()) {
                this.m_lblqueues.setEnabled(true);
                this.m_queues.setEnabled(true);
            } else {
                this.m_lblqueues.setEnabled(false);
                this.m_queues.setEnabled(false);
            }
            if (this.m_scheduler.isJobDefaultPrioritySupported() && this.m_schmgr.getMaxJobPriority(this.m_scheduler) != -1) {
                this.m_lblpriority.setEnabled(true);
                this.m_priority.setEnabled(true);
            } else {
                this.m_lblpriority.setEnabled(false);
                this.m_priority.setEnabled(false);
            }
        } else {
            this.m_pnlEmailNotificationPanel.setEnabled(false);
            this.m_pnlEnvironmentVariables.setEnabled(false);
            this.m_lblqueues.setEnabled(false);
            this.m_queues.setEnabled(false);
            this.m_lblpriority.setEnabled(false);
            this.m_priority.setEnabled(false);
        }
    }

    private void getJobPriority() {
        int max = this.m_schmgr.getMaxJobPriority(this.m_scheduler);
        if (max > 0) {
            this.m_lblpriority.setEnabled(true);
            this.m_priority.setEnabled(true);
        } else {
            this.m_lblpriority.setEnabled(false);
            this.m_priority.setEnabled(false);
        }
    }

    private void getQueues(ServerFlowInfo info) {
        if (this.m_scheduler.areQueues() && !this.m_schmgr.checkSchedulerConnectionForFlowEvents(info)) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.UnableToConnectToScheduler.txt"), (String)m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Title.txt"), (int)2);
        }
        List queues = null;
        try {
            queues = info.getQueues(this.m_scheduler);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        if (queues != null && queues.size() > 0) {
            this.m_queues.setModel(new DefaultComboBoxModel<Object>(queues.toArray()));
            String defaultqueue = this.m_info.getDefaultQueue();
            if (defaultqueue != null) {
                this.m_queues.setSelectedItem(defaultqueue);
            }
            this.m_jobqueue = (String)this.m_queues.getSelectedItem();
            this.m_lblqueues.setEnabled(true);
            this.m_queues.setEnabled(true);
        } else {
            this.m_lblqueues.setEnabled(false);
            this.m_queues.setModel(new DefaultComboBoxModel());
            this.m_queues.setEnabled(false);
        }
    }

    private class JobEmailNotificationPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private FlowInfo mc_flow;
        private JCheckBox mc_notify;
        private JLabel mc_whenLabel;
        private JComboBox mc_when;
        private JLabel mc_userLabel;
        private JTextField mc_user;

        public JobEmailNotificationPanel(FlowInfo info) {
            this.mc_flow = info;
            this.__initialize();
        }

        public void saveSettingsAndCleanUp() {
            super.saveSettingsAndCleanUp();
            this.mc_notify = null;
            this.mc_whenLabel = null;
            this.mc_when = null;
            this.mc_userLabel = null;
            this.mc_user = null;
        }

        public FlowInfo getInfo() {
            return this.mc_flow;
        }

        private void __initialize() {
            this.setLayout(new GridBagLayout());
            this.mc_notify = new JCheckBox(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.CheckBox.NotifyLabel.txt"));
            String starts = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Criteria.StartsLabel.txt");
            String ends = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Criteria.EndsLabel.txt");
            String startend = m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Criteria.StartEndLabel.txt");
            this.mc_when = new JComboBox();
            this.mc_when.addItem(starts);
            this.mc_when.addItem(ends);
            this.mc_when.addItem(startend);
            this.mc_whenLabel = new JLabel(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Criteria.Label.txt"));
            this.mc_whenLabel.setToolTipText(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Criteria.ToolTip.txt"));
            this.mc_whenLabel.setLabelFor(this.mc_when);
            this.mc_userLabel = new JLabel(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.User.Label.txt"));
            this.mc_user = new JTextField();
            this.mc_user.setToolTipText(m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.User.ToolTip.txt"));
            this.mc_userLabel.setLabelFor(this.mc_user);
            int level = this.mc_flow.jobDefaultEmailNotificationLevel();
            switch (level) {
                case 0: {
                    this.mc_when.setSelectedItem(starts);
                    break;
                }
                case 4: {
                    this.mc_when.setSelectedItem(ends);
                    break;
                }
                case 1: {
                    this.mc_when.setSelectedItem(startend);
                }
            }
            String address = this.mc_flow.jobDefaultEmailAddress();
            this.mc_user.setText(address);
            this.mc_notify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JobEmailNotificationPanel.this.setWidgets();
                }
            });
            GridBagConstraints notify_gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0);
            GridBagConstraints whenlabel_gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0);
            GridBagConstraints when_gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
            GridBagConstraints userlabel_gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0);
            GridBagConstraints user_gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
            GridBagConstraints filler_gbc = new GridBagConstraints(0, 3, 2, 50, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            this.setBorder(new EtchedBorder());
            this.add(this.mc_notify, notify_gbc);
            this.add(this.mc_whenLabel, whenlabel_gbc);
            this.add(this.mc_when, when_gbc);
            this.add(this.mc_userLabel, userlabel_gbc);
            this.add(this.mc_user, user_gbc);
            this.add(new JLabel(), filler_gbc);
        }

        public void setEnabled(boolean flag) {
            this.mc_notify.setEnabled(flag);
            this.setWidgets();
        }

        public boolean moveDataToView() {
            int level = this.mc_flow.jobDefaultEmailNotificationLevel();
            if (level != -1) {
                this.mc_notify.setSelected(true);
                switch (level) {
                    case 0: {
                        this.mc_when.setSelectedIndex(0);
                        break;
                    }
                    case 4: {
                        this.mc_when.setSelectedIndex(1);
                        break;
                    }
                    case 1: {
                        this.mc_when.setSelectedIndex(2);
                    }
                }
            } else {
                this.mc_notify.setSelected(false);
            }
            String user = this.mc_flow.jobDefaultEmailAddress();
            if (user != null) {
                this.mc_user.setText(user);
            }
            this.setWidgets();
            return true;
        }

        public boolean moveViewToData() {
            if (this.mc_notify.isSelected()) {
                switch (this.mc_when.getSelectedIndex()) {
                    case 0: {
                        this.mc_flow.setJobDefaultEmailNotification(true, 0, this.mc_user.getText());
                        break;
                    }
                    case 1: {
                        this.mc_flow.setJobDefaultEmailNotification(true, 4, this.mc_user.getText());
                        break;
                    }
                    case 2: {
                        this.mc_flow.setJobDefaultEmailNotification(true, 1, this.mc_user.getText());
                        break;
                    }
                }
            } else {
                this.mc_flow.setJobDefaultEmailNotification(false, -1, this.mc_user.getText());
            }
            return true;
        }

        public boolean validateData() {
            String user;
            if (this.mc_notify.isSelected() && ((user = this.mc_user.getText()) == null || user.length() < 1)) {
                MessageUtil.displayMessage((Frame)FlowPropertiesDefaultJobAttributesTab.this.m_frame, (String)m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.NoUserGiven.txt"), (String)m_bundle.getString("FlowPropertiesDefaultJobAttributesTab.Email.Title.txt"), (int)0, (int)-1);
                return false;
            }
            return true;
        }

        private void setWidgets() {
            if (this.mc_notify.isSelected()) {
                this.mc_whenLabel.setEnabled(true);
                this.mc_when.setEnabled(true);
                this.mc_userLabel.setEnabled(true);
                this.mc_user.setEnabled(true);
            } else {
                this.mc_whenLabel.setEnabled(false);
                this.mc_when.setEnabled(false);
                this.mc_userLabel.setEnabled(false);
                this.mc_user.setEnabled(false);
            }
            this.invalidate();
        }
    }
}

