/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.schmgr.model.FlowHistoryTableModel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FlowHistoriesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowHistoriesPanel.class);
    private WsTable m_table;
    private FlowHistoryTableModel m_model;
    private JScrollPane m_pane = null;
    private ActionListener m_callback = null;
    private ActionListener m_actionRefresh = null;
    private ActionListener m_actionTrigger = null;
    private ActionListener m_actionKill = null;
    private List<FlowHistory> m_histories;

    public FlowHistoriesPanel(List<FlowHistory> histories, ActionListener refreshAL, ActionListener triggerAL, ActionListener killAL) {
        this.m_histories = histories;
        this.m_actionRefresh = refreshAL;
        this.m_actionTrigger = triggerAL;
        this.m_actionKill = killAL;
        this.initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean flag) {
    }

    public boolean setHistories(List<FlowHistory> histories) {
        this.m_histories = histories;
        this.m_model.clear();
        if (this.m_histories != null) {
            for (FlowHistory info : this.m_histories) {
                this.m_model.addRow(info);
            }
        }
        this.resizeWindow();
        return true;
    }

    public void setListener(ActionListener acl) {
        this.m_callback = acl;
    }

    public void removeListener() {
        this.m_callback = null;
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        TitledBorder border = new TitledBorder(m_bundle.getString("FlowHistoriesPanel.BorderTitle.txt"));
        topPanel.setBorder(border);
        this.setDataChanged(false);
        this.m_model = new FlowHistoryTableModel();
        this.setHistories(this.m_histories);
        this.m_table = new WsTable(this.m_model){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                Object tip = null;
                if (rowIndex >= 0 && colIndex >= 0) {
                    try {
                        tip = this.getValueAt(rowIndex, colIndex);
                    }
                    catch (RuntimeException ex) {
                        tip = ex.getLocalizedMessage();
                    }
                }
                return tip != null ? tip.toString() : "";
            }
        };
        this.m_table.addMouseListener((MouseListener)new cMouseListener());
        this.m_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (FlowHistoriesPanel.this.m_callback != null) {
                    int row = FlowHistoriesPanel.this.m_table.getSelectedRow();
                    ActionEvent ae = new ActionEvent(FlowHistoriesPanel.this.m_histories.get(row), 1001, null);
                    FlowHistoriesPanel.this.m_callback.actionPerformed(ae);
                }
            }
        });
        this.m_table.setEditable(false);
        this.m_table.setRowHeaderVisible(false);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_pane = new JScrollPane((Component)this.m_table, 20, 30);
        this.m_pane.setPreferredSize(new Dimension(450, 340));
        this.m_table.getRowModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        topPanel.add(this.m_pane);
        topPanel.setPreferredSize(new Dimension(450, 360));
        this.add(topPanel);
    }

    public void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    public boolean validateData() {
        return true;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    private class cMouseListener
    implements MouseListener {
        private cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int selectedRow;
            if ((e.getModifiers() & 4) != 0 && (selectedRow = FlowHistoriesPanel.this.m_table.getSelectedRow()) != -1) {
                FlowHistory flow = (FlowHistory)FlowHistoriesPanel.this.m_histories.get(selectedRow);
                JPopupMenu popMenu = this._buildPopupMenu(flow);
                popMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu _buildPopupMenu(FlowHistory flow) {
            ToolTipStrippingJPopupMenu popMenu = new ToolTipStrippingJPopupMenu();
            if (flow == null) {
                return popMenu;
            }
            SetMyAction refreshAction = new SetMyAction(flow, FlowHistoriesPanel.this.m_actionRefresh, m_bundle.getString("FlowHistoriesPanel.Action.Refresh.txt"));
            popMenu.add(refreshAction);
            SetMyAction triggerAction = new SetMyAction(flow, FlowHistoriesPanel.this.m_actionTrigger, m_bundle.getString("FlowHistoriesPanel.Action.Trigger.txt"));
            popMenu.add(triggerAction);
            if (flow.getState() == 3 || flow.getState() == 5) {
                SetMyAction killAction = new SetMyAction(flow, FlowHistoriesPanel.this.m_actionKill, m_bundle.getString("FlowHistoriesPanel.Action.Kill.txt"));
                popMenu.add(killAction);
            }
            return popMenu;
        }
    }

    private class SetMyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        ActionListener m_action;
        FlowHistory m_flow;

        public SetMyAction(FlowHistory flow, ActionListener action, String title) {
            this.m_action = action;
            this.m_flow = flow;
            this.setMenuItem(title);
        }

        private void setMenuItem(String title) {
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)title));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)title));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionEvent e = new ActionEvent(this.m_flow, 1001, null);
            this.m_action.actionPerformed(e);
        }
    }
}

