/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFHost;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFTemplateJob;
import com.platform.LSFJobFlow.ui.JFJobDefinitionBean;
import com.platform.LSFJobFlow.ui.JFTemplateJobDefinitionBean;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.lsf.LSFJob;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.api.servers.os.OSJob;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancePropertiesDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(AdvancePropertiesDialog.class);
    private StandardPanel m_pnlMain;
    private JScrollPane m_pane;
    private boolean m_editable;
    private JobInfo m_djob;
    private String m_flowname;
    private SchedulerServerInfo m_scheduler;
    private String m_schedulingUser;
    private String m_txtsascommand;
    private ScheduleManager m_schmgr;
    private JFJob m_lsfJFJob;
    private JFFlow m_lsfJFFlow;
    private JPanel m_jobDefinitionPanel;
    private JFTemplateJobDefinitionBean m_templateDefinitionPanel;

    public AdvancePropertiesDialog(ScheduleManager plugin, String title, SchedulerServerInfo scheduler, String userid, boolean editable, String flowname, JobInfo djob, String sascmd) {
        super(plugin.getMainFrame(), title, true);
        this.m_schmgr = plugin;
        this.m_scheduler = scheduler;
        this.m_schedulingUser = userid;
        this.m_editable = editable;
        this.m_flowname = flowname;
        this.m_djob = djob;
        this.m_txtsascommand = sascmd;
        this.initialize();
        this.setHelpProduct("scheduler");
        if (this.m_scheduler.getClassId().compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0) {
            this.setHelpTopic("window_advanced");
        } else {
            this.setHelpTopic("window_os_advanced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        block50: {
            block51: {
                LSFScheduler sch;
                String details;
                JFJobDefinitionBean jobDefinitionPanel;
                block49: {
                    this.m_pnlMain = new StandardPanel();
                    if (this.m_scheduler.getClassId().compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") != 0) break block51;
                    jobDefinitionPanel = null;
                    details = null;
                    sch = null;
                    try {
                        int os;
                        sch = (LSFScheduler)this.m_schmgr.getServerUtilities().getSchedulingServer(this.m_scheduler);
                        int n = os = this.m_djob.getBatchServer() != null ? this.m_djob.getBatchServer().getOperatingSystem() : -1;
                        if (os == 2) {
                            this.m_templateDefinitionPanel = new JFTemplateJobDefinitionBean();
                            JFTemplateJob templateJob = sch.getMainframeJob(this.m_djob);
                            this.m_templateDefinitionPanel.setTemplateJob(templateJob);
                        } else {
                            String resource;
                            String stderr;
                            String runas;
                            String savename = System.getProperty("app.name");
                            System.setProperty("app.name", m_bundle.getString("AdvanceJobPropertiesDialog.Title.txt"));
                            jobDefinitionPanel = new JFJobDefinitionBean();
                            jobDefinitionPanel.setJobNameEditable(false);
                            this.m_jobDefinitionPanel = jobDefinitionPanel;
                            details = this.m_djob.getSchedulerProperties();
                            if (savename == null) {
                                System.clearProperty("app.name");
                            } else {
                                System.setProperty("app.name", savename);
                            }
                            this.m_lsfJFJob = new JFJob(this.m_djob.getName());
                            if (details != null) {
                                try {
                                    this.m_lsfJFJob.initFromDefinition(details);
                                    this.m_lsfJFJob.setName(this.m_djob.getName());
                                }
                                catch (JFException jfe) {
                                    this.m_lsfJFJob = new JFJob(this.m_djob.getName());
                                }
                            }
                            if ((runas = this.m_djob.getUserId()) != null) {
                                this.m_lsfJFJob.setAttribute("UserName", runas);
                            } else {
                                this.m_lsfJFJob.setAttribute("UserName", "");
                            }
                            String stdout = sch.getStdout(this.m_flowname, this.m_lsfJFJob.getName());
                            if (stdout != null) {
                                this.m_lsfJFJob.setAttribute("Stdout", stdout);
                            }
                            if ((stderr = sch.getStderr(this.m_flowname, this.m_lsfJFJob.getName())) != null) {
                                this.m_lsfJFJob.setAttribute("Stderr", stderr);
                            }
                            if ((resource = LSFJob.genResourceSyntax((String)this.m_djob.getSchedulerResources())) != null) {
                                this.m_lsfJFJob.setAttribute("ResReqStr", resource);
                            } else {
                                String res = this.m_lsfJFJob.getAttribute("ResReqStr");
                                if (res != null && res.compareTo(CommandUtilities.getAppServerName((JobInfo)this.m_djob).replace(' ', SchedulerIMPL.SUBCHAR)) == 0) {
                                    this.m_lsfJFJob.setAttribute("ResReqStr", "");
                                }
                            }
                            FlowInfo info = this.m_schmgr.getFlowByName(this.m_flowname);
                            this.m_lsfJFFlow = sch.getFlowJobsAndDependencies(info);
                        }
                        if (this.m_templateDefinitionPanel != null) {
                        }
                        break block49;
                    }
                    catch (SchedulerException basicPanel) {
                        if (this.m_templateDefinitionPanel != null) {
                            this.m_templateDefinitionPanel.setEditable(false);
                            this.m_pane = new JScrollPane((Component)this.m_templateDefinitionPanel, 20, 30);
                            break block50;
                        }
                        if (jobDefinitionPanel != null) {
                            this.m_lsfJFJob.setAttribute("JobCmdLine", this.m_txtsascommand);
                            jobDefinitionPanel.setJFAdmin(true);
                            this._populateLSF(jobDefinitionPanel, sch);
                            if (this.m_lsfJFFlow != null) {
                                jobDefinitionPanel.setAvailableJobs(this.m_lsfJFFlow.availableJobs(this.m_lsfJFJob.getName()));
                                jobDefinitionPanel.setAdvancedPresubmitVisible(true);
                            } else if (details.contains("<PreSubmitJob")) {
                                jobDefinitionPanel.setAvailableJobs(new ArrayList());
                            }
                            jobDefinitionPanel.setJobDefinition(this.m_lsfJFJob);
                            jobDefinitionPanel.setEditable(this.m_editable);
                            this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                            break block50;
                        } else {
                            BasicAdvJobPropertiesPanel basicPanel2 = new BasicAdvJobPropertiesPanel(this.m_djob);
                            this.m_jobDefinitionPanel = basicPanel2;
                            basicPanel2.setCommandLine(this.m_txtsascommand);
                            basicPanel2.setRunAs(this.m_djob.getUserId());
                            basicPanel2.setJobDefinition(this.m_djob.getSchedulerProperties());
                            basicPanel2.setEditable(this.m_editable);
                            this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                        }
                        break block50;
                        catch (IOException basicPanel2) {
                            if (this.m_templateDefinitionPanel != null) {
                                this.m_templateDefinitionPanel.setEditable(false);
                                this.m_pane = new JScrollPane((Component)this.m_templateDefinitionPanel, 20, 30);
                                break block50;
                            }
                            if (jobDefinitionPanel != null) {
                                this.m_lsfJFJob.setAttribute("JobCmdLine", this.m_txtsascommand);
                                jobDefinitionPanel.setJFAdmin(true);
                                this._populateLSF(jobDefinitionPanel, sch);
                                if (this.m_lsfJFFlow != null) {
                                    jobDefinitionPanel.setAvailableJobs(this.m_lsfJFFlow.availableJobs(this.m_lsfJFJob.getName()));
                                    jobDefinitionPanel.setAdvancedPresubmitVisible(true);
                                } else if (details.contains("<PreSubmitJob")) {
                                    jobDefinitionPanel.setAvailableJobs(new ArrayList());
                                }
                                jobDefinitionPanel.setJobDefinition(this.m_lsfJFJob);
                                jobDefinitionPanel.setEditable(this.m_editable);
                                this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                                break block50;
                            } else {
                                BasicAdvJobPropertiesPanel basicPanel3 = new BasicAdvJobPropertiesPanel(this.m_djob);
                                this.m_jobDefinitionPanel = basicPanel3;
                                basicPanel3.setCommandLine(this.m_txtsascommand);
                                basicPanel3.setRunAs(this.m_djob.getUserId());
                                basicPanel3.setJobDefinition(this.m_djob.getSchedulerProperties());
                                basicPanel3.setEditable(this.m_editable);
                                this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                            }
                            break block50;
                            catch (InvalidParameterException e) {
                                if (ScheduleManager.isDebug()) {
                                    e.printStackTrace();
                                }
                                break block50;
                            }
                        }
                    }
                    this.m_templateDefinitionPanel.setEditable(false);
                    this.m_pane = new JScrollPane((Component)this.m_templateDefinitionPanel, 20, 30);
                    break block50;
                }
                if (jobDefinitionPanel != null) {
                    this.m_lsfJFJob.setAttribute("JobCmdLine", this.m_txtsascommand);
                    jobDefinitionPanel.setJFAdmin(true);
                    this._populateLSF(jobDefinitionPanel, sch);
                    if (this.m_lsfJFFlow != null) {
                        jobDefinitionPanel.setAvailableJobs(this.m_lsfJFFlow.availableJobs(this.m_lsfJFJob.getName()));
                        jobDefinitionPanel.setAdvancedPresubmitVisible(true);
                    } else if (details.contains("<PreSubmitJob")) {
                        jobDefinitionPanel.setAvailableJobs(new ArrayList());
                    }
                    jobDefinitionPanel.setJobDefinition(this.m_lsfJFJob);
                    jobDefinitionPanel.setEditable(this.m_editable);
                    this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                    break block50;
                } else {
                    BasicAdvJobPropertiesPanel basicPanel = new BasicAdvJobPropertiesPanel(this.m_djob);
                    this.m_jobDefinitionPanel = basicPanel;
                    basicPanel.setCommandLine(this.m_txtsascommand);
                    basicPanel.setRunAs(this.m_djob.getUserId());
                    basicPanel.setJobDefinition(this.m_djob.getSchedulerProperties());
                    basicPanel.setEditable(this.m_editable);
                    this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                }
                break block50;
                finally {
                    if (this.m_templateDefinitionPanel != null) {
                        this.m_templateDefinitionPanel.setEditable(false);
                        this.m_pane = new JScrollPane((Component)this.m_templateDefinitionPanel, 20, 30);
                    } else if (jobDefinitionPanel != null) {
                        this.m_lsfJFJob.setAttribute("JobCmdLine", this.m_txtsascommand);
                        jobDefinitionPanel.setJFAdmin(true);
                        this._populateLSF(jobDefinitionPanel, sch);
                        if (this.m_lsfJFFlow != null) {
                            jobDefinitionPanel.setAvailableJobs(this.m_lsfJFFlow.availableJobs(this.m_lsfJFJob.getName()));
                            jobDefinitionPanel.setAdvancedPresubmitVisible(true);
                        } else if (details.contains("<PreSubmitJob")) {
                            jobDefinitionPanel.setAvailableJobs(new ArrayList());
                        }
                        jobDefinitionPanel.setJobDefinition(this.m_lsfJFJob);
                        jobDefinitionPanel.setEditable(this.m_editable);
                        this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                    } else {
                        BasicAdvJobPropertiesPanel basicPanel = new BasicAdvJobPropertiesPanel(this.m_djob);
                        this.m_jobDefinitionPanel = basicPanel;
                        basicPanel.setCommandLine(this.m_txtsascommand);
                        basicPanel.setRunAs(this.m_djob.getUserId());
                        basicPanel.setJobDefinition(this.m_djob.getSchedulerProperties());
                        basicPanel.setEditable(this.m_editable);
                        this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
                    }
                }
            }
            BasicAdvJobPropertiesPanel jobDefinitionPanel = new BasicAdvJobPropertiesPanel(this.m_djob);
            this.m_jobDefinitionPanel = jobDefinitionPanel;
            jobDefinitionPanel.setCommandLine(this.m_txtsascommand);
            jobDefinitionPanel.setRunAs(this.m_djob.getUserId());
            jobDefinitionPanel.setJobDefinition(this.m_djob.getSchedulerProperties());
            jobDefinitionPanel.setEditable(this.m_editable);
            this.m_pane = new JScrollPane(this.m_jobDefinitionPanel, 20, 30);
        }
        super.setMainPanel(this.m_pnlMain);
        this.m_pnlMain.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlMain.add((Component)this.m_pane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setResizable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _populateLSF(JFJobDefinitionBean jobbean, LSFScheduler sch) {
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            JFAdminManager adminMgr = null;
            try {
                adminMgr = sch.getAdminManager();
            }
            catch (SchedulerException ex) {
                adminMgr = new JFAdminManager();
            }
            JFHost[] hosts = adminMgr.getAgentHosts();
            int numHosts = hosts.length;
            String[] list = new String[numHosts + 1];
            String[] modelList = new String[numHosts + 1];
            int index = 0;
            for (int i = 0; i < numHosts; ++i) {
                if (hosts[i] == null || !hosts[i].isServerHost()) continue;
                list[index] = hosts[i].getHostName();
                String hostModel = hosts[i].getHostModel();
                if (!hostModel.equalsIgnoreCase("UNKNOWN_AUTO_DETECT")) {
                    modelList[index] = hostModel;
                }
                ++index;
            }
            jobbean.setHostList(list);
            jobbean.setHostSpecList(modelList);
            String[] tmpqueues = adminMgr.getQueues();
            int numqueues = tmpqueues.length;
            String[] queues = new String[numqueues + 1];
            if (numqueues > 0) {
                for (int i = 0; i < numqueues; ++i) {
                    queues[i] = tmpqueues[i];
                }
            }
            jobbean.setQueueList(queues);
        }
        catch (JFException jfe) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
        return true;
    }

    public boolean moveViewToData() throws SchedulerException {
        if (this.m_scheduler.getClassId().compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0) {
            try {
                if (this.m_templateDefinitionPanel != null) {
                    return true;
                }
                if (this.m_jobDefinitionPanel != null) {
                    ((JFJobDefinitionBean)this.m_jobDefinitionPanel).updateDefinition();
                    String details = this.m_lsfJFJob.generateDefinition();
                    this.m_djob.setSchedulerProperties(details);
                    String tempcmdline = this.m_lsfJFJob.getAttribute("JobCmdLine");
                    if (this.m_txtsascommand.compareTo(tempcmdline) != 0) {
                        this.m_djob.setCommandLine(tempcmdline, false);
                        this.m_txtsascommand = tempcmdline;
                    }
                    String temprunas = this.m_lsfJFJob.getAttribute("UserName");
                    String runas = this.m_djob.getUserId();
                    String connectedUser = "";
                    if (this.m_schedulingUser != null) {
                        connectedUser = this.m_schedulingUser;
                    } else if (this.m_scheduler != null && this.m_scheduler.getUsername() != null) {
                        connectedUser = this.m_scheduler.getUsername();
                    }
                    if (runas != null && temprunas.compareTo(runas) != 0) {
                        if (temprunas.trim().length() == 0 || connectedUser.compareTo(temprunas) == 0 || temprunas.compareTo("guest") == 0) {
                            this.m_djob.setUserId(null);
                        } else {
                            this.m_djob.setUserId(temprunas);
                        }
                    } else if (connectedUser.compareTo(temprunas) != 0 && temprunas.trim().length() > 0 && temprunas.compareTo("guest") != 0) {
                        this.m_djob.setUserId(temprunas);
                    }
                    String resource = this.m_lsfJFJob.getAttribute("ResReqStr");
                    String res = LSFJob.genResourceSyntax((String)this.m_djob.getSchedulerResources());
                    if (res != null && res.compareTo(resource != null ? resource : "") != 0) {
                        if (resource == null || resource.length() == 0) {
                            this.m_djob.setSchedulerResources(null);
                        } else {
                            this.m_djob.setSchedulerResources(resource);
                        }
                    } else if (res == null && resource != null) {
                        this.m_djob.setSchedulerResources(resource);
                    }
                    if (!this.m_lsfJFJob.getName().equalsIgnoreCase(this.m_djob.getName())) {
                        this.m_djob.setName(this.m_lsfJFJob.getName());
                        this.m_lsfJFJob.setName(this.m_djob.getName());
                        this.m_djob.setSchedulerProperties(this.m_lsfJFJob.generateDefinition());
                    }
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                SchedulerException e = new SchedulerException(ex.getLocalizedMessage());
                throw e;
            }
        }
        try {
            String details = ((BasicAdvJobPropertiesPanel)((Object)this.m_jobDefinitionPanel)).getJobDefinition();
            this.m_djob.setSchedulerProperties(details);
            String tempcmdline = ((BasicAdvJobPropertiesPanel)((Object)this.m_jobDefinitionPanel)).getCommandLine();
            if (this.m_txtsascommand.compareTo(tempcmdline) != 0) {
                this.m_djob.setCommandLine(tempcmdline, false);
                this.m_txtsascommand = tempcmdline;
            }
            String runas = ((BasicAdvJobPropertiesPanel)((Object)this.m_jobDefinitionPanel)).getRunAs();
            String ras = this.m_djob.getUserId();
            if (ras != null && runas != null && runas.compareTo(ras) != 0) {
                if (runas.length() == 0) {
                    this.m_djob.setUserId(null);
                } else {
                    this.m_djob.setUserId(runas);
                }
            }
            if (!((BasicAdvJobPropertiesPanel)((Object)this.m_jobDefinitionPanel)).getName().equalsIgnoreCase(this.m_djob.getName())) {
                this.m_djob.setName(((BasicAdvJobPropertiesPanel)((Object)this.m_jobDefinitionPanel)).getName());
            }
            return true;
        }
        catch (Exception ex) {
            SchedulerException e = new SchedulerException(ex.getLocalizedMessage());
            throw e;
        }
    }

    protected boolean onOK() throws SchedulerException {
        if (this.validateData()) {
            if (this.moveViewToData()) {
                this.m_eReturnValue = 1;
                return true;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), m_bundle.getString("AdvanceJobPropertiesDialog.ErrorMessage.UnableToSaveContents.txt"), m_bundle.getString("AdvanceJobPropertiesDialog.Title.txt"), 0);
            return false;
        }
        return false;
    }

    public boolean validateData() throws SchedulerException {
        if (this.m_editable) {
            if (this.m_scheduler.getClassId().compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0) {
                try {
                    if (this.m_templateDefinitionPanel != null) {
                        return true;
                    }
                    if (this.m_jobDefinitionPanel != null) {
                        JFJobDefinitionBean bean = null;
                        if (this.m_jobDefinitionPanel instanceof JFJobDefinitionBean) {
                            bean = (JFJobDefinitionBean)this.m_jobDefinitionPanel;
                            bean.updateDefinition();
                            JFJob newJob = bean.getJobDefinition();
                            if (LSFJob.isValidName((String)newJob.getName())) {
                                return true;
                            }
                            SchedulerException ex = new SchedulerException(m_bundle.messageString("AdvanceJobPropertiesDialog.InvalidChars.Message.fmt", (Object)DeployedFlow.getInvalidChars()), LSFJob.class, "AdvanceJobPropertiesDialog.InvalidChars.Message.fmt", new Object[]{DeployedFlow.getInvalidChars()});
                            throw ex;
                        }
                        return false;
                    }
                    return false;
                }
                catch (Exception e) {
                    SchedulerException ex = new SchedulerException(e.getMessage());
                    throw ex;
                }
            }
            try {
                if (DeployedJob.isValidName((String)this.m_jobDefinitionPanel.getName())) {
                    return true;
                }
                SchedulerException ex = new SchedulerException(m_bundle.messageString("AdvanceJobPropertiesDialog.InvalidChars.Message.fmt", (Object)DeployedFlow.getInvalidChars()), OSJob.class, "AdvanceJobPropertiesDialog.InvalidChars.Message.fmt", new Object[]{DeployedFlow.getInvalidChars()});
                throw ex;
            }
            catch (Exception e) {
                SchedulerException ex = new SchedulerException(e.getMessage());
                throw ex;
            }
        }
        return true;
    }

    private class BasicAdvJobPropertiesPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JobInfo mc_job = null;
        private JTextField mc_command = new JTextField();
        private static final String OSJobTag = "OSJobV1:";
        private static final String OSJobDefinitionSeparator = "||";
        private static final String OSJobName = "Name:";
        private static final String OSJobCommand = "Command:";
        private static final String OSJobRunAs = "RunAs:";
        private static final String OSJobResource = "Resource:";

        public BasicAdvJobPropertiesPanel(JobInfo job) {
            this.mc_job = job;
            this.initialize();
        }

        public String getName() {
            return this.mc_job.getName();
        }

        public void setName(String text) {
            this.mc_job.setName(text);
        }

        public String getCommandLine() {
            return this.mc_command.getText();
        }

        public boolean setCommandLine(String text) {
            this.mc_command.setText(text);
            return true;
        }

        public String getRunAs() {
            return this.mc_job.getUserId();
        }

        public boolean setRunAs(String text) {
            this.mc_job.setUserId(text);
            return true;
        }

        public String getJobDefinition() {
            StringBuffer jobDefinition = new StringBuffer(OSJobTag);
            jobDefinition.append(OSJobName);
            jobDefinition.append("<job Name=\"" + this.mc_job.getName() + "\"/>");
            jobDefinition.append(OSJobDefinitionSeparator);
            jobDefinition.append(OSJobCommand);
            jobDefinition.append("<command Value=\"" + this.mc_command.getText() + "\"/>");
            jobDefinition.append(OSJobDefinitionSeparator);
            if (this.mc_job.getUserId() != null) {
                jobDefinition.append(OSJobRunAs);
                jobDefinition.append("<runas Value=\"" + this.mc_job.getUserId() + "\"/>");
                jobDefinition.append(OSJobDefinitionSeparator);
            }
            if (this.mc_job.getSchedulerResources() != null) {
                jobDefinition.append(OSJobResource);
                jobDefinition.append("<resource Value=\"" + this.mc_job.getSchedulerResources() + "\"/>");
                jobDefinition.append(OSJobDefinitionSeparator);
            }
            return jobDefinition.toString();
        }

        public boolean setJobDefinition(String text) {
            Document doc;
            NodeList nodes;
            Node node;
            NamedNodeMap map;
            Node node1;
            Node node12;
            NamedNodeMap map2;
            Node node2;
            NodeList nodes2;
            Document doc2;
            if (text == null) {
                return false;
            }
            String nameString = this.getString(text, OSJobName);
            if (nameString == null) {
                return false;
            }
            String commandString = this.getString(text, OSJobCommand);
            if (commandString == null) {
                return false;
            }
            String name = null;
            String command = null;
            String runas = null;
            String resource = null;
            try {
                doc2 = GeneralUtilities.parseXML((String)nameString);
                nodes2 = doc2.getElementsByTagName("job");
                node2 = nodes2.item(0);
                map2 = node2.getAttributes();
                node12 = map2.getNamedItem("Name");
                if (node12 != null) {
                    name = node12.getNodeValue();
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
            try {
                doc2 = GeneralUtilities.parseXML((String)commandString);
                nodes2 = doc2.getElementsByTagName("command");
                node2 = nodes2.item(0);
                map2 = node2.getAttributes();
                node12 = map2.getNamedItem("Value");
                if (node12 != null) {
                    command = node12.getNodeValue();
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
            try {
                String runasString = this.getString(text, OSJobRunAs);
                if (runasString != null && (node1 = (map = (node = (nodes = (doc = GeneralUtilities.parseXML((String)runasString)).getElementsByTagName("runas")).item(0)).getAttributes()).getNamedItem("Value")) != null) {
                    runas = node1.getNodeValue();
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
            try {
                String resourceString = this.getString(text, OSJobResource);
                if (resourceString != null && (node1 = (map = (node = (nodes = (doc = GeneralUtilities.parseXML((String)resourceString)).getElementsByTagName("resource")).item(0)).getAttributes()).getNamedItem("Value")) != null) {
                    resource = node1.getNodeValue();
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
            this.mc_job.setUserId(runas);
            this.mc_job.setSchedulerResources(resource);
            this.mc_command.setText(command);
            try {
                this.mc_job.setName(name);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return true;
        }

        public void setEditable(boolean flag) {
            this.mc_command.setEditable(flag);
        }

        private void initialize() {
            String text = m_bundle.getString("AdvanceJobPropertiesDialog.CommandLabel.txt");
            JLabel label = new JLabel(Util.getLabelWithoutMnemonic((String)text));
            label.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)text));
            label.setLabelFor(this.mc_command);
            GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc2 = new GridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            this.mc_command.setPreferredSize(new Dimension(300, 20));
            this.add(label, gbc1);
            this.add(this.mc_command, gbc2);
        }

        public boolean onParentOK() {
            if (super.onParentOK()) {
                this.mc_job = null;
                return true;
            }
            return false;
        }

        public boolean onParentCancel() {
            if (super.onParentCancel()) {
                this.mc_job = null;
                return true;
            }
            return false;
        }

        private String getString(String definition, String type) {
            int start = definition.indexOf(type, 0);
            if (start < 0) {
                return null;
            }
            int end = definition.indexOf(OSJobDefinitionSeparator, start);
            if (end < 0) {
                return null;
            }
            String result = definition.substring(start + type.length(), end).trim();
            return result;
        }
    }
}

