/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.JobPropertiesPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class AddItemByFolderPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private ActionListener m_jobPropertiesListener = null;
    private ScheduleManager m_schmgr;
    private Frame m_frame;
    private JLabel m_lblDescription;
    private JLabel m_folderlabel;
    private JTextField m_folder = new JTextField();
    private JButton m_btnSelectFolder = new JButton();
    private ListSelector m_dualJobList;
    private TreeSet<JobInfo> m_sourceJobList = null;
    private List<JobInfo> m_joblist = null;
    private TreeSet<JobInfo> m_targetJobList = null;
    private CollectionToListModelAdapter m_sourceModel = new CollectionToListModelAdapter();
    private CollectionToListModelAdapter m_targetModel = new CollectionToListModelAdapter();
    private JButton m_btnProperties;
    private FlowInfo m_flow;
    private ArrayList<JobInfo> m_addedItems;

    public AddItemByFolderPanel(ScheduleManager schmgr, FlowInfo flow) {
        this.m_schmgr = schmgr;
        this.m_frame = schmgr.getMainFrame();
        this.m_flow = flow;
        this.__initialize(m_bundle.getString("AddItemByFolderPanel.Description.txt"));
    }

    public void saveSettingsAndCleanUp() {
        this.m_lblDescription = null;
        this.m_folder = null;
        this.m_btnSelectFolder = null;
        this.m_dualJobList = null;
        this.m_sourceJobList = null;
        this.m_joblist = null;
        this.m_targetJobList = null;
        this.m_sourceModel = null;
        this.m_targetModel = null;
        this.m_frame = null;
        this.m_btnProperties = null;
        this.m_flow = null;
        this.m_frame = null;
    }

    private void __initialize(String header) {
        int height;
        int width;
        this.setLists(this.m_flow.getLocation(), false);
        this.m_lblDescription = new JLabel(header);
        String folderText = m_bundle.getString("AddItemByFolderPanel.FolderLabel.txt");
        this.m_folderlabel = new JLabel(Util.getLabelWithoutMnemonic((String)folderText));
        this.m_folderlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)folderText));
        this.m_folderlabel.setLabelFor(this.m_folder);
        this.m_folder.setText(this.m_flow.getLocation());
        this.m_folder.setEditable(false);
        String selectText = m_bundle.getString("AddItemByFolderPanel.Select.txt");
        this.m_btnSelectFolder.setText(Util.getLabelWithoutMnemonic((String)selectText));
        this.m_btnSelectFolder.setMnemonic(Util.getDisplayedMnemonic((String)selectText));
        this.m_btnSelectFolder.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)selectText));
        ActionListener selectFolderListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SASFolder folder = AddItemByFolderPanel.this.m_schmgr.browseSASFolders(AddItemByFolderPanel.this.m_folder.getText());
                if (folder != null) {
                    String name = folder.getLocation();
                    AddItemByFolderPanel.this.setFolder(name);
                    AddItemByFolderPanel.this.setLists(name, true);
                }
            }
        };
        this.m_btnSelectFolder.addActionListener(selectFolderListener);
        this.m_btnSelectFolder.setVisible(true);
        this.m_dualJobList = new ListSelector();
        this.m_dualJobList.setTargetControlsVisible(false);
        this.m_dualJobList.setDragAndDropEnabled(false);
        this.m_dualJobList.setAlternatingSingleButtonStyle(false);
        this.m_dualJobList.setAlternatingMultipleButtonStyle(false);
        this.setLayout(new GridBagLayout());
        try {
            width = Integer.valueOf(m_bundle.getString("AddItemByFolderPanel.width.txt"));
            height = Integer.valueOf(m_bundle.getString("AddItemByFolderPanel.height.txt"));
        }
        catch (NumberFormatException ex) {
            width = 600;
            height = 300;
        }
        this.m_dualJobList.setPreferredSize(new Dimension(width, height));
        GridBagConstraints gbc_description = new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_folderLabel = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_folder = new GridBagConstraints(1, 2, 3, 1, 4.0, 1.0, 17, 2, new Insets(7, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_selectFolder = new GridBagConstraints(4, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_dualJobList = new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 17, 1, new Insets(20, 20, 15, 0), 0, 0);
        GridBagConstraints gbc_properties = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0);
        this.add(this.m_lblDescription, gbc_description);
        this.add(this.m_folderlabel, gbc_folderLabel);
        this.add(this.m_folder, gbc_folder);
        this.add(this.m_btnSelectFolder, gbc_selectFolder);
        this.add((Component)((Object)this.m_dualJobList), gbc_dualJobList);
        String propertiesString = m_bundle.getString("AddItemByFolderPanel.JobProperties.txt");
        this.m_btnProperties = new JButton(Util.getLabelWithoutMnemonic((String)propertiesString));
        this.m_btnProperties.setMnemonic(Util.getDisplayedMnemonic((String)propertiesString));
        this.m_btnProperties.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)propertiesString));
        this.m_btnProperties.setToolTipText(m_bundle.getString("AddItemByFolderPanel.JobProperties.ToolTip.txt"));
        this.m_btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddItemByFolderPanel.this.btnPropertiesOnclicked();
            }
        });
        this.add(this.m_btnProperties, gbc_properties);
        this.m_btnProperties.setEnabled(false);
    }

    private boolean setLists(String folder, boolean moveDataToView) {
        this.m_joblist = this.m_schmgr.getAvailableJobsSubflowsByLocation(folder, this.m_flow.getJobs());
        this.m_targetJobList = new TreeSet(new CompareDisplayInfoObjects());
        if (moveDataToView) {
            return this.moveDataToView();
        }
        return true;
    }

    public List<JobInfo> getAddedItems() {
        return this.m_addedItems;
    }

    public boolean moveDataToView() {
        this.setListeningForChanges(true);
        this.m_sourceJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_sourceJobList.addAll(this.m_joblist);
        this.m_sourceModel.setModel(this.m_sourceJobList);
        this.m_targetModel.setModel(this.m_targetJobList);
        this.m_dualJobList.setModel((ListModel)this.m_sourceModel);
        this.m_dualJobList.setTargetModel((ListModel)this.m_targetModel);
        return true;
    }

    public boolean moveDataToView(List<JobInfo> available, List<JobInfo> selected) {
        this.m_sourceJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_sourceJobList.addAll(available);
        this.m_targetJobList = new TreeSet(new CompareDisplayInfoObjects());
        this.m_targetJobList.addAll(selected);
        this.m_sourceModel.setModel(this.m_sourceJobList);
        this.m_targetModel.setModel(this.m_targetJobList);
        this.m_dualJobList.setModel((ListModel)this.m_sourceModel);
        this.m_dualJobList.setTargetModel((ListModel)this.m_targetModel);
        return true;
    }

    public boolean moveViewToData() {
        this.m_addedItems = new ArrayList<JobInfo>(this.m_targetJobList);
        if (this.m_addedItems.size() == 0) {
            return false;
        }
        List existingJobs = this.m_flow.getJobs();
        return existingJobs.addAll(this.m_addedItems);
    }

    public boolean validateData() {
        ArrayList<String> jobsProcessed = new ArrayList<String>();
        for (JobInfo job : this.m_targetJobList) {
            String jobname = job.getName();
            if (jobsProcessed.contains(jobname)) {
                String errorMessage = MessageFormat.format(m_bundle.getString("AddItemByFolderPanel.DuplicateJobname.Message.fmt"), jobname);
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("AddItemByFolderPanel.Title.txt"), (int)0);
                return false;
            }
            jobsProcessed.add(jobname);
        }
        return true;
    }

    public String getFolder() {
        return this.m_folder.getText();
    }

    public boolean setFolder(String name) {
        this.m_folder.setText(name);
        this.m_folder.setToolTipText(name);
        this.m_folder.firePropertyChange("setText", false, true);
        return true;
    }

    public void setPropertiesListener(ActionListener actL) {
        this.m_jobPropertiesListener = actL;
        this.m_btnProperties.setEnabled(true);
    }

    private void btnPropertiesOnclicked() {
        JobInfo info = this.m_dualJobList.getSelected();
        String title = MessageFormat.format(m_bundle.getString("AddItemByFolderPanel.JobProperties.Title.fmt"), info.getName());
        if (this.m_jobPropertiesListener != null) {
            try {
                this.m_jobPropertiesListener.actionPerformed(new ActionEvent(info, 1001, null));
            }
            catch (RuntimeException rte) {
                String message = rte.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = rte.toString();
                }
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
            }
        } else if (info instanceof JobInfo) {
            JobInfo jinfo = info;
            JobPropertiesPanel panel = new JobPropertiesPanel(jinfo);
            StandardDialog dlg = new StandardDialog(this.m_frame, title, true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_job_properties");
            dlg.makeVisible();
        } else {
            String message = m_bundle.getString("AddItemByFolderPanel.JobProperties.NotAvailable.txt");
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
        }
    }

    static {
        String strClassName = AddItemByFolderPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class ListSelector
    extends DualListSelector {
        private static final long serialVersionUID = 1L;
        JList m_sourceList;
        JList m_targetList;

        public ListSelector() {
            String sourceText = m_bundle.getString("AddItemByFolderPanel.SourceLabel.txt");
            this.sourceLabel.setText(Util.getLabelWithoutMnemonic((String)sourceText));
            this.sourceLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sourceText));
            String targetText = m_bundle.getString("AddItemByFolderPanel.TargetLabel.txt");
            this.targetLabel.setText(Util.getLabelWithoutMnemonic((String)targetText));
            this.targetLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)targetText));
            this.rightButton.setToolTipText(m_bundle.getString("AddItemByFolderPanel.RightButton.ToolTip.txt"));
            this.allRightButton.setToolTipText(m_bundle.getString("AddItemByFolderPanel.AllRightButton.ToolTip.txt"));
            this.leftButton.setToolTipText(m_bundle.getString("AddItemByFolderPanel.LeftButton.ToolTip.txt"));
            this.allLeftButton.setToolTipText(m_bundle.getString("AddItemByFolderPanel.AllLeftButton.ToolTip.txt"));
            this.getSourceComponent().setToolTipText(m_bundle.getString("AddItemByFolderPanel.SourceList.ToolTip.txt"));
            this.getTargetComponent().setToolTipText(m_bundle.getString("AddItemByFolderPanel.TargetList.ToolTip.txt"));
            this.__initialize();
        }

        public JobInfo getSelected() {
            if (this.m_sourceList != null && this.m_targetList != null) {
                if (AddItemByFolderPanel.this.m_sourceModel.getSize() > 0 && this.m_sourceList.getSelectedIndex() >= 0) {
                    return (JobInfo)this.m_sourceList.getSelectedValue();
                }
                if (AddItemByFolderPanel.this.m_targetModel.getSize() > 0 && this.m_targetList.getSelectedIndex() >= 0) {
                    return (JobInfo)this.m_targetList.getSelectedValue();
                }
            }
            return null;
        }

        public void __initialize() {
            if (this.getSourceComponent() instanceof JList) {
                this.m_sourceList = (JList)this.getSourceComponent();
            }
            if (this.getTargetComponent() instanceof JList) {
                this.m_targetList = (JList)this.getTargetComponent();
            }
        }
    }
}

