/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.RunHistory;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class RunHistoryTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(RunHistoryTableModel.class);
    private List<RunHistory> m_alHistories;
    public static final int FLOWNAME_COL = 0;
    public static final int NAME_COL = 1;
    public static final int START_COL = 2;
    public static final int RUNNER_COL = 3;
    public static final int ID_COL = 4;
    public static final int RETRY_COL = 5;
    public static final int STATUS_COL = 6;
    public static final int FINISH_COL = 7;
    public static final int USERNAME_COL = 8;
    protected static final int W_FLOWNAME_COL = 120;
    protected static final int W_NAME_COL = 120;
    protected static final int W_START_COL = 120;
    protected static final int W_RUNNER_COL = 120;
    protected static final int W_ID_COL = 60;
    protected static final int W_RETRY_COL = 60;
    protected static final int W_STATUS_COL = 60;
    protected static final int W_FINISH_COL = 120;
    protected static final int W_USERNAME_COL = 120;
    protected static final int TOTAL_COLS = 4;
    protected static final int TOTAL_HIDDEN_COLS = 5;

    public RunHistoryTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, m_bundle.getString("RunHistoryTableModel.FlowNameHeader.txt"), 120);
        this.m_aColumns[1] = new WsStringTableColumn(1, m_bundle.getString("RunHistoryTableModel.NameHeader.txt"), 120);
        this.m_aColumns[2] = new WsDateTableColumn(2, m_bundle.getString("RunHistoryTableModel.StartlHeader.txt"), 120);
        this.m_aColumns[3] = new WsStringTableColumn(3, m_bundle.getString("RunHistoryTableModel.RunnerHeader.txt"), 120);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 5;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }

    public void addRow(RunHistory info) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        newRow.add(info.getParentNameDataBinding());
        newRow.add(info.getItemNameDataBinding());
        if (info.getStartTimeDataBinding() != null) {
            newRow.add(((GregorianCalendar)info.getStartTimeDataBinding()).getTime());
        } else {
            newRow.add(null);
        }
        newRow.add(info.getRendererDataBinding());
        this.m_lData.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        ++this.m_nRowInstances;
    }

    public void deleteRow(int nRow) {
        List lRowData = this.getRowValues(nRow);
        this.m_lData.remove(lRowData);
        this.fireTableRowDeleted(nRow, lRowData);
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
        int oldRowCount = this.m_lData.size();
        this.m_lData.clear();
        if (oldRowCount > 0) {
            this.fireTableRowsDeleted(0, oldRowCount - 1);
        }
        int nRows = 0;
        Iterator<RunHistory> it = this.m_alHistories.iterator();
        while (it.hasNext()) {
            ArrayList<Object> newRow = new ArrayList<Object>();
            RunHistory obj = it.next();
            if (!(obj instanceof RunHistory)) continue;
            RunHistory info = obj;
            newRow.add(info.getParentNameDataBinding());
            newRow.add(info.getItemNameDataBinding());
            if (info.getStartTimeDataBinding() != null) {
                newRow.add(((GregorianCalendar)info.getStartTimeDataBinding()).getTime());
            } else {
                newRow.add(null);
            }
            newRow.add(info.getRendererDataBinding());
            this.m_lData.add(newRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() {
    }

    public List<?> getHistories() {
        return this.m_alHistories;
    }

    public void setJobRenderers(List<RunHistory> list) {
        this.m_alHistories = list;
    }
}

