/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.console.filter.visuals.FilterTablePane;
import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.console.plugins.TableModelInterface;
import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.DataStepProgramRedeployerAction;
import com.sas.scheduler.schmgr.DeleteFlowAction;
import com.sas.scheduler.schmgr.DeleteJobAction;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.PropertyAction;
import com.sas.scheduler.schmgr.ReadLogfileAction;
import com.sas.scheduler.schmgr.ReportFlowAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SetBatchServerAction;
import com.sas.scheduler.schmgr.SetJobAction;
import com.sas.scheduler.schmgr.SetSchedulerAction;
import com.sas.scheduler.schmgr.model.CompareDateString;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.OperationThread;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsComparatorFactory;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;

public class JobsTableModel
extends WsAbstractTableModel
implements TableModelInterface,
NeoTableModelInterface {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobsTableModel.class);
    private NodeInterface m_node;
    private ScheduleManager m_schmgr;
    private Vector m_initialList = null;
    private Vector m_infoList = new Vector();
    private FilterSelector m_filter = null;
    private JobColumnSelectorModel m_columns;
    private HashMap m_runthreadlist = new HashMap();

    public JobsTableModel(NodeInterface node, List itemsList, JobColumnSelectorModel columns) {
        this(node, itemsList, null, columns);
    }

    public JobsTableModel(NodeInterface node, List itemsList, FilterSelector filter, JobColumnSelectorModel columns) {
        this.m_node = node;
        this.m_schmgr = (ScheduleManager)node.getPlugin();
        this.m_initialList = new Vector(itemsList);
        this.m_filter = filter;
        this.m_columns = columns;
        this._buildData(itemsList, false);
        int numOfCols = this.m_columns.getColumnCount();
        this.m_aColumns = new WsAbstractTableColumn[numOfCols];
        block5: for (int colH = 0; colH < numOfCols; ++colH) {
            String colName = this.m_columns.getColumnName(colH);
            switch (this.m_columns.getColumnType(colName)) {
                case 0: {
                    this.m_aColumns[colH] = new WsStringTableColumn(colH, colName, this.m_columns.getColumnWidth(colH));
                    if (JobColumnSelectorModel.getColumnKeyFromName((String)colName) != 7) continue block5;
                    this.m_aColumns[colH].setComparator((Comparator)new CompareDateString(Locale.getDefault()));
                    continue block5;
                }
                case 2: {
                    Date date = new Date();
                    this.m_aColumns[colH] = new WsDateTableColumn(colH, colName, this.m_columns.getColumnWidth(colH), date);
                    this.m_aColumns[colH].setComparator(WsComparatorFactory.createComparator(Date.class));
                    continue block5;
                }
                case 1: {
                    this.m_aColumns[colH] = new WsIntegerTableColumn(colH, colName, this.m_columns.getColumnWidth(colH));
                }
            }
        }
    }

    public WsAbstractTableModel getModel() {
        return this;
    }

    public String getSettingPrefix() {
        String settingPrefix = "FILTERTABLEVIEW_JOB_" + this.m_node.getName();
        return settingPrefix;
    }

    public List getFilters() {
        if (this.m_filter != null) {
            return this.m_schmgr.getJobFilters();
        }
        return null;
    }

    public boolean isHidden(int index) {
        return this.m_columns.isHidden(index);
    }

    public NodeInterface getNode() {
        return this.m_node;
    }

    private void _buildData(List itemsList, boolean update) {
        int startRow;
        ArrayList<DisplayInfo> neoItemList;
        block18: {
            block16: {
                block17: {
                    neoItemList = new ArrayList<DisplayInfo>();
                    if (this.m_filter == null) break block16;
                    if (!this.m_filter.isSimpleNameFilter()) break block17;
                    FilterRule rule = this.m_filter.getRule(0);
                    int numRows = itemsList.size();
                    String value = rule.getValue();
                    switch (rule.getCondition()) {
                        case 0: {
                            DisplayInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (DisplayInfo)itemsList.get(i);
                                if (info == null || !info.getName().matches(value)) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 3: {
                            DisplayInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (DisplayInfo)itemsList.get(i);
                                if (info == null || info.getName().indexOf(value) < 0) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 1: {
                            DisplayInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (DisplayInfo)itemsList.get(i);
                                if (info == null || !info.getName().startsWith(value)) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 2: {
                            DisplayInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (DisplayInfo)itemsList.get(i);
                                if (info == null || !info.getName().endsWith(value)) continue;
                                neoItemList.add(info);
                            }
                            break;
                        }
                    }
                    break block18;
                }
                if (this.m_node instanceof FlowNode) {
                    ScheduleManager.setStatusText("");
                    ServerFlowInfo finfo = ((FlowNode)this.m_node).getFlowInfo();
                    List temp = finfo.getJobsForFlow(this.m_filter);
                    for (int j = 0; j < temp.size(); ++j) {
                        DisplayInfo t = (DisplayInfo)temp.get(j);
                        if (t == null) continue;
                        int numRows = itemsList.size();
                        for (int i = 0; i < numRows; ++i) {
                            DisplayInfo info = (DisplayInfo)itemsList.get(i);
                            if (info == null || !info.getName().equals(t.getName())) continue;
                            neoItemList.add(info);
                        }
                    }
                }
                break block18;
            }
            neoItemList.addAll(itemsList);
        }
        int numRows = neoItemList.size();
        int n = startRow = this.m_infoList != null ? this.m_infoList.size() : 0;
        if (!update) {
            this.m_infoList = new Vector(numRows);
        }
        for (int i = 0; i < numRows; ++i) {
            DisplayInfo info = (DisplayInfo)neoItemList.get(i);
            this.m_infoList.addElement(info);
        }
        if (update && numRows > 0) {
            this.fireTableRowsInserted(startRow, startRow + numRows - 1);
            this.fireTableDataChanged();
        }
        this.m_runthreadlist = new HashMap();
    }

    public void refresh(List itemsList) {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this._buildData(itemsList, false);
        if (this.getRowCount() > 0) {
            this.fireTableRowsInserted(0, this.getRowCount() - 1);
        }
    }

    public void refresh(FilterSelector filter) {
        this.m_filter = filter;
        this.refresh(this.m_initialList);
    }

    public void refreshRowData(int row) {
        ArrayList<Object> sysrow = new ArrayList<Object>();
        for (int j = 0; j < this.m_aColumns.length; ++j) {
            sysrow.add(this.getValueAt(row, j));
        }
        this.m_lData.set(row, sysrow);
    }

    public int getColumnType(String columnName) {
        return this.m_columns.getColumnType(columnName);
    }

    public int getColumnCount() {
        return this.m_columns.getColumnCount();
    }

    private int getVisibleColumnCount() {
        int numColumns = this.m_aColumns.length;
        int numHidden = this.m_aHiddenColumns != null ? this.m_aHiddenColumns.length : 0;
        return numColumns - numHidden;
    }

    public List getContextMenuActions(ListSelectionModel selectionModel) {
        int[] selectedRows = null;
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        int nCols = this.getVisibleColumnCount();
        int iMinRow = iMin / nCols;
        int iMaxRow = iMax / nCols;
        int iStart = iMinRow * nCols;
        int iStartNext = iStart + nCols;
        int[] aSelectedRows = new int[1 + (iMaxRow - iMinRow)];
        int nSelectedRows = 0;
        for (int iRow = iMinRow; iRow <= iMaxRow; ++iRow) {
            for (int i = iStart; i < iStartNext; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                aSelectedRows[nSelectedRows++] = iRow;
                break;
            }
            iStart = iStartNext;
            iStartNext += nCols;
        }
        selectedRows = new int[nSelectedRows];
        System.arraycopy(aSelectedRows, 0, selectedRows, 0, nSelectedRows);
        return this.getContextMenuActions(selectedRows);
    }

    public List getContextMenuActions(int[] selectionRows) {
        FilterTableView view;
        FilterTablePane p;
        List<SetBatchServerAction> contextMenuActionsList = new ArrayList<SetBatchServerAction>();
        Object[] selectionList = this.getSelectedObjects(selectionRows);
        ReadLogfileAction rla = null;
        CustomViewInterface cus = this.m_node.getCustomView();
        if (cus instanceof FilterTableView && (p = (view = (FilterTableView)cus).getFilterTablePane()) != null) {
            Vector cols = p.getSelectedColumns();
            String logColname = JobColumnSelectorModel.getColumnNameForKey((int)8);
            Iterator i = cols.iterator();
            while (i.hasNext()) {
                int col = (Integer)i.next();
                String c = p.getColNameFromView(col);
                if (c.compareTo(logColname) != 0) continue;
                rla = new ReadLogfileAction(selectionList, this.m_schmgr);
                break;
            }
        }
        if (selectionList.length == 1) {
            PropertyAction propertiesAction;
            AbstractNode node;
            if (selectionList[0] instanceof ServerJobInfo) {
                ServerJobInfo job = (ServerJobInfo)selectionList[0];
                node = null;
                if (this.m_node instanceof JobNode) {
                    FlowNode parent = (FlowNode)((Object)((JobNode)this.m_node).getParent());
                    node = this.m_schmgr.getNodeFromInfo(job, (NodeInterface)parent);
                } else {
                    node = this.m_schmgr.getNodeFromInfo(job, this.m_node);
                }
                contextMenuActionsList.add(new SetBatchServerAction(job, this.m_schmgr, (JobNode)node));
                if (job.isJobAssociationError()) {
                    contextMenuActionsList.add((SetBatchServerAction)((Object)new SetJobAction(job, this.m_schmgr, (JobNode)node)));
                }
                contextMenuActionsList.add((SetBatchServerAction)((Object)new DeleteJobAction(job, this.m_schmgr, (JobNode)node)));
                if (job.isRedeployable()) {
                    contextMenuActionsList.add((SetBatchServerAction)((Object)new DataStepProgramRedeployerAction(job, this.m_schmgr, (JobNode)node)));
                }
                propertiesAction = new PropertyAction((ServerInfoInterface)job, this.m_schmgr);
                contextMenuActionsList.add((SetBatchServerAction)((Object)propertiesAction));
                if (rla != null) {
                    contextMenuActionsList.add((SetBatchServerAction)((Object)rla));
                }
            } else if (selectionList[0] instanceof ServerFlowInfo) {
                ServerFlowInfo flow = (ServerFlowInfo)selectionList[0];
                node = this.m_schmgr.getNodeFromInfo(flow, this.m_node);
                if (node instanceof FlowNode) {
                    contextMenuActionsList.add((SetBatchServerAction)((Object)new ReportFlowAction(flow, this.m_schmgr, (FlowNode)node)));
                    contextMenuActionsList.add((SetBatchServerAction)((Object)new SetSchedulerAction(flow, this.m_schmgr, (FlowNode)node)));
                }
                contextMenuActionsList.add((SetBatchServerAction)((Object)new DeleteFlowAction(flow, this.m_schmgr, node)));
                propertiesAction = new PropertyAction((ServerInfoInterface)flow, this.m_schmgr);
                contextMenuActionsList.add((SetBatchServerAction)((Object)propertiesAction));
            }
        } else if (selectionList.length > 1) {
            contextMenuActionsList.add(new SetBatchServerAction(selectionList, this.m_schmgr));
            contextMenuActionsList.add((SetBatchServerAction)((Object)new DeleteJobAction(selectionList, this.m_schmgr, this.m_node)));
            contextMenuActionsList.add((SetBatchServerAction)((Object)new DataStepProgramRedeployerAction(selectionList, this.m_schmgr)));
            if (rla != null) {
                contextMenuActionsList.add((SetBatchServerAction)((Object)rla));
            }
        } else if (selectionList.length < 1) {
            contextMenuActionsList = this.m_node.getContextMenuActions();
        }
        return contextMenuActionsList;
    }

    public List getToolBarActions(ListSelectionModel selectionModel) {
        return this.getContextMenuActions(selectionModel);
    }

    public List getToolBarActions(int[] selectionRows) {
        return this.getContextMenuActions(selectionRows);
    }

    public String getColumnName(int columnIndex) {
        return this.m_aColumns[columnIndex].getName();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value;
        block33: {
            value = "";
            try {
                if (this.m_infoList.get(rowIndex) instanceof ServerJobInfo) {
                    ServerJobInfo info = (ServerJobInfo)this.m_infoList.get(rowIndex);
                    switch (JobColumnSelectorModel.getColumnKeyFromName((String)this.m_aColumns[columnIndex].getName())) {
                        case 0: {
                            value = info.getName();
                            break;
                        }
                        case 1: {
                            value = info.getId();
                            break;
                        }
                        case 2: {
                            value = info.getDateCreated();
                            break;
                        }
                        case 3: {
                            value = info.getDateModified();
                            break;
                        }
                        case 4: {
                            value = info.getBatchServerName();
                            break;
                        }
                        case 5: {
                            value = info.getApplicationName();
                            break;
                        }
                        case 6: {
                            value = info.getRunAs();
                            break;
                        }
                        case 7: {
                            if (info.isDataGathered()) {
                                if (this.m_node instanceof FlowNode) {
                                    value = info.getLastExecuted(((FlowNode)this.m_node).getFlowInfo(), true);
                                    break;
                                }
                                if (this.m_node instanceof JobNode) {
                                    value = info.getLastExecuted(((FlowNode)((Object)this.m_node.getParent())).getFlowInfo(), true);
                                    break;
                                }
                            } else {
                                value = m_bundle.getString("JobsTableModel.Pending.txt");
                                String name = this.m_node.getName() + info.getName() + rowIndex + "_" + columnIndex;
                                if (!this.m_runthreadlist.containsKey(name)) {
                                    OperationThread threadOperation = new OperationThread(name, (Runnable)new cRunnable2((DisplayInfo)info, rowIndex, columnIndex), null);
                                    this.m_runthreadlist.put(name, threadOperation);
                                    threadOperation.startThread();
                                    break;
                                }
                            }
                            break block33;
                        }
                        case 8: {
                            if (info.isLogFileAvailable()) {
                                value = info.getLogFile();
                                break;
                            }
                            value = m_bundle.getString("JobsTableModel.Pending.txt");
                            String name = this.m_node.getName() + info.getName() + rowIndex + "_" + columnIndex;
                            if (!this.m_runthreadlist.containsKey(name)) {
                                OperationThread threadOperation = new OperationThread(name, (Runnable)new cRunnable3(info, rowIndex, columnIndex), null);
                                this.m_runthreadlist.put(name, threadOperation);
                                threadOperation.startThread();
                                break;
                            }
                            break block33;
                        }
                        case 9: {
                            value = info.getDeployedBy();
                            break;
                        }
                        case 10: {
                            value = info.getLocation();
                            break;
                        }
                        default: {
                            value = "UNDEFINED";
                        }
                    }
                    break block33;
                }
                if (this.m_infoList.get(rowIndex) instanceof ServerFlowInfo) {
                    ServerFlowInfo info = (ServerFlowInfo)this.m_infoList.get(rowIndex);
                    switch (JobColumnSelectorModel.getColumnKeyFromName((String)this.m_aColumns[columnIndex].getName())) {
                        case 0: {
                            value = info.getName();
                            break;
                        }
                        case 1: {
                            value = info.getId();
                            break;
                        }
                        case 2: {
                            value = info.getDateCreated();
                            break;
                        }
                        case 3: {
                            value = info.getDateModified();
                            break;
                        }
                        case 5: {
                            value = info.getApplicationName();
                            break;
                        }
                        case 10: {
                            value = info.getLocation();
                            break;
                        }
                        default: {
                            value = m_bundle.getString("JobsTableModel.NotApplicable.txt");
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.fireTableStructureChanged();
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public Icon getIcon(ServerJobInfo job) {
        return IconUtil.getIcon((String)JobInfo.getIconName((boolean)job.hasErrors()));
    }

    public Icon getIcon(ServerFlowInfo flow) {
        boolean errors = flow != null ? flow.hasErrors() : false;
        boolean scheduled = false;
        try {
            scheduled = flow != null ? flow.isFlowSubmitted() : false;
        }
        catch (RuntimeException ex) {
            scheduled = false;
        }
        return IconUtil.getIcon((String)FlowInfo.getIconName((boolean)scheduled, (boolean)errors));
    }

    public void pluginChange(PluginChangeEvent evt) {
        int i;
        int eventType = evt.getEventType();
        List childList = evt.getPairList();
        int size = childList.size();
        Object[] children = new Object[size];
        int[] childIndex = new int[size];
        for (i = 0; i < size; ++i) {
            IntObjPair ioPair = (IntObjPair)childList.get(i);
            childIndex[i] = ioPair.getIndex();
            AbstractNode node = (AbstractNode)ioPair.getChild();
            children[i] = node instanceof JobNode ? ((JobNode)node).getJobInfo() : ((FlowNode)node).getFlowInfo();
        }
        switch (eventType) {
            case 0: {
                block7: for (i = 0; i < children.length; ++i) {
                    DisplayInfo temp;
                    int index;
                    DisplayInfo info = (DisplayInfo)children[i];
                    int numObjects = this.m_initialList.size();
                    for (index = 0; index < numObjects; ++index) {
                        temp = (DisplayInfo)this.m_initialList.get(index);
                        if (temp != null && (info == null || info.getId().compareTo(temp.getId()) != 0)) continue;
                        this.m_initialList.remove(index);
                        break;
                    }
                    numObjects = this.m_infoList.size();
                    for (index = 0; index < numObjects; ++index) {
                        temp = (DisplayInfo)this.m_infoList.get(index);
                        if (info == null || info.getId().compareTo(temp.getId()) != 0) continue;
                        this.m_infoList.remove(index);
                        this.fireTableRowsDeleted(index, index);
                        continue block7;
                    }
                }
                this.fireTableDataChanged();
                break;
            }
            case 1: {
                Vector<Object> list = new Vector<Object>(children.length);
                for (int i2 = 0; i2 < children.length; ++i2) {
                    this.m_initialList.add(children[i2]);
                    list.add(children[i2]);
                }
                this._buildData(list, true);
                break;
            }
            case 2: {
                for (int i3 = 0; i3 < childIndex.length; ++i3) {
                    this.fireTableRowsUpdated(childIndex[i3], childIndex[i3]);
                }
                this.fireTableDataChanged();
                break;
            }
            case 3: {
                this.fireTableDataChanged();
                break;
            }
        }
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
    }

    public void moveDataToStore() {
    }

    public AbstractAction getDefaultContextMenuAction(ListSelectionModel selectionModel) {
        return null;
    }

    public Object getObjectAt(int index) {
        return this.m_infoList.get(index);
    }

    public int getRowCount() {
        return this.m_infoList.size();
    }

    public ElementInterface[] getSelectedObjects(ListSelectionModel selectionModel) {
        ArrayList selectedItemList = new ArrayList();
        for (int index = 0; index < this.m_infoList.size(); ++index) {
            Object item;
            if (!selectionModel.isSelectedIndex(index) || !((item = this.m_infoList.get(index)) instanceof ElementInterface)) continue;
            selectedItemList.add(item);
        }
        return selectedItemList.toArray(new ElementInterface[0]);
    }

    public Object[] getSelectedObjects(int[] selectionRows) {
        ArrayList selectedItemList = new ArrayList();
        for (int index = 0; index < selectionRows.length; ++index) {
            Object item = this.m_infoList.get(selectionRows[index]);
            selectedItemList.add(item);
        }
        return selectedItemList.toArray(new Object[0]);
    }

    public List getValueSet(String columnName) {
        List<BatchServerInfo> list = null;
        switch (JobColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            case 4: {
                list = this.m_schmgr.getBatchServers(-1, -1);
                break;
            }
            default: {
                list = null;
            }
        }
        return list;
    }

    public boolean hasValueSet(String columnName) {
        boolean rc = false;
        switch (JobColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            case 4: {
                rc = true;
                break;
            }
            default: {
                rc = false;
            }
        }
        return rc;
    }

    public String getToolTip(String columnName) {
        String tooltip = null;
        switch (JobColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            case 2: 
            case 3: {
                tooltip = "ddMMMyyyy:HH:mm:ss";
                break;
            }
        }
        return tooltip;
    }

    public String getFilterPropertyKeyPrefix(NodeInterface node) {
        String tag = node.getClass().getCanonicalName();
        int index = tag.lastIndexOf(46);
        if (index > 0) {
            tag = tag.substring(index + 1);
        }
        return tag;
    }

    private static class cRunnable2
    implements Runnable {
        DisplayInfo mc_info;

        cRunnable2(DisplayInfo info, int row, int column) {
            this.mc_info = info;
        }

        @Override
        public void run() {
            try {
                if (this.mc_info instanceof ServerJobInfo) {
                    ((ServerJobInfo)this.mc_info).generateAllInformation(false);
                } else if (this.mc_info instanceof ServerFlowInfo) {
                    ((ServerFlowInfo)this.mc_info).generateAllInformation(false);
                }
            }
            catch (SchedulerException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private class cRunnable3
    implements Runnable {
        ServerJobInfo mc_info;
        int mc_row;
        int mc_column;

        cRunnable3(ServerJobInfo info, int row, int column) {
            this.mc_info = info;
            this.mc_row = row;
            this.mc_column = column;
        }

        @Override
        public void run() {
            try {
                this.mc_info.generateAllInformation(false);
                if (JobsTableModel.this.m_node instanceof FlowNode) {
                    this.mc_info.genLogFile(((FlowNode)JobsTableModel.this.m_node).getFlowInfo(), (PromptCallbackInterface)JobsTableModel.this.m_schmgr);
                } else {
                    this.mc_info.genLogFile(((FlowNode)((Object)JobsTableModel.this.m_node.getParent())).getFlowInfo(), (PromptCallbackInterface)JobsTableModel.this.m_schmgr);
                }
                JobsTableModel.this.fireTableCellUpdated(this.mc_row, this.mc_column);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
    }
}

