/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;

public class JobRendererTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobRendererTableModel.class);
    private List<JobRendererInfo> m_alRenderers;
    public static final int ID_COL = 0;
    public static final int ACTIVE_COL = 1;
    public static final int TOTAL_COL = 2;
    public static final int UPTIME_COL = 3;
    public static final int TYPE_COL = 4;
    public static final int HEARD_COL = 5;
    protected static final int W_ID_COL = 140;
    protected static final int W_ACTIVE_COL = 140;
    protected static final int W_TOTAL_COL = 140;
    protected static final int W_UPTIME_COL = 140;
    protected static final int W_TYPE_COL = 140;
    protected static final int W_HEARD_COL = 140;
    protected static final int TOTAL_COLS = 6;
    protected static final int TOTAL_HIDDEN_COLS = 0;

    public JobRendererTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, m_bundle.getString("JobRendererTableModel.IdHeader.txt"), 140);
        this.m_aColumns[1] = new WsIntegerTableColumn(1, m_bundle.getString("JobRendererTableModel.ActiveHeader.txt"), 140);
        this.m_aColumns[2] = new WsIntegerTableColumn(2, m_bundle.getString("JobRendererTableModel.TotalHeader.txt"), 140);
        this.m_aColumns[3] = new WsStringTableColumn(3, m_bundle.getString("JobRendererTableModel.UptimeHeader.txt"), 140);
        this.m_aColumns[4] = new WsStringTableColumn(4, m_bundle.getString("JobRendererTableModel.TypeHeader.txt"), 140);
        this.m_aColumns[5] = new WsStringTableColumn(5, m_bundle.getString("JobRendererTableModel.HeardHeader.txt"), 140);
    }

    public int getColumnCount() {
        return 6;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }

    public void addRow(JobRendererInfo info) throws RemoteException {
        ArrayList<Object> newRow = new ArrayList<Object>();
        newRow.add(info.getApplicationIDsDataBinding().toString());
        newRow.add(info.getActiveJobCountDataBinding());
        newRow.add(info.getCumulativeJobCountDataBinding());
        String upTime = DurationFormatUtils.formatDuration((long)info.getUptimeDataBinding(), (String)"ddd-HH:mm:ss");
        newRow.add(upTime);
        newRow.add(info.getRendererNameDataBinding());
        String heartBeat = DurationFormatUtils.formatPeriod((long)info.getLastHeartBeatTimeDataBinding(), (long)System.currentTimeMillis(), (String)"ddd-HH:mm:ss");
        newRow.add(heartBeat);
        this.m_lData.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        ++this.m_nRowInstances;
    }

    public void deleteRow(int nRow) {
        List lRowData = this.getRowValues(nRow);
        this.m_lData.remove(lRowData);
        this.fireTableRowDeleted(nRow, lRowData);
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
        int oldRowCount = this.m_lData.size();
        this.m_lData.clear();
        if (oldRowCount > 0) {
            this.fireTableRowsDeleted(0, oldRowCount - 1);
        }
        int nRows = 0;
        Iterator<JobRendererInfo> it = this.m_alRenderers.iterator();
        while (it.hasNext()) {
            ArrayList<Object> newRow = new ArrayList<Object>();
            JobRendererInfo obj = it.next();
            if (!(obj instanceof JobRendererInfo)) continue;
            JobRendererInfo info = obj;
            newRow.add(info.getApplicationIDsDataBinding().toString());
            newRow.add(info.getActiveJobCountDataBinding());
            newRow.add(info.getCumulativeJobCountDataBinding());
            String upTime = DurationFormatUtils.formatDuration((long)info.getUptimeDataBinding(), (String)"ddd-HH:mm:ss");
            newRow.add(upTime);
            newRow.add(info.getRendererNameDataBinding());
            String heartBeat = DurationFormatUtils.formatPeriod((long)info.getLastHeartBeatTimeDataBinding(), (long)System.currentTimeMillis(), (String)"ddd-HH:mm:ss");
            newRow.add(heartBeat);
            this.m_lData.add(newRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() {
    }

    public List<?> getJobRenderers() {
        return this.m_alRenderers;
    }

    public void setJobRenderers(List<JobRendererInfo> list) {
        this.m_alRenderers = list;
    }
}

