/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.console.plugins.TableModelInterface;
import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.DeleteFlowAction;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.PropertyAction;
import com.sas.scheduler.schmgr.ReportFlowAction;
import com.sas.scheduler.schmgr.ScheduleFlowAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SetSchedulerAction;
import com.sas.scheduler.schmgr.UnScheduleFlowAction;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.schmgr.model.CompareDateString;
import com.sas.scheduler.schmgr.model.CompareNumericString;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.OperationThread;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsComparatorFactory;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;

public class FlowsTableModel
extends WsAbstractTableModel
implements TableModelInterface,
NeoTableModelInterface {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowsTableModel.class);
    private NodeInterface m_node;
    private ScheduleManager m_schmgr;
    private Vector<Object> m_initialList = null;
    private Vector<ServerFlowInfo> m_infoList = null;
    private FilterSelector m_filter = null;
    private FlowColumnSelectorModel m_columns = null;
    private HashMap<String, OperationThread> m_runthreadlist;

    public FlowsTableModel(NodeInterface node, List<?> itemsList, FlowColumnSelectorModel columns) {
        this(node, itemsList, null, columns);
    }

    public FlowsTableModel(NodeInterface node, List<?> itemsList, FilterSelector filter, FlowColumnSelectorModel columns) {
        this.m_node = node;
        this.m_schmgr = (ScheduleManager)node.getPlugin();
        this.m_initialList = new Vector(itemsList);
        this.m_filter = filter;
        this.m_columns = columns;
        this._buildData(this.m_initialList, false);
        int numOfCols = this.m_columns.getColumnCount();
        this.m_aColumns = new WsAbstractTableColumn[numOfCols];
        block5: for (int colH = 0; colH < numOfCols; ++colH) {
            String colName = this.m_columns.getColumnName(colH);
            switch (this.m_columns.getColumnType(colName)) {
                case 0: {
                    this.m_aColumns[colH] = new WsStringTableColumn(colH, colName, this.m_columns.getColumnWidth(colH));
                    if (FlowColumnSelectorModel.getColumnKeyFromName((String)colName) == 4) {
                        this.m_aColumns[colH].setComparator((Comparator)new CompareDateString(Locale.getDefault()));
                        continue block5;
                    }
                    if (FlowColumnSelectorModel.getColumnKeyFromName((String)colName) != 1) continue block5;
                    this.m_aColumns[colH].setComparator((Comparator)new CompareNumericString(Locale.getDefault()));
                    continue block5;
                }
                case 2: {
                    Date date = new Date();
                    this.m_aColumns[colH] = new WsDateTableColumn(colH, colName, this.m_columns.getColumnWidth(colH), date);
                    this.m_aColumns[colH].setComparator(WsComparatorFactory.createComparator(Date.class));
                    continue block5;
                }
                case 1: {
                    this.m_aColumns[colH] = new WsIntegerTableColumn(colH, colName, this.m_columns.getColumnWidth(colH));
                }
            }
        }
        this.m_runthreadlist = new HashMap();
    }

    public WsAbstractTableModel getModel() {
        return this;
    }

    public String getSettingPrefix() {
        String settingPrefix = "FILTERTABLEVIEW_FLOW_" + this.m_node.getName();
        return settingPrefix;
    }

    public List<?> getFilters() {
        if (this.m_filter != null) {
            return this.m_schmgr.getFlowFilters();
        }
        return null;
    }

    public boolean isHidden(int index) {
        return this.m_columns.isHidden(index);
    }

    public NodeInterface getNode() {
        return this.m_node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _buildData(List<Object> itemsList, boolean update) {
        int startRow;
        ArrayList<Object> neoItemList;
        block18: {
            block16: {
                block17: {
                    neoItemList = new ArrayList<Object>();
                    if (this.m_filter == null) break block16;
                    if (!this.m_filter.isSimpleNameFilter()) break block17;
                    FilterRule rule = this.m_filter.getRule(0);
                    int numRows = itemsList.size();
                    String value = rule.getValue();
                    switch (rule.getCondition()) {
                        case 0: {
                            ServerFlowInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (ServerFlowInfo)itemsList.get(i);
                                if (!info.getName().matches(value)) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 3: {
                            ServerFlowInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (ServerFlowInfo)itemsList.get(i);
                                if (info.getName().indexOf(value) < 0) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 1: {
                            ServerFlowInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (ServerFlowInfo)itemsList.get(i);
                                if (!info.getName().startsWith(value)) continue;
                                neoItemList.add(info);
                            }
                            break block18;
                        }
                        case 2: {
                            ServerFlowInfo info;
                            int i;
                            for (i = 0; i < numRows; ++i) {
                                info = (ServerFlowInfo)itemsList.get(i);
                                if (!info.getName().endsWith(value)) continue;
                                neoItemList.add(info);
                            }
                            break;
                        }
                    }
                    break block18;
                }
                ScheduleManager.setStatusText("");
                neoItemList.addAll(this.m_schmgr.getFlows(this.m_filter, itemsList));
                break block18;
            }
            neoItemList.addAll(itemsList);
        }
        int numRows = neoItemList.size();
        int n = startRow = this.m_infoList != null ? this.m_infoList.size() : 0;
        if (!update) {
            this.m_infoList = new Vector(numRows);
            startRow = 0;
        }
        for (int i = 0; i < numRows; ++i) {
            ServerFlowInfo info = (ServerFlowInfo)neoItemList.get(i);
            this.m_infoList.addElement(info);
        }
        if (update && numRows > 0) {
            this.fireTableRowsInserted(startRow, startRow + numRows - 1);
            this.fireTableDataChanged();
        }
        FlowsTableModel flowsTableModel = this;
        synchronized (flowsTableModel) {
            this.m_runthreadlist = new HashMap();
        }
    }

    public void refresh(List<Object> itemsList) {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this._buildData(itemsList, false);
        if (this.getRowCount() > 0) {
            this.fireTableRowsInserted(0, this.getRowCount() - 1);
        }
    }

    public void refresh(FilterSelector filter) {
        this.m_filter = filter;
        this.refresh(this.m_initialList);
    }

    public void refreshRowData(int row) {
        ArrayList<Object> sysrow = new ArrayList<Object>();
        for (int j = 0; j < this.m_aColumns.length; ++j) {
            sysrow.add(this.getValueAt(row, j));
        }
        this.m_lData.set(row, sysrow);
    }

    public int getColumnType(String columnName) {
        return this.m_columns.getColumnType(columnName);
    }

    public int getColumnCount() {
        return this.m_columns.getColumnCount();
    }

    private int getVisibleColumnCount() {
        int numColumns = this.m_aColumns.length;
        int numHidden = this.m_aHiddenColumns != null ? this.m_aHiddenColumns.length : 0;
        return numColumns - numHidden;
    }

    public List<AbstractAction> getContextMenuActions(ListSelectionModel selectionModel) {
        int[] selectedRows = null;
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        int nCols = this.getVisibleColumnCount();
        int iMinRow = iMin / nCols;
        int iMaxRow = iMax / nCols;
        int iStart = iMinRow * nCols;
        int iStartNext = iStart + nCols;
        int[] aSelectedRows = new int[1 + (iMaxRow - iMinRow)];
        int nSelectedRows = 0;
        for (int iRow = iMinRow; iRow <= iMaxRow; ++iRow) {
            for (int i = iStart; i < iStartNext; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                aSelectedRows[nSelectedRows++] = iRow;
                break;
            }
            iStart = iStartNext;
            iStartNext += nCols;
        }
        selectedRows = new int[nSelectedRows];
        System.arraycopy(aSelectedRows, 0, selectedRows, 0, nSelectedRows);
        return this.getContextMenuActions(selectedRows);
    }

    public List<AbstractAction> getContextMenuActions(int[] selectionRows) {
        ArrayList<AbstractAction> contextMenuActionsList = new ArrayList<AbstractAction>();
        Object[] selectionList = this.getSelectedObjects(selectionRows);
        if (selectionList.length == 1) {
            ServerFlowInfo flow = (ServerFlowInfo)selectionList[0];
            AbstractNode node = this.m_schmgr.getNodeFromInfo(flow, this.m_node);
            if (node instanceof FlowNode) {
                ScheduleFlowAction sfa = new ScheduleFlowAction(flow, this.m_schmgr, (FlowNode)node);
                UnScheduleFlowAction usfa = new UnScheduleFlowAction(flow, this.m_schmgr, (FlowNode)node);
                contextMenuActionsList.addAll(FlowNode.buildContextMenuActions(flow, this.m_schmgr, (FlowNode)node, sfa, usfa));
                FlowNode.SetScheduleAction(flow, sfa);
                FlowNode.SetUnScheduleAction(flow, usfa);
            }
            PropertyAction propertiesAction = new PropertyAction((ServerInfoInterface)flow, this.m_schmgr);
            contextMenuActionsList.add(propertiesAction);
        } else if (selectionList.length > 1) {
            contextMenuActionsList.add(new ReportFlowAction(selectionList, this.m_schmgr));
            contextMenuActionsList.add(new ScheduleFlowAction(selectionList, this.m_schmgr));
            contextMenuActionsList.add(new SetSchedulerAction(selectionList, this.m_schmgr));
            contextMenuActionsList.add(new DeleteFlowAction(selectionList, this.m_schmgr));
        } else if (selectionList.length < 1) {
            contextMenuActionsList.addAll(this.m_node.getContextMenuActions());
        }
        return contextMenuActionsList;
    }

    public List<AbstractAction> getToolBarActions(int[] selectionRows) {
        return this.getContextMenuActions(selectionRows);
    }

    public List<AbstractAction> getToolBarActions(ListSelectionModel selectionModel) {
        return this.getContextMenuActions(selectionModel);
    }

    public String getColumnName(int columnIndex) {
        return this.m_aColumns[columnIndex].getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        Object value = "";
        ServerFlowInfo info = null;
        try {
            info = this.m_infoList.get(rowIndex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fireTableStructureChanged();
            return value;
        }
        switch (FlowColumnSelectorModel.getColumnKeyFromName((String)this.m_aColumns[columnIndex].getName())) {
            case 0: {
                value = info.getName();
                break;
            }
            case 1: {
                value = new Integer(info.getJobCount());
                break;
            }
            case 2: {
                value = info.getDateCreated();
                break;
            }
            case 3: {
                value = info.getDateModified();
                break;
            }
            case 4: {
                boolean nopFlag = false;
                try {
                    nopFlag = info.getInfo().getScheduler().getClassId().compareTo("c8b4baf0-5f9f-471e-ba76-1201e1e81aef") == 0;
                }
                catch (Exception e) {
                    nopFlag = true;
                }
                if (nopFlag) {
                    value = "";
                    break;
                }
                if (info.isDataGathered()) {
                    UserOptions userOptions = new UserOptions();
                    userOptions.setManager(this.m_schmgr);
                    String timezone = userOptions.getTimezoneOrientation();
                    String stdout = userOptions.getDefaultStandardOutfile();
                    String stderr = userOptions.getDefaultStandardErrfile();
                    String flowDefDir = userOptions.getFlowDefinitionDirectory();
                    int maxHistory = userOptions.getMaxFlowHistory();
                    int maxHistoryPerFlow = userOptions.getMaxHistoryForFlow();
                    value = info.getLastExecutedDateTime(Locale.getDefault(), timezone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow);
                    break;
                }
                FlowsTableModel flowsTableModel = this;
                synchronized (flowsTableModel) {
                    value = m_bundle.getString("FlowsTableModel.Pending.txt");
                    String name = info.getName() + rowIndex + "_" + columnIndex;
                    if (!this.m_runthreadlist.containsKey(name)) {
                        OperationThread threadOperation = new OperationThread(name, (Runnable)new cRunnableGenerateInfo(info, rowIndex, columnIndex), (Runnable)new cRunnableComplete());
                        this.m_runthreadlist.put(name, threadOperation);
                        threadOperation.startThread();
                    }
                    break;
                }
            }
            case 5: {
                value = info.getId();
                break;
            }
            case 6: {
                value = info.getServerName();
                break;
            }
            case 7: {
                value = info.getApplicationName();
                break;
            }
            case 8: {
                value = info.getUsername();
                break;
            }
            case 9: {
                value = info.getLocation();
                break;
            }
            default: {
                value = "UNDEFINED";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public Icon getIcon(ServerFlowInfo flow) {
        boolean errors = flow != null ? flow.hasErrors() : false;
        boolean scheduled = false;
        try {
            scheduled = flow != null ? flow.isFlowSubmitted() : false;
        }
        catch (RuntimeException ex) {
            scheduled = false;
        }
        return IconUtil.getIcon((String)FlowInfo.getIconName((boolean)scheduled, (boolean)errors));
    }

    public boolean cleanup() {
        this.refresh(new ArrayList<Object>());
        return true;
    }

    public void pluginChange(PluginChangeEvent evt) {
        int i;
        int eventType = evt.getEventType();
        List childList = evt.getPairList();
        int size = childList.size();
        Object[] children = new Object[size];
        int[] childIndex = new int[size];
        for (i = 0; i < size; ++i) {
            IntObjPair ioPair = (IntObjPair)childList.get(i);
            childIndex[i] = ioPair.getIndex();
            children[i] = ((FlowNode)((Object)ioPair.getChild())).getFlowInfo();
        }
        switch (eventType) {
            case 0: {
                block7: for (i = 0; i < children.length; ++i) {
                    DisplayInfo temp;
                    int index;
                    DisplayInfo info = (DisplayInfo)children[i];
                    int numObjects = this.m_initialList.size();
                    for (index = 0; index < numObjects; ++index) {
                        temp = (DisplayInfo)this.m_initialList.get(index);
                        if (info == null || info.getId().compareTo(temp.getId()) != 0) continue;
                        this.m_initialList.remove(index);
                        break;
                    }
                    numObjects = this.m_infoList.size();
                    for (index = 0; index < numObjects; ++index) {
                        temp = (DisplayInfo)this.m_infoList.get(index);
                        if (info == null || info.getId().compareTo(temp.getId()) != 0) continue;
                        this.m_infoList.remove(index);
                        this.fireTableRowsDeleted(index, index);
                        continue block7;
                    }
                }
                this.fireTableDataChanged();
                break;
            }
            case 1: {
                Vector<Object> list = new Vector<Object>(children.length);
                for (int i2 = 0; i2 < children.length; ++i2) {
                    this.m_initialList.add(children[i2]);
                    list.add(children[i2]);
                }
                this._buildData(list, true);
                break;
            }
            case 2: {
                for (int i3 = 0; i3 < childIndex.length; ++i3) {
                    this.fireTableRowsUpdated(childIndex[i3], childIndex[i3]);
                }
                this.fireTableDataChanged();
                break;
            }
            case 3: {
                this.fireTableDataChanged();
                break;
            }
        }
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
    }

    public void moveDataToStore() {
    }

    public AbstractAction getDefaultContextMenuAction(ListSelectionModel selectionModel) {
        return null;
    }

    public Object getObjectAt(int index) {
        return this.m_infoList.get(index);
    }

    public int getRowCount() {
        return this.m_infoList.size();
    }

    public ElementInterface[] getSelectedObjects(ListSelectionModel selectionModel) {
        ArrayList<ServerFlowInfo> selectedItemList = new ArrayList<ServerFlowInfo>();
        for (int index = 0; index < this.m_infoList.size(); ++index) {
            ServerFlowInfo item;
            if (!selectionModel.isSelectedIndex(index) || !((item = this.m_infoList.get(index)) instanceof ElementInterface)) continue;
            selectedItemList.add(item);
        }
        return selectedItemList.toArray(new ElementInterface[0]);
    }

    public Object[] getSelectedObjects(int[] selectionRows) {
        ArrayList<ServerFlowInfo> selectedItemList = new ArrayList<ServerFlowInfo>();
        for (int index = 0; index < selectionRows.length; ++index) {
            ServerFlowInfo item = this.m_infoList.get(selectionRows[index]);
            selectedItemList.add(item);
        }
        return selectedItemList.toArray(new Object[0]);
    }

    public List<?> getValueSet(String columnName) {
        List<SchedulerServerInfo> list = null;
        switch (FlowColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            default: {
                list = null;
                break;
            }
            case 6: {
                list = this.m_schmgr.getSchedulerServers(100);
            }
        }
        return list;
    }

    public boolean hasValueSet(String columnName) {
        boolean rc = false;
        switch (FlowColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            default: {
                rc = false;
                break;
            }
            case 6: {
                rc = true;
            }
        }
        return rc;
    }

    public String getToolTip(String columnName) {
        String tooltip = null;
        switch (FlowColumnSelectorModel.getColumnKeyFromName((String)columnName)) {
            case 2: 
            case 3: {
                tooltip = "ddMMMyyyy:HH:mm:ss";
                break;
            }
        }
        return tooltip;
    }

    public String getFilterPropertyKeyPrefix(NodeInterface node) {
        String tag = node.getClass().getCanonicalName();
        int index = tag.lastIndexOf(46);
        if (index > 0) {
            tag = tag.substring(index + 1);
        }
        return tag;
    }

    private class cRunnableGenerateInfo
    implements Runnable {
        ServerFlowInfo mc_info;
        int mc_row;
        int mc_column;

        cRunnableGenerateInfo(ServerFlowInfo info, int row, int column) {
            this.mc_info = info;
            this.mc_row = row;
            this.mc_column = column;
        }

        @Override
        public void run() {
            try {
                this.mc_info.generateAllInformation(false);
                FlowsTableModel.this.fireTableCellUpdated(this.mc_row, this.mc_column);
            }
            catch (SchedulerException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private class cRunnableComplete
    implements Runnable {
        cRunnableComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            cRunnableComplete cRunnableComplete2 = this;
            synchronized (cRunnableComplete2) {
            }
        }
    }
}

