/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectoriesTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DirectoriesTableModel.class);
    private ScheduleManager m_schmgr;
    private List<?> m_alDirectories;
    public static final int NAME_COL = 0;
    public static final int DIRECTORY_COL = 1;
    public static final int METADATA_COL = 2;
    protected static final int W_NAME_COL = 140;
    protected static final int W_DIRECTORY_COL = 140;
    protected static final int TOTAL_COLS = 2;
    protected static final int TOTAL_HIDDEN_COLS = 1;

    public DirectoriesTableModel(ScheduleManager plugin) {
        this.m_schmgr = plugin;
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, m_bundle.getString("DirectoriesTableModel.NameHeader.txt"), 140);
        this.m_aColumns[1] = new WsStringTableColumn(1, m_bundle.getString("DirectoriesTableModel.DirectoryHeader.txt"), 140);
        this.m_aColumns[2] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }

    public void addRow(DirectoryInfo oDirectory) throws RemoteException {
        ArrayList<String> newRow = new ArrayList<String>();
        newRow.add(oDirectory.getName());
        newRow.add(oDirectory.getPath());
        newRow.add((String)oDirectory);
        this.m_lData.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        ++this.m_nRowInstances;
    }

    public void deleteRow(int nRow) {
        List lRowData = this.getRowValues(nRow);
        this.m_lData.remove(lRowData);
        this.fireTableRowDeleted(nRow, lRowData);
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
        int oldRowCount = this.m_lData.size();
        this.m_lData.clear();
        if (oldRowCount > 0) {
            this.fireTableRowsDeleted(0, oldRowCount - 1);
        }
        int nRows = 0;
        Iterator<?> it = this.m_alDirectories.iterator();
        while (it.hasNext()) {
            ArrayList<String> newRow = new ArrayList<String>();
            Object obj = it.next();
            if (!(obj instanceof DirectoryInfo)) continue;
            DirectoryInfo oDirectory = (DirectoryInfo)obj;
            newRow.add(oDirectory.getName());
            newRow.add(oDirectory.getPath());
            newRow.add((String)oDirectory);
            this.m_lData.add(newRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() {
    }

    public List<?> getDirectories() {
        return this.m_alDirectories;
    }

    public void setDirectories(List<?> alDirectories) {
        this.m_alDirectories = alDirectories;
    }
}

