/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import java.io.Serializable;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class CompareDateString
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    Locale m_locale;

    public CompareDateString() {
        this.m_locale = Locale.getDefault();
    }

    public CompareDateString(Locale locale) {
        this.m_locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public int compare(Object a, Object b) {
        if (a instanceof Date || b instanceof Date) {
            return this.compareDate((Date)a, (Date)b);
        }
        return this.compare((String)a, (String)b);
    }

    @Override
    public int compare(String dateA, String dateB) {
        DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, this.m_locale);
        Date a = null;
        Date b = null;
        boolean Astring = false;
        boolean Bstring = false;
        try {
            if (dateA.startsWith("<")) {
                Astring = true;
            } else {
                a = dateTime.parse(dateA);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            if (dateB.startsWith("<")) {
                Bstring = true;
            } else {
                b = dateTime.parse(dateB);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (Astring && Bstring) {
            Collator collator = Collator.getInstance(this.m_locale);
            return collator.compare(dateA, dateB);
        }
        if (Astring && b != null) {
            return -1;
        }
        if (Astring && b == null) {
            return 1;
        }
        if (a != null && Bstring) {
            return 1;
        }
        if (a == null && Bstring) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        return 0;
    }

    public int compareDate(Date a, Date b) {
        DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, this.m_locale);
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        return 0;
    }
}

