/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.filter.model.FilterUtil;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.workspace.WorkspaceFile;
import java.util.ArrayList;
import java.util.List;

public class UserOptions
extends WorkspaceFile {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(UserOptions.class);
    private static final String AutoReschedule = "UserSetting_AutoReschedule";
    private static final String LogfilePrefixed = "UserSetting_LogfilePrefixed";
    private static final String Outputfile = "UserSetting_Outputfile";
    private static final String ImportActive = "UserSetting_ImportActivated";
    private static final String ShowWarnings = "UserSetting_ShowWarnings";
    private static final String ConsoleActive = "UserSetting_ConsoleActivated";
    private static final String ErrorDeleteFromScheduler = "UserSetting_ErrorDeleteFromScheduler";
    private static final String ShowFlowWarnings = "UserSetting_ShowFlowWarnings";
    private static final String OutputDir = "UserSetting_FlowOutputDirectory";
    private static final String CheckFilename = "UserSetting_CheckFilenameForInvalidCharacters";
    private static final String InvalidFilenameOnlyWarn = "UserSetting_CheckFilenameOnlyWarnOnInvalid";
    private static final String TimezoneOrientation = "AppServerResourceTimezoneForInputTime";
    private static final String Tzclient = "client";
    private static final String Tzserver = "server";
    private static final String AppServerResource = "UserSetting_AppServerResource";
    private static final String PortableTimeEvent = "UserSetting_PortableTimeEvent";
    private static final String FlowScoping = "UserSetting_FlowScoping";
    private static final String StatusCheckCycle = "UserSetting_SASJFS_StatusCheckCycle";
    private static final String StatusCheckTimeout = "UserSetting_SASJFS_StatusCheckTimeout";
    private static final String MaxHistoryFlows = "UserSetting_OSScheduler_MaxHistory";
    private static final String MaxHistoryForFlow = "UserSetting_OSScheduler_MaxHistoryForFlow";
    private static final String MaxPredecessorsPerJob = "UserSetting_MaxPredecessorsPerJob";
    private static final String DefaultStandardOutfile = "UserSetting_DefaultStandardOutfile";
    private static final String DefaultStandardErrfile = "UserSetting_DefaultStandardErrfile";
    private static final String LastSchedulingServer = "UserSetting_LastSchedulingServer";
    private static final String LastBatchServer = "UserSetting_LastBatchServer";
    private static final String LastDeploymentDirectory = "UserSetting_LastDeploymentDirectory";
    private static final String LastSourceDirectory = "UserSetting_LastSourceDirectory";
    private static final String LastFlowFolderLocation = "UserSetting_LastFlowFolderLocation";
    private static final String LastFolderLocation = "UserSetting_LastFolderLocation";
    private static final String ValidateCmdLineActive = "UserSetting_ValidateCmdlineActivated";
    private static final String DefaultFlowFilterRule = "UserSetting_DefaultFlowFilter";
    private static final String DefaultJobFilterRule = "UserSetting_DefaultJobFilter";
    private static final String ALLRULE = m_bundle.getString("UserOptions.Filter.All.txt");
    private static final String NONERULE = m_bundle.getString("UserOptions.Filter.None.txt");
    private static final String m_anyFlowName = ALLRULE;
    private static final String m_noFlowsName = NONERULE;
    private static final String m_anyJobName = ALLRULE;
    private static final String m_noJobsName = NONERULE;
    public static final String FlowFilters = "RootNode";
    public static final String JobFilters = "FlowNode";
    private ScheduleManager m_mgr = null;

    public UserOptions() {
        String product = m_bundle.getString("AboutScheduler.ConfigDir.txt");
        String version = m_bundle.getString("AboutScheduler.Version.txt");
        int i = version.indexOf(95);
        if (i > 0) {
            version = version.substring(0, i);
        }
        String myfile = "app.schmgr";
        String filePath = FilterUtil.getFilePath((String)product, (String)version, (String)myfile);
        this.openExisting(filePath);
    }

    public void setManager(ScheduleManager mgr) {
        this.m_mgr = mgr;
    }

    public boolean isAutoRescheduleFlow() {
        String ImportActivated = this.getPropertyString(AutoReschedule, "False");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setAutoRescheduleFlow(boolean value) {
        if (value) {
            this.setPropertyString(AutoReschedule, "True");
        } else {
            this.setPropertyString(AutoReschedule, "False");
        }
    }

    public boolean isLogfilePrefixedWithFlowname() {
        String ImportActivated = this.getPropertyString(LogfilePrefixed, "True");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setLogfilePrefixedWithFlowname(boolean value) {
        if (value) {
            this.setPropertyString(LogfilePrefixed, "True");
        } else {
            this.setPropertyString(LogfilePrefixed, "False");
        }
    }

    public boolean isOutputfile() {
        String ImportActivated = this.getPropertyString(Outputfile, "False");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setOutputfile(boolean value) {
        if (value) {
            this.setPropertyString(Outputfile, "True");
        } else {
            this.setPropertyString(Outputfile, "False");
        }
    }

    public boolean isImportActivated() {
        String ImportActivated = this.getPropertyString(ImportActive, "False");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setImportActivated(boolean value) {
        if (value) {
            this.setPropertyString(ImportActive, "True");
        } else {
            this.setPropertyString(ImportActive, "False");
        }
    }

    public boolean isValidateCmdlineActivated() {
        String ValidateActivated = this.getPropertyString(ValidateCmdLineActive, "False");
        return ValidateActivated.compareToIgnoreCase("True") == 0;
    }

    public void setValidateCmdlineActivated(boolean value) {
        if (value) {
            this.setPropertyString(ValidateCmdLineActive, "True");
        } else {
            this.setPropertyString(ValidateCmdLineActive, "False");
        }
    }

    public boolean isConsoleActivated() {
        String ConsoleActivated = this.getPropertyString(ConsoleActive, "False");
        return ConsoleActivated.compareToIgnoreCase("True") == 0;
    }

    public void setConsoleActivated(boolean value) {
        if (value) {
            this.setPropertyString(ConsoleActive, "True");
        } else {
            this.setPropertyString(ConsoleActive, "False");
        }
    }

    public boolean showWarnings() {
        String ImportActivated = this.getPropertyString(ShowWarnings, "True");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setShowWarnings(boolean value) {
        if (value) {
            this.setPropertyString(ShowWarnings, "True");
        } else {
            this.setPropertyString(ShowWarnings, "False");
        }
    }

    public boolean errorOnDeletionFromScheduler() {
        String ImportActivated = this.getPropertyString(ErrorDeleteFromScheduler, "False");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setErrorOnDeletionFromScheduler(boolean value) {
        if (value) {
            this.setPropertyString(ErrorDeleteFromScheduler, "True");
        } else {
            this.setPropertyString(ErrorDeleteFromScheduler, "False");
        }
    }

    public boolean showFlowWarnings() {
        String ImportActivated = this.getPropertyString(ShowFlowWarnings, "True");
        return ImportActivated.compareToIgnoreCase("True") == 0;
    }

    public void setShowFlowWarnings(boolean value) {
        if (value) {
            this.setPropertyString(ShowFlowWarnings, "True");
        } else {
            this.setPropertyString(ShowFlowWarnings, "False");
        }
    }

    public int getMaximumPredecessorsPerJob() {
        return this.getPropertyInt(MaxPredecessorsPerJob, 50);
    }

    public void setMaximumPredecessorsPerJob(int num) {
        this.setPropertyInt(MaxPredecessorsPerJob, num);
    }

    public String getFlowDefinitionDirectory() {
        String outdir = this.getPropertyString(OutputDir, "");
        return outdir;
    }

    public void setFlowDefinitionDirectory(String outdir) {
        this.setPropertyString(OutputDir, outdir != null ? outdir : "");
    }

    public boolean sourceFilenameCheckCharacters() {
        String flag = this.getPropertyString(CheckFilename, "True");
        return flag.compareToIgnoreCase("True") == 0;
    }

    public void setSourceFilenameCheckCharacters(boolean value) {
        if (value) {
            this.setPropertyString(CheckFilename, "True");
        } else {
            this.setPropertyString(CheckFilename, "False");
        }
    }

    public boolean sourceFilenameCheckWarning() {
        String flag = this.getPropertyString(InvalidFilenameOnlyWarn, "True");
        return flag.compareToIgnoreCase("True") == 0;
    }

    public void setSourceFilenameCheckWarning(boolean value) {
        if (value) {
            this.setPropertyString(InvalidFilenameOnlyWarn, "True");
        } else {
            this.setPropertyString(InvalidFilenameOnlyWarn, "False");
        }
    }

    public void setTimezoneOrientationToClient(boolean client) {
        if (client) {
            this.setPropertyString(TimezoneOrientation, Tzclient);
        } else {
            this.setPropertyString(TimezoneOrientation, Tzserver);
        }
    }

    public boolean isTimezoneOrientationToClient() {
        String value = this.getPropertyString(TimezoneOrientation, Tzclient);
        return value.compareToIgnoreCase(Tzclient) == 0;
    }

    public String getTimezoneOrientation() {
        String value = this.getPropertyString(TimezoneOrientation, Tzclient);
        if (value.compareToIgnoreCase(Tzclient) == 0) {
            return Tzclient;
        }
        return Tzserver;
    }

    public boolean isAppServerResource() {
        boolean flag = this.getPropertyBoolean(AppServerResource, this.m_mgr != null ? this.m_mgr.isAppServerResource() : false);
        return flag;
    }

    public void setAppServerResource(boolean flag) {
        this.setPropertyBoolean(AppServerResource, flag);
        if (this.m_mgr != null) {
            this.m_mgr.setAppServerResource(flag);
        }
    }

    public boolean usePortableTimeEvent() {
        boolean flag = this.getPropertyBoolean(PortableTimeEvent, false);
        return flag;
    }

    public void setPortableTimeEvent(boolean flag) {
        this.setPropertyBoolean(PortableTimeEvent, flag);
    }

    public boolean useFlowScoping() {
        boolean flag = this.getPropertyBoolean(FlowScoping, false);
        return flag;
    }

    public void setFlowScoping(boolean flag) {
        this.setPropertyBoolean(FlowScoping, flag);
    }

    public int getStatusCheckTimeout() {
        return this.getPropertyInt(StatusCheckTimeout, 0);
    }

    public void setStatusCheckTimeout(int num) {
        this.setPropertyInt(StatusCheckTimeout, num);
    }

    public int getStatusCheckCycle() {
        return this.getPropertyInt(StatusCheckCycle, 10);
    }

    public void setStatusCheckCycle(int num) {
        this.setPropertyInt(StatusCheckCycle, num);
    }

    public int getMaxFlowHistory() {
        return this.getPropertyInt(MaxHistoryFlows, 9999);
    }

    public void setMaxFlowHistory(int num) {
        this.setPropertyInt(MaxHistoryFlows, num);
    }

    public int getMaxHistoryForFlow() {
        return this.getPropertyInt(MaxHistoryForFlow, 25);
    }

    public void setMaxHistoryForFlow(int num) {
        this.setPropertyInt(MaxHistoryForFlow, num);
    }

    public String getDefaultStandardOutfile() {
        String filename = this.getPropertyString(DefaultStandardOutfile, "");
        if (filename != null && filename.length() > 0) {
            return filename;
        }
        return null;
    }

    public void setDefaultStandardOutfile(String filename) {
        this.setPropertyString(DefaultStandardOutfile, filename);
    }

    public String getDefaultStandardErrfile() {
        String filename = this.getPropertyString(DefaultStandardErrfile, "");
        if (filename != null && filename.length() > 0) {
            return filename;
        }
        return null;
    }

    public void setDefaultStandardErrfile(String filename) {
        this.setPropertyString(DefaultStandardErrfile, filename);
    }

    public String getLastSchedulingServer() {
        String schedulingserver = this.getPropertyString(LastSchedulingServer, "");
        if (schedulingserver != null && schedulingserver.length() > 0) {
            return schedulingserver;
        }
        return null;
    }

    public void setLastSchedulingServer(String schedulingserver) {
        this.setPropertyString(LastSchedulingServer, schedulingserver);
    }

    public String getLastBatchServer() {
        String batchserver = this.getPropertyString(LastBatchServer, "");
        if (batchserver != null && batchserver.length() > 0) {
            return batchserver;
        }
        return null;
    }

    public void setLastBatchServer(String batchserver) {
        this.setPropertyString(LastBatchServer, batchserver);
    }

    public String getLastDeploymentDirectory() {
        String directory = this.getPropertyString(LastDeploymentDirectory, "");
        if (directory != null && directory.length() > 0) {
            return directory;
        }
        return null;
    }

    public void setLastDeploymentDirectory(String directory) {
        this.setPropertyString(LastDeploymentDirectory, directory);
    }

    public String getLastSourceDirectory() {
        String directory = this.getPropertyString(LastSourceDirectory, "");
        if (directory != null && directory.length() > 0) {
            return directory;
        }
        return null;
    }

    public void setLastSourceDirectory(String directory) {
        this.setPropertyString(LastSourceDirectory, directory);
    }

    public String getLastFlowFolderLocation() {
        String folder = this.getPropertyString(LastFlowFolderLocation, ScheduleManager.getDefaultFolder());
        if (folder != null && folder.length() > 0) {
            return folder;
        }
        return null;
    }

    public void setLastFlowFolderLocation(String folder) {
        this.setPropertyString(LastFlowFolderLocation, folder);
    }

    public String getLastFolderLocation() {
        String folder = this.getPropertyString(LastFolderLocation, "");
        if (folder != null && folder.length() > 0) {
            return folder;
        }
        return null;
    }

    public void setLastFolderLocation(String folder) {
        this.setPropertyString(LastFolderLocation, folder);
    }

    public FilterSelector getDefaultFlowsRule() {
        String value = this.getPropertyString(DefaultFlowFilterRule, NONERULE);
        if (value.compareToIgnoreCase(NONERULE) == 0) {
            return UserOptions.getNoFlowsRule();
        }
        return UserOptions.getAllFlowsRule();
    }

    public boolean isDefaultFlowsAll() {
        String value = this.getPropertyString(DefaultFlowFilterRule, NONERULE);
        return value.compareToIgnoreCase(ALLRULE) == 0;
    }

    public void setDefaultFlowsRule(boolean all) {
        if (all) {
            this.setPropertyString(DefaultFlowFilterRule, ALLRULE);
        } else {
            this.setPropertyString(DefaultFlowFilterRule, NONERULE);
        }
    }

    public FilterSelector getDefaultJobsRule() {
        String value = this.getPropertyString(DefaultJobFilterRule, ALLRULE);
        if (value.compareToIgnoreCase(ALLRULE) == 0) {
            return UserOptions.getAllJobsRule();
        }
        return UserOptions.getNoJobsRule();
    }

    public boolean isDefaultJobsAll() {
        String value = this.getPropertyString(DefaultJobFilterRule, ALLRULE);
        return value.compareToIgnoreCase(ALLRULE) == 0;
    }

    public void setDefaultJobsRule(boolean all) {
        if (all) {
            this.setPropertyString(DefaultJobFilterRule, ALLRULE);
        } else {
            this.setPropertyString(DefaultJobFilterRule, NONERULE);
        }
    }

    public List<FilterSelector> getFlowFilters() {
        return this.getFilters(FlowFilters);
    }

    public FilterSelector getFlowFilter(String filterName) {
        if (filterName.compareTo(m_anyFlowName) == 0) {
            return UserOptions.getAllFlowsRule();
        }
        if (filterName.compareTo(m_noFlowsName) == 0) {
            return UserOptions.getNoFlowsRule();
        }
        return this.getFilter(FlowFilters, filterName);
    }

    public List<FilterSelector> getJobFilters() {
        return this.getFilters(JobFilters);
    }

    public FilterSelector getJobFilter(String filterName) {
        if (filterName.compareTo(m_anyJobName) == 0) {
            return UserOptions.getAllJobsRule();
        }
        if (filterName.compareTo(m_noJobsName) == 0) {
            return UserOptions.getNoJobsRule();
        }
        return this.getFilter(JobFilters, filterName);
    }

    private FilterSelector getFilter(String propName, String filterName) {
        String content = this.getPropertyString(this.buildKey(propName, filterName), "");
        FilterSelector filter = new FilterSelector(filterName);
        filter.initFromDefinition(content, true);
        return filter;
    }

    private List<FilterSelector> getFilters(String propName) {
        ArrayList<FilterSelector> filters = new ArrayList<FilterSelector>(2);
        FilterSelector filterAll = UserOptions.getAllFlowsRule();
        filters.add(filterAll);
        FilterSelector filterNone = UserOptions.getNoFlowsRule();
        filters.add(filterNone);
        String filterNames = this.getPropertyString(propName, "");
        int start = 0;
        while (start != -1) {
            int index = filterNames.indexOf(58, start);
            String name = "";
            if (index == -1) {
                name = filterNames.substring(start);
                start = -1;
            } else {
                name = filterNames.substring(start, index);
                start = index + 1;
            }
            if (name.length() <= 0) continue;
            String content = this.getPropertyString(this.buildKey(propName, name), "");
            FilterSelector filter = new FilterSelector(name);
            filter.initFromDefinition(content, true);
            filters.add(filter);
        }
        return filters;
    }

    private String buildKey(String prefix, String name) {
        return prefix + "_" + name;
    }

    private String parsePropName(String prefix, String key) {
        return key.substring(prefix.length() + 1);
    }

    public boolean updateFilter(FilterSelector filter, String propName) {
        if (propName.compareTo(FlowFilters) != 0 && propName.compareTo(JobFilters) != 0) {
            return false;
        }
        String newcontent = filter.generateDefinition();
        String filterName = filter.toString();
        String filterKey = this.buildKey(propName, filterName);
        String oldcontent = this.getPropertyString(filterKey, "");
        if (oldcontent.compareTo(newcontent) != 0) {
            if (filterName.compareTo(ALLRULE) == 0 || filterName.compareTo(NONERULE) == 0) {
                return false;
            }
            this.setPropertyString(filterKey, newcontent);
            this.saveExisting();
        }
        return true;
    }

    public boolean writeFilter(FilterSelector filter, String propName) {
        if (propName.compareTo(FlowFilters) != 0 && propName.compareTo(JobFilters) != 0) {
            return false;
        }
        if (propName.compareTo(ALLRULE) == 0 || propName.compareTo(NONERULE) == 0) {
            return false;
        }
        String content = filter.generateDefinition();
        String filterName = filter.toString();
        String filterKey = this.buildKey(propName, filterName);
        this.setPropertyString(filterKey, content);
        String mainProp = this.getPropertyString(propName, "");
        if (mainProp.length() > 0) {
            if (mainProp.indexOf(filterName) == -1) {
                mainProp = mainProp + ":" + filterName;
                this.setPropertyString(propName, mainProp);
            }
        } else {
            this.setPropertyString(propName, filterName);
        }
        this.saveExisting();
        return true;
    }

    public boolean removeFilter(FilterSelector filter, String propName) {
        if (propName.compareTo(FlowFilters) != 0 && propName.compareTo(JobFilters) != 0) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        String filterKey = this.buildKey(propName, filter.toString());
        this.removeProperty(filterKey);
        String filterName = this.parsePropName(propName, filterKey);
        String mainProp = this.getPropertyString(propName, "");
        int start = mainProp.indexOf(filterName);
        if (start != -1) {
            String temp;
            int end = mainProp.indexOf(58, start);
            if ((mainProp = end == -1 ? mainProp.substring(0, start - 1) : (temp = mainProp.substring(0, start) + mainProp.substring(end))).length() > 0 && mainProp.charAt(0) == ':') {
                mainProp = mainProp.substring(1);
            }
            this.setPropertyString(propName, mainProp);
        }
        this.saveExisting();
        return true;
    }

    public static FilterSelector getNoFlowsRule() {
        FilterRule noFlows = new FilterRule(FlowColumnSelectorModel.getColumnNameForKey((int)0), 0, "");
        return new FilterSelector(m_noFlowsName, noFlows);
    }

    public static FilterSelector getAllFlowsRule() {
        FilterRule anyFlow = new FilterRule(FlowColumnSelectorModel.getColumnNameForKey((int)0), 1, "");
        return new FilterSelector(m_anyFlowName, anyFlow);
    }

    public static FilterSelector getNoJobsRule() {
        FilterRule noJobs = new FilterRule(JobColumnSelectorModel.getColumnNameForKey((int)0), 0, "");
        return new FilterSelector(m_noJobsName, noJobs);
    }

    public static FilterSelector getAllJobsRule() {
        FilterRule anyJob = new FilterRule(JobColumnSelectorModel.getColumnNameForKey((int)0), 1, "");
        return new FilterSelector(m_anyJobName, anyJob);
    }
}

