/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class UnScheduleFlowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(UnScheduleFlowAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;
    private FlowNode m_node;

    public UnScheduleFlowAction(ServerFlowInfo info, ScheduleManager plugin, FlowNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = info;
        this.m_schmgr = plugin;
        this.m_node = node;
        this.setMenuItem();
    }

    public UnScheduleFlowAction(Object[] flowList) {
        this.m_elementList = flowList;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("UnScheduleFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_UnScheduleFlow));
        this.putValue("ShortDescription", m_bundle.getString("UnScheduleFlowAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int flows = this.m_elementList.length;
        for (int index = 0; index < flows; ++index) {
            String message;
            try {
                ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
                if (info.isFlowSubmitted()) {
                    if (this.m_schmgr.connectToSchedulingServer(info)) {
                        int rc = info.removeFromScheduler2();
                        String message2 = "";
                        switch (rc) {
                            case 0: {
                                message2 = m_bundle.messageString("UnScheduleFlowAction.Complete.fmt", (Object)info.getName());
                                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message2, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)1, (int)-1);
                                break;
                            }
                            case 2: {
                                message2 = m_bundle.messageString("UnScheduleFlowAction.CannotUpdateMetadata.Msg.fmt", (Object)info.getName());
                                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message2, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
                                break;
                            }
                            default: {
                                message2 = m_bundle.messageString("UnScheduleFlowAction.CannotRemoveSchedule.Msg.fmt", (Object)info.getName());
                                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message2, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
                                break;
                            }
                        }
                    } else {
                        String message3 = m_bundle.messageString("UnScheduleFlowAction.CannotRemoveSchedule.Msg.fmt", (Object)info.getName());
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message3, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
                    }
                } else {
                    String message4 = m_bundle.messageString("UnScheduleFlowAction.Complete.fmt", (Object)info.getName());
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message4, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)1, (int)-1);
                }
                try {
                    if (this.m_node != null) {
                        this.m_node.refreshIcons();
                        continue;
                    }
                    info.refreshIcon();
                }
                catch (Exception ex) {
                    if (!ScheduleManager.isDebug()) continue;
                    ex.printStackTrace();
                }
                continue;
            }
            catch (SchedulerException ex) {
                message = m_bundle.messageString("UnScheduleFlowAction.CannotRemoveSchedule.Msg.fmt", (Object)ex.getMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
                continue;
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                message = m_bundle.getString("UnScheduleFlowAction.CannotRemoveSchedule.Msg.txt");
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
                continue;
            }
            catch (Exception ex) {
                message = m_bundle.messageString("UnScheduleFlowAction.CannotRemoveSchedule.Msg.fmt", (Object)ex.getMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("UnScheduleFlowAction.Title.txt"), (int)0, (int)-1);
            }
        }
    }
}

