/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.SetJobDialog;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class SetJobAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SetJobAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;

    public SetJobAction(ServerJobInfo job, ScheduleManager plugin, JobNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = job;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    public SetJobAction(Object[] joblist, ScheduleManager plugin) {
        this.m_elementList = joblist;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("SetJobAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_SetJob));
        this.putValue("ShortDescription", m_bundle.getString("SetJobAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            SetJobDialog dialog = new SetJobDialog(this.m_schmgr, this.m_elementList);
            dialog.makeVisible();
            if (dialog.getReturnValue() == 1) {
                for (int i = 0; i < this.m_elementList.length; ++i) {
                    ((ServerJobInfo)this.m_elementList[i]).reevaluateErrors();
                }
            }
        }
        catch (RuntimeException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SetJobAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (Exception e) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)e.getLocalizedMessage(), (String)m_bundle.getString("SetJobAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
            return;
        }
    }
}

