/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.ReportFlowDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import javax.swing.AbstractAction;

public class ReportFlowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ReportFlowAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;

    public ReportFlowAction(ServerFlowInfo flow, ScheduleManager plugin, FlowNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = flow;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    public ReportFlowAction(Object[] flowList, ScheduleManager plugin) {
        this.m_elementList = flowList;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("ReportFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_ReportFlow));
        this.putValue("ShortDescription", m_bundle.getString("ReportFlowAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        boolean single = false;
        try {
            ReportFlowDialog dia = new ReportFlowDialog(this.m_schmgr);
            String reportname = null;
            if (this.m_elementList.length == 1) {
                single = true;
                ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[0];
                reportname = info.getName();
            }
            dia.setName(reportname);
            dia.makeVisible();
            if (dia.getReturnValue() == 1) {
                SASAppServer sc = dia.getSelectedServer();
                reportname = dia.getName();
                DirectoryInfo dir = dia.getSelectedDirectory();
                int format = dia.getReportType();
                switch (format) {
                    case 0: {
                        if (!this.XMLReport(reportname, sc, dir)) break;
                        String message = null;
                        if (single) {
                            String flowname = ((ServerFlowInfo)this.m_elementList[0]).getName();
                            message = m_bundle.messageString("ReportFlowAction.Success.Message.fmt", (Object)flowname, (Object)dir.getPath());
                        } else {
                            message = m_bundle.messageString("ReportFlowAction.AllSuccess.Message.fmt", (Object)dir.getPath());
                        }
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)1, (int)-1);
                        break;
                    }
                    case 1: {
                        if (!this.SASReport(reportname, sc, dir)) break;
                        String message = null;
                        if (single) {
                            String flowname = ((ServerFlowInfo)this.m_elementList[0]).getName();
                            message = m_bundle.messageString("ReportFlowAction.Success.Message.fmt", (Object)flowname, (Object)dir.getPath());
                        } else {
                            message = m_bundle.messageString("ReportFlowAction.AllSuccess.Message.fmt", (Object)dir.getPath());
                        }
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)1, (int)-1);
                        break;
                    }
                    case 2: {
                        if (!this.CSVReport(reportname, sc, dir)) break;
                        String message = null;
                        if (single) {
                            String flowname = ((ServerFlowInfo)this.m_elementList[0]).getName();
                            message = m_bundle.messageString("ReportFlowAction.Success.Message.fmt", (Object)flowname, (Object)dir.getPath());
                        } else {
                            message = m_bundle.messageString("ReportFlowAction.AllSuccess.Message.fmt", (Object)dir.getPath());
                        }
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)1, (int)-1);
                    }
                }
            }
        }
        catch (RemoteException ex) {
            String message;
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            if ((message = ex.getLocalizedMessage()) == null || message.length() == 0) {
                message = ex.toString();
            }
            if (!single) {
                message = m_bundle.messageString("ReportFlowAction.MultipleFlows.Exception.fmt", (Object)message);
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (IOException ex) {
            String message;
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            if ((message = ex.getLocalizedMessage()) == null || message.length() == 0) {
                message = ex.toString();
            }
            if (!single) {
                message = m_bundle.messageString("ReportFlowAction.MultipleFlows.Exception.fmt", (Object)message);
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (RuntimeException ex) {
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            String message = null;
            message = single ? m_bundle.getString("ReportFlowAction.RunTimeException.txt") : m_bundle.getString("ReportFlowAction.MultipleFlows.RunTimeException.txt");
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
    }

    private boolean XMLReport(String name, SASAppServer appServer, DirectoryInfo dir) throws RemoteException, IOException {
        boolean rc = true;
        int flows = this.m_elementList.length;
        for (int index = 0; index < flows; ++index) {
            ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
            try {
                String data = this.m_schmgr.XMLExport(info, name, dir, appServer);
                if (data == null) continue;
                MessageUtil.displayScrollableMessage((Frame)this.m_schmgr.getMainFrame(), (String)data, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (InvalidParameterException ipe) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ipe.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
            }
        }
        return rc;
    }

    private boolean SASReport(String name, SASAppServer appServer, DirectoryInfo dir) throws RemoteException, IOException {
        boolean rc = true;
        int flows = this.m_elementList.length;
        for (int index = 0; index < flows; ++index) {
            ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
            try {
                String data = this.m_schmgr.SASExport(info, name, dir, appServer);
                if (data == null) continue;
                MessageUtil.displayScrollableMessage((Frame)this.m_schmgr.getMainFrame(), (String)data, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (InvalidParameterException ipe) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ipe.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (ProviderException pe) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)pe.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)2, (int)-1);
                rc = true;
                continue;
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
            }
        }
        return rc;
    }

    private boolean CSVReport(String name, SASAppServer appServer, DirectoryInfo dir) throws RemoteException, IOException {
        boolean rc = true;
        int flows = this.m_elementList.length;
        for (int index = 0; index < flows; ++index) {
            ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
            try {
                String data = this.m_schmgr.CSVExport(info, name, dir, appServer);
                if (data == null) continue;
                MessageUtil.displayScrollableMessage((Frame)this.m_schmgr.getMainFrame(), (String)data, (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (InvalidParameterException ipe) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ipe.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
                continue;
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ReportFlowAction.Title.txt"), (int)0, (int)-1);
                rc = false;
            }
        }
        return rc;
    }
}

