/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.utils.WindowUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesGeneralTab;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.AbstractAction;

public class PropertyAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(PropertyAction.class);
    private ServerInfoInterface m_node;
    private ScheduleManager m_schmgr;
    private boolean m_commitChanges;
    private boolean m_dirty = false;

    public PropertyAction(ServerInfoInterface node, ScheduleManager plugin) {
        this(node, plugin, true);
    }

    public PropertyAction(ServerInfoInterface node, ScheduleManager plugin, boolean commitChanges) {
        super("properties");
        this.m_node = node;
        this.m_schmgr = plugin;
        this.m_commitChanges = commitChanges;
        String nameText = m_bundle.getString("PropertyAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Properties));
        this.putValue("ShortDescription", m_bundle.getString("PropertyAction.ShortDescription.txt"));
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List viewList = this.m_node.getPropertyTabs();
        Root metaObject = this.m_node.getMetadataObject(this.m_schmgr.getServerUtilities());
        Root copyRoot = null;
        if (metaObject != null) {
            copyRoot = Server.createNewEditableObject((Root)metaObject);
        }
        String strTitle = m_bundle.messageString("PropertyAction.Title.fmt.txt", (Object)this.m_node.toString());
        if (viewList == null || viewList.size() == 0) {
            String strMessage = m_bundle.getString("PropertyAction.Message.NoProperties.txt");
            if (copyRoot != null) {
                WAGeneralPropertyTab generalTab = new WAGeneralPropertyTab((CMetadata)copyRoot);
                generalTab.setName(m_bundle.getString("PropertyAction.GeneralTab.txt"));
                WAPropertyDialog dialog = new WAPropertyDialog(this.m_schmgr.getMainFrame(), strTitle, true);
                dialog.setMetadataObject((CMetadata)copyRoot);
                dialog.addTab(generalTab.getName(), (WAPropertyTab)generalTab);
                dialog.pack();
                WindowUtil.center((Window)dialog);
                dialog.show();
            } else {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)strMessage, (String)strTitle, (int)1);
            }
        } else {
            WAPropertyDialog dialog = new WAPropertyDialog(this.m_schmgr.getMainFrame(), strTitle, true);
            dialog.setHelpProduct("scheduler");
            if (this.m_commitChanges) {
                dialog.setMetadataObject((CMetadata)copyRoot);
            }
            FlowPropertiesGeneralTab ftab = null;
            for (int index = 0; index < viewList.size(); ++index) {
                WAPropertyTab tab = (WAPropertyTab)viewList.get(index);
                if (tab instanceof FlowPropertiesGeneralTab) {
                    ftab = (FlowPropertiesGeneralTab)tab;
                    ftab.setCommitChanges(this.m_commitChanges);
                }
                dialog.addTab(tab.getName(), tab);
            }
            dialog.pack();
            WindowUtil.center((Window)dialog);
            dialog.setVisible(true);
            if (ftab != null) {
                this.m_dirty = ftab.isDirty();
            }
        }
        try {
            if (copyRoot != null && copyRoot.getObjectStore() != null) {
                copyRoot.getObjectStore().dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

