/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListOfJobs
implements Runnable {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ListOfJobs.class);
    private ScheduleManager m_schmgr;
    private boolean m_error = true;
    private String m_errorMessage = null;
    private List<JobInfo> m_joblist = new ArrayList<JobInfo>();
    private List<?> m_jobFilterList;
    private boolean m_sorted;
    private boolean m_displayOnly;

    public ListOfJobs(ScheduleManager plugin, List<?> filter) {
        this(plugin, filter, false, true);
    }

    public ListOfJobs(ScheduleManager plugin, List<?> filter, boolean sorted, boolean displayOnly) {
        this.m_schmgr = plugin;
        this.m_jobFilterList = filter;
        this.m_sorted = sorted;
        this.m_displayOnly = displayOnly;
    }

    public List<JobInfo> getList() {
        return this.m_joblist;
    }

    public boolean isError() {
        return this.m_error;
    }

    public String getErrorMessage() {
        if (this.m_error) {
            return this.m_errorMessage;
        }
        return null;
    }

    @Override
    public void run() {
        try {
            this.m_joblist.clear();
            List<List<DisplayInfo>> jlist = this.m_schmgr.getJobAndSubflowLists("NEWFLOWID", null, false);
            List<DisplayInfo> jobs = jlist.get(0);
            if (this.m_jobFilterList != null) {
                int listsize = jobs.size();
                for (int i = 0; i < listsize; ++i) {
                    JobInfo job = (JobInfo)jobs.get(i);
                    if (this.m_jobFilterList.contains(job.getName())) continue;
                    this.m_joblist.add(job);
                }
            } else {
                this.m_joblist.addAll(jobs);
            }
            if (this.m_sorted) {
                Collections.sort(this.m_joblist, new CompareDisplayInfoObjects());
            }
            this.m_error = false;
            this.m_errorMessage = null;
        }
        catch (RuntimeException ex) {
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            this.m_error = true;
            this.m_errorMessage = m_bundle.messageString("ListOfJobs.PopulateJobException.fmt", (Object)ex.getMessage());
        }
    }
}

