/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.filter.model.FilterSelector;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.DataStepProgramRedeployerAction;
import com.sas.scheduler.schmgr.DeleteJobAction;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SetJobAction;
import com.sas.scheduler.schmgr.model.JobsTableModel;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesAttributesTab;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesDependenciesTab;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesGeneralTab;
import com.sas.scheduler.schmgr.visuals.JobPropertiesGeneralTab;
import com.sas.scheduler.schmgr.visuals.SchedulingDetailsTab;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class JobNode
extends AbstractNode
implements ElementInterface,
ServerInfoInterface {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobNode.class);
    private ScheduleManager m_schmgr;
    private ServerJobInfo m_job;
    private ServerFlowInfo m_subflow;
    private JobsTableModel m_tableModel;
    private ServerFlowInfo m_flow;
    private String m_Id;
    private FilterTableView m_pane = null;
    private SetJobAction m_sja = null;
    private DeleteJobAction m_dja = null;
    private DataStepProgramRedeployerAction m_rja = null;
    private FilterSelector m_filter = null;

    public JobNode(PluginNavigationInterface pInterface, String name, ServerJobInfo job) {
        this(pInterface, name, job, null);
    }

    public JobNode(PluginNavigationInterface pInterface, String name, ServerFlowInfo subflow) {
        this(pInterface, name, null, subflow);
    }

    private JobNode(PluginNavigationInterface pInterface, String name, ServerJobInfo job, ServerFlowInfo subflow) {
        super(pInterface, name);
        this.m_schmgr = (ScheduleManager)pInterface;
        this.m_plugin = pInterface;
        this.m_job = job;
        this.m_subflow = subflow;
        if (this.m_job != null) {
            this.m_Id = this.m_job.getId();
            this.m_sja = new SetJobAction(this.m_job, this.m_schmgr, this);
            this.m_dja = new DeleteJobAction(this.m_job, this.m_schmgr, this);
            this.m_rja = new DataStepProgramRedeployerAction(this.m_job, this.m_schmgr, this);
        } else {
            this.m_Id = this.m_subflow.getId();
            this.m_dja = new DeleteJobAction(this.m_subflow, this.m_schmgr, this);
        }
        this.m_filter = null;
    }

    public CustomViewInterface getCustomView() {
        if (this.m_pane == null) {
            this.getListViewData();
            this.m_pane = new FilterTableView(this.m_schmgr.getWorkspaceFile(), (NodeInterface)this, (NeoTableModelInterface)this.m_tableModel, this.m_filter);
        }
        return this.m_pane;
    }

    public List<AbstractAction> getContextMenuActions() {
        ArrayList<AbstractAction> actionList = new ArrayList<AbstractAction>();
        if (this.getParent() instanceof FlowNode) {
            this.m_flow = ((FlowNode)((Object)this.getParent())).getFlowInfo();
        }
        if (this.m_job != null) {
            if (this.m_job.isJobAssociationError()) {
                this.m_sja.setEnabled(true);
                actionList.add(this.m_sja);
            } else {
                this.m_sja.setEnabled(false);
            }
            if (this.m_job.isRedeployable()) {
                actionList.add(this.m_rja);
            }
        }
        actionList.add(this.m_dja);
        return actionList;
    }

    public TableModelInterface getListViewData() {
        if (this.m_tableModel == null) {
            Vector<Object> jobs = new Vector<Object>();
            if (this.m_job != null) {
                jobs.add(this.m_job);
            } else {
                jobs.add(this.m_subflow);
            }
            this.m_tableModel = new JobsTableModel((NodeInterface)this, jobs, this.m_filter, new JobColumnSelectorModel(0));
        }
        return this.m_tableModel;
    }

    public List<AbstractAction> getToolBarActions() {
        this.m_schmgr.clearChallengeCallbackHandler();
        return this.getContextMenuActions();
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public Icon getIcon(int size) {
        return this.getIcon();
    }

    public Icon getIcon() {
        try {
            if (this.m_subflow == null) {
                return this.m_job.getIcon();
            }
            return this.m_subflow.getIcon();
        }
        catch (RuntimeException ex) {
            return IconUtil.getIcon((String)IconUtil.NODE_Job);
        }
    }

    public void refreshIcon() {
        if (this.m_job != null) {
            this.m_job.refreshIcon();
        } else {
            this.m_subflow.refreshIcon();
        }
    }

    public void refresh() {
        try {
            if (this.m_job != null) {
                this.m_job.refresh();
                this.m_job.reevaluateErrors();
            } else {
                this.m_subflow.refresh();
                this.m_subflow.reevaluateErrors();
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public String getID() {
        return this.m_Id;
    }

    public List<WAPropertyTab> getPropertyTabs() {
        if (this.getParent() instanceof FlowNode) {
            this.m_flow = ((FlowNode)((Object)this.getParent())).getFlowInfo();
        }
        MdObjectListener mol = new MdObjectListener(){

            public void MdObjectModified(MdEvent e) {
                if (e.getSource().equals("NAME")) {
                    try {
                        JobNode.this.updateName();
                    }
                    catch (RemoteException ex) {
                        String errorMessage = m_bundle.messageString("JobNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                        MessageUtil.displayMessage((Frame)JobNode.this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("JobNode.Title.txt"), (int)0);
                    }
                    catch (RuntimeException ex) {
                        String errorMessage = m_bundle.messageString("JobNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                        MessageUtil.displayMessage((Frame)JobNode.this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("JobNode.Title.txt"), (int)0);
                    }
                } else if (e.getSource().equals("WRITECHANGE")) {
                    JobNode.this.refreshNode();
                }
            }
        };
        List<WAPropertyTab> list = null;
        if (this.m_job != null) {
            list = JobNode.getPropertyTabs(this.m_schmgr, this.m_job, this.m_flow);
            try {
                this.m_job.addMetaDataListener(mol);
            }
            catch (RemoteException ex) {
                String errorMessage = m_bundle.messageString("JobNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("JobNode.Title.txt"), (int)0);
            }
        } else if (this.m_subflow != null) {
            list = JobNode.getPropertyTabs(this.m_schmgr, this.m_subflow, this.m_flow);
            try {
                this.m_subflow.addMetaDataListener(mol);
            }
            catch (RemoteException e1) {
                String errorMessage = m_bundle.messageString("JobNode.UnexpectedError.Message.fmt", (Object)e1.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("JobNode.Title.txt"), (int)0);
            }
        }
        return list;
    }

    public static List<WAPropertyTab> getPropertyTabs(ScheduleManager schmgr, ServerJobInfo job, ServerFlowInfo flow) {
        ArrayList<WAPropertyTab> tabList = new ArrayList<WAPropertyTab>();
        try {
            job.generateAllInformation(false);
            SchedulingDetailsTab tab2 = new SchedulingDetailsTab(schmgr, job, flow, flow != null);
            tab2.setName(m_bundle.getString("JobNode.SchedulingDetailsTab.Name.txt"));
            JobPropertiesGeneralTab tab1 = new JobPropertiesGeneralTab(schmgr, job);
            tab1.setName(m_bundle.getString("JobNode.GeneralTab.Name.txt"));
            tabList.add((WAPropertyTab)tab1);
            tabList.add(tab2);
            tabList.trimToSize();
        }
        catch (RemoteException ex) {
            tabList = null;
        }
        catch (SchedulerException ex) {
            tabList = null;
        }
        return tabList;
    }

    public static List<WAPropertyTab> getPropertyTabs(ScheduleManager schmgr, ServerFlowInfo subflow, ServerFlowInfo flow) {
        ArrayList<WAPropertyTab> tabList = new ArrayList<WAPropertyTab>();
        try {
            FlowPropertiesGeneralTab tab1 = new FlowPropertiesGeneralTab(schmgr, subflow);
            tab1.setName(m_bundle.getString("FlowNode.GeneralTab.Name.txt"));
            tabList.add((WAPropertyTab)tab1);
            FlowPropertiesAttributesTab tab2 = null;
            try {
                tab2 = new FlowPropertiesAttributesTab(schmgr, subflow);
                tab2.setName(m_bundle.getString("FlowNode.FlowPropertiesAttributesTab.Name.txt"));
                tabList.add(tab2);
            }
            catch (SchedulerException se) {
                MessageUtil.displayMessage((Frame)schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2, (int)-1);
            }
            try {
                FlowPropertiesDependenciesTab tab3 = new FlowPropertiesDependenciesTab(schmgr, subflow);
                tab3.setName(m_bundle.getString("FlowNode.FlowPropertiesDependenciesTab.Name.txt"));
                tabList.add(tab3);
                if (tab2 != null) {
                    tab2.setDependentTab(tab3);
                }
            }
            catch (SchedulerException se) {
                MessageUtil.displayMessage((Frame)schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2, (int)-1);
            }
            tabList.trimToSize();
        }
        catch (RemoteException ex) {
            tabList = null;
        }
        return tabList;
    }

    public ServerJobInfo getJobInfo() {
        return this.m_job;
    }

    public ServerFlowInfo getFlowInfo() {
        return this.m_subflow;
    }

    public NodeInterface getNode() {
        return this;
    }

    public void delete() {
        this.m_job = null;
        this.m_subflow = null;
        this.m_tableModel = null;
        this.m_flow = null;
        this.m_Id = null;
    }

    public void persist() {
    }

    public void refreshNode() {
        this.refresh();
        ((RootNode)this.m_plugin.getRootNode()).refreshFlows();
    }

    public void updateName() throws RemoteException {
        String jobName = this.getName();
        if (this.m_job != null) {
            jobName = this.updateName(this.m_job, this.m_flow);
        } else if (this.m_subflow != null) {
            jobName = this.updateName(this.m_subflow, this.m_flow);
        }
        this.setName(jobName);
    }

    public Root getMetadataObject(ServerUtilities serverUtil) {
        if (this.m_job != null) {
            return this.m_job.getMetadataObject(serverUtil);
        }
        return this.m_subflow.getMetadataObject(serverUtil);
    }

    private String updateName(ServerJobInfo job, ServerFlowInfo flow) throws RemoteException {
        ServerUtilities serverUtil = this.m_schmgr.getServerUtilities();
        String jobName = job.getMetadataObject(serverUtil).getName();
        serverUtil.renameInListForAllJobsAndFlows(job.getId(), jobName);
        if (flow != null) {
            job.setName(jobName, flow);
        } else {
            job.setName(jobName, null);
        }
        return jobName;
    }

    private String updateName(ServerFlowInfo subflow, ServerFlowInfo flow) throws RemoteException {
        String jobName = subflow.getMetadataObject(this.m_schmgr.getServerUtilities()).getName();
        subflow.setName(jobName);
        return jobName;
    }
}

