/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.ImportFlowDialog;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class ImportFlowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ImportFlowAction.class);
    private RootNode m_rootNode = null;
    private ScheduleManager m_schmgr = null;

    public ImportFlowAction(RootNode node, ScheduleManager plugin) {
        this.m_rootNode = node;
        this.m_schmgr = plugin;
        String nameText = m_bundle.getString("ImportFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_ImportFlow));
        this.putValue("ShortDescription", m_bundle.getString("ImportFlowAction.ShortDescription.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        IWorkspace iworkspace = null;
        try {
            ImportFlowDialog dia = new ImportFlowDialog(this.m_schmgr);
            dia.makeVisible();
            if (dia.getReturnValue() != 1) return;
            iworkspace = dia.getWorkspace();
            if (iworkspace == null) {
                iworkspace = this.m_schmgr.checkConnectionToWorkspaceServer(dia.getSelectedServer());
            }
            String flowname = null;
            String file = dia.getInputFile();
            int format = dia.getReportType();
            switch (format) {
                case 0: {
                    flowname = this.m_schmgr.XMLImport(iworkspace, file, m_bundle.getString("ImportFlowAction.Title.txt"));
                    if (flowname != null) {
                        this.m_rootNode.refresh();
                        String message = null;
                        message = m_bundle.messageString("ImportFlowAction.Success.Message.fmt", (Object)flowname, (Object)file);
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)1, (int)-1);
                        return;
                    }
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("ImportFlowAction.Failed.txt"), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
                    return;
                }
                case 1: {
                    flowname = this.m_schmgr.SASImport(iworkspace, file, m_bundle.getString("ImportFlowAction.Title.txt"));
                    if (flowname != null) {
                        this.m_rootNode.refresh();
                        String message = null;
                        message = m_bundle.messageString("ImportFlowAction.Success.Message.fmt", (Object)flowname, (Object)file);
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)1, (int)-1);
                        return;
                    }
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("ImportFlowAction.Failed.txt"), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
                    return;
                }
                case 2: {
                    flowname = this.m_schmgr.CSVImport(iworkspace, file, m_bundle.getString("ImportFlowAction.Title.txt"));
                    if (flowname != null) {
                        this.m_rootNode.refresh();
                        String message = null;
                        message = m_bundle.messageString("ImportFlowAction.Success.Message.fmt", (Object)flowname, (Object)file);
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)1, (int)-1);
                        return;
                    }
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("ImportFlowAction.Failed.txt"), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
                    return;
                }
            }
            return;
        }
        catch (SchedulerException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (IllegalArgumentException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("ImportFlowAction.RunTimeException.txt"), (String)m_bundle.getString("ImportFlowAction.Title.txt"), (int)0, (int)-1);
            return;
        }
        finally {
            if (iworkspace != null) {
                try {
                    iworkspace.Close();
                    iworkspace = null;
                }
                catch (GenericError ge) {
                    iworkspace = null;
                }
            }
        }
    }
}

