/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.FlowPFDScrollView;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.DeleteJobDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class DeleteJobAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DeleteJobAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;
    private JobNode m_node;
    private NodeInterface m_parentNode;

    public DeleteJobAction(ServerJobInfo job, ScheduleManager plugin, JobNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = job;
        this.m_schmgr = plugin;
        this.m_node = node;
        if (this.m_node != null) {
            this.m_parentNode = (NodeInterface)this.m_node.getParent();
        }
        this.setMenuItem();
    }

    public DeleteJobAction(ServerFlowInfo subflow, ScheduleManager plugin, JobNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = subflow;
        this.m_schmgr = plugin;
        this.m_node = node;
        if (this.m_node != null) {
            this.m_parentNode = (NodeInterface)this.m_node.getParent();
        }
        this.setMenuItem();
    }

    public DeleteJobAction(Object[] jobList, ScheduleManager plugin, NodeInterface node) {
        this.m_elementList = jobList;
        this.m_schmgr = plugin;
        this.m_node = null;
        this.m_parentNode = node;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("DeleteJobAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Delete));
        this.putValue("ShortDescription", m_bundle.getString("DeleteJobAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_node != null && this.m_parentNode == null) {
            this.m_parentNode = (NodeInterface)this.m_node.getParent();
        }
        DeleteJobDialog dialog = new DeleteJobDialog(this.m_schmgr, this.m_elementList, this.m_parentNode);
        dialog.makeVisible();
        if (dialog.getReturnValue() == 1 && dialog.isRemoved()) {
            ServerFlowInfo parent_info = null;
            if (this.m_parentNode != null) {
                FlowNode parent = (FlowNode)this.m_parentNode;
                parent_info = parent.getFlowInfo();
                try {
                    CustomViewInterface view;
                    if (parent_info != null && parent_info.isFlowSubmitted() && this.m_schmgr.isAutoReschedule() && !this.m_schmgr.interactiveAutoSubmit(parent_info)) {
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("DeleteJobAction.ReSubmitFlowFailed.msg.fmt", (Object)parent_info.getName()), (String)m_bundle.getString("DeleteJobAction.Title.txt"), (int)2);
                    }
                    if ((view = this.m_parentNode.getCustomView()) instanceof FlowPFDScrollView) {
                        FlowPFDScrollView pfdview = (FlowPFDScrollView)view;
                        pfdview.resetView();
                    } else if (view instanceof FilterTableView) {
                        if (parent_info != null) {
                            parent_info.refresh();
                        }
                        parent.setCustomView(null);
                        parent.refreshUI();
                    }
                }
                catch (SchedulerException ex) {
                    ex.printStackTrace();
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

