/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.FlowPFDScrollView;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.DeleteJobDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class DeleteFlowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DeleteFlowAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;
    private AbstractNode m_node;

    public DeleteFlowAction(ServerFlowInfo flow, ScheduleManager plugin, AbstractNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = flow;
        this.m_schmgr = plugin;
        this.m_node = node;
        this.setMenuItem();
    }

    public DeleteFlowAction(Object[] flowList, ScheduleManager plugin) {
        this.m_elementList = flowList;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("DeleteFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Delete));
        this.putValue("ShortDescription", m_bundle.getString("DeleteFlowAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Frame frame = this.m_schmgr.getMainFrame();
        try {
            this.deleteFlows(frame);
        }
        catch (RemoteException re) {
            MessageUtil.displayMessage((Frame)frame, (String)re.getLocalizedMessage(), (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)-1);
        }
        catch (Exception mde) {
            MessageUtil.displayMetadataExceptionMessage((Exception)mde, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)4);
        }
    }

    private void deleteFlows(Frame frame) throws RemoteException, SchedulerException {
        ArrayList<ServerFlowInfo> scheduledFlows = new ArrayList<ServerFlowInfo>();
        ArrayList<ServerFlowInfo> unscheduledFlows = new ArrayList<ServerFlowInfo>();
        String title = m_bundle.getString("DeleteFlowAction.Title.txt");
        boolean prompt = true;
        int flows = this.m_elementList.length;
        String checkbox2 = null;
        if (flows > 1) {
            ConfirmationCheckboxPanel panel = new ConfirmationCheckboxPanel(m_bundle.messageString("DeleteFlowAction.ConfirmationMessage.fmt", (Object)String.valueOf(flows)), m_bundle.getString("DeleteFlowAction.Checkbox.txt"));
            StandardDialog dialog = new StandardDialog(frame, title, true);
            dialog.setMainPanel((StandardPanel)panel);
            dialog.setHelpProduct("scheduler");
            dialog.setHelpTopic("window_delete_flow");
            dialog.makeVisible();
            if (dialog.getReturnValue() != 1) {
                return;
            }
            prompt = !panel.checkboxSelected();
            checkbox2 = m_bundle.getString("DeleteFlowAction.Checkbox2.txt");
        }
        boolean prompt2 = true;
        for (int index = 0; index < flows; ++index) {
            String message = null;
            if (index + 1 >= flows) {
                checkbox2 = null;
            }
            ServerFlowInfo flow = (ServerFlowInfo)this.m_elementList[index];
            if (this.m_node != null && this.m_node.getParent() instanceof FlowNode) {
                FlowNode parent;
                block26: {
                    parent = (FlowNode)((Object)this.m_node.getParent());
                    DeleteJobDialog dialog = new DeleteJobDialog(this.m_schmgr, this.m_elementList, (NodeInterface)parent);
                    dialog.makeVisible();
                    if (dialog.getReturnValue() != 1 || !dialog.isRemoved()) continue;
                    ServerFlowInfo pInfo = parent.getFlowInfo();
                    if (pInfo != null) {
                        FlowInfo p = pInfo.getInfo();
                        p.removeJob((DisplayInfo)flow);
                        pInfo.resetInfo(p);
                    }
                    try {
                        CustomViewInterface view;
                        if (this.m_schmgr.isAutoReschedule() && pInfo != null && pInfo.isFlowSubmitted() && !this.m_schmgr.interactiveAutoSubmit(pInfo)) {
                            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("DeleteJobAction.ReSubmitFlowFailed.msg.fmt", (Object)pInfo.getName()), (String)m_bundle.getString("DeleteJobAction.Title.txt"), (int)2);
                        }
                        if ((view = parent.getCustomView()) instanceof FlowPFDScrollView) {
                            FlowPFDScrollView pfdview = (FlowPFDScrollView)view;
                            pfdview.resetView();
                        } else if (view instanceof FilterTableView) {
                            parent.setCustomView(null);
                            parent.refreshUI();
                        }
                    }
                    catch (Exception ex) {
                        if (!ScheduleManager.isDebug()) break block26;
                        ex.printStackTrace();
                    }
                }
                parent.refreshUI();
                continue;
            }
            ConfirmationCheckboxPanel panel = null;
            boolean scheduled = false;
            boolean submitted = true;
            try {
                submitted = flow.isFlowSubmitted();
            }
            catch (Exception e) {
                submitted = false;
            }
            if (submitted) {
                panel = new ConfirmationCheckboxPanel(m_bundle.messageString("DeleteFlowAction.Resubmission.fmt", (Object)flow.getName()), checkbox2);
                scheduled = true;
            } else {
                panel = new ConfirmationCheckboxPanel(m_bundle.messageString("DeleteFlowAction.ConfirmDelete.fmt", (Object)flow.getName()), checkbox2);
            }
            int response = 1;
            if (prompt) {
                StandardDialog dialog = new StandardDialog(frame, title, true);
                dialog.setHelpButtonVisible(false);
                dialog.setMainPanel((StandardPanel)panel);
                dialog.makeVisible();
                if (dialog.getReturnValue() == 1) {
                    prompt = !panel.checkboxSelected();
                } else {
                    response = 2;
                }
            }
            if (response != true) continue;
            if (scheduled) {
                try {
                    if (this.m_schmgr.connectToSchedulingServer(flow)) {
                        scheduledFlows.add(flow);
                        continue;
                    }
                    if (prompt2) {
                        ConfirmationCheckboxPanel panel2 = new ConfirmationCheckboxPanel(m_bundle.messageString("DeleteFlowAction.DeleteFromMetadataAnyhow.fmt", (Object)flow.getName()), checkbox2);
                        StandardDialog dialog = new StandardDialog(frame, title, true);
                        dialog.setMainPanel((StandardPanel)panel2);
                        dialog.setHelpButtonVisible(false);
                        dialog.makeVisible();
                        if (dialog.getReturnValue() == 1) {
                            prompt2 = !panel2.checkboxSelected();
                            scheduledFlows.add(flow);
                            continue;
                        }
                        message = m_bundle.messageString("DeleteFlowAction.UnableToDelete.UserCancel.fmt", (Object)flow.getName());
                        MessageUtil.displayMessage((Frame)frame, (String)message, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)2);
                        continue;
                    }
                    scheduledFlows.add(flow);
                    continue;
                }
                catch (Exception e) {
                    SchedulerException ex = new SchedulerException();
                    ex.initCause((Throwable)e);
                    throw ex;
                }
            }
            unscheduledFlows.add(flow);
        }
        String str1 = m_bundle.getString("DeleteFlowAction.ProgressIndicator.Message.txt");
        String str2 = m_bundle.getString("DeleteFlowAction.ProgressIndicator.Title.txt");
        ProgressIndicator request = new ProgressIndicator(frame, str1, str2);
        request.setDelayBeforeProgressCancelDialog(100);
        CRunnable_deleteFlows doDeletes = new CRunnable_deleteFlows(frame, unscheduledFlows, scheduledFlows, request);
        request.execute((Runnable)doDeletes);
        if (this.m_node.getParent() instanceof RootNode) {
            RootNode rootNode = (RootNode)((Object)this.m_node.getParent());
            rootNode.refreshFlows();
        }
    }

    private class ConfirmationCheckboxPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox m_checkbox = null;

        public ConfirmationCheckboxPanel(String text, String checkbox) {
            this.__layoutWidgets(text, checkbox);
        }

        public void saveSettingsAndCleanUp() {
        }

        public boolean checkboxSelected() {
            return this.m_checkbox != null ? this.m_checkbox.isSelected() : false;
        }

        private void __layoutWidgets(String text, String checkbox) {
            JLabel label = new JLabel(text);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int gridy = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(label, gbc);
            this.add(label);
            if (checkbox != null) {
                this.m_checkbox = new JCheckBox(checkbox);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy;
                gbc.gridwidth = 2;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(12, 12, 0, 0);
                gridBagLayout.setConstraints(this.m_checkbox, gbc);
                this.add(this.m_checkbox);
            }
        }
    }

    private class CRunnable_deleteFlows
    implements Runnable {
        Frame mc_frame;
        List<ServerFlowInfo> mc_unscheduledFlows;
        List<ServerFlowInfo> mc_scheduledFlows;
        ProgressIndicator mc_parent;

        public CRunnable_deleteFlows(Frame frame, List<ServerFlowInfo> unscheduledFlows, List<ServerFlowInfo> scheduledFlows, ProgressIndicator parent) {
            this.mc_frame = frame;
            this.mc_unscheduledFlows = unscheduledFlows;
            this.mc_scheduledFlows = scheduledFlows;
            this.mc_parent = parent;
        }

        @Override
        public void run() {
            String message;
            int success2;
            for (ServerFlowInfo flow : this.mc_unscheduledFlows) {
                try {
                    this.mc_parent.setMessage(m_bundle.messageString("DeleteFlowAction.ProgressIndicator.Message.fmt", (Object)flow.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                success2 = DeleteFlowAction.this.m_schmgr.deleteUnscheduledFlow(flow);
                message = null;
                switch (success2) {
                    case 2: {
                        message = m_bundle.messageString("DeleteFlowAction.UnableToDelete.fmt", (Object)flow.getName());
                        MessageUtil.displayMessage((Frame)this.mc_frame, (String)message, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)0);
                        DeleteFlowAction.this.m_schmgr.fixUnableToDelete(flow);
                    }
                }
            }
            for (ServerFlowInfo flow : this.mc_scheduledFlows) {
                try {
                    this.mc_parent.setMessage(m_bundle.messageString("DeleteFlowAction.ProgressIndicator.Message.fmt", (Object)flow.getName()));
                }
                catch (Exception success2) {
                    // empty catch block
                }
                success2 = DeleteFlowAction.this.m_schmgr.deleteScheduledFlow(flow);
                message = null;
                switch (success2) {
                    case 1: {
                        message = m_bundle.messageString("DeleteFlowAction.UnableToRemoveFromScheduler.fmt", (Object)flow.getName());
                        MessageUtil.displayMessage((Frame)this.mc_frame, (String)message, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)0);
                        if (DeleteFlowAction.this.m_schmgr.deleteFlowFromMetadata(flow)) break;
                        message = m_bundle.messageString("DeleteFlowAction.UnableToDelete.fmt", (Object)flow.getName());
                        MessageUtil.displayMessage((Frame)this.mc_frame, (String)message, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)0);
                        break;
                    }
                    case 2: {
                        message = m_bundle.messageString("DeleteFlowAction.UnableToDelete.fmt", (Object)flow.getName());
                        MessageUtil.displayMessage((Frame)this.mc_frame, (String)message, (String)m_bundle.getString("DeleteFlowAction.Title.txt"), (int)0);
                        DeleteFlowAction.this.m_schmgr.fixUnableToDelete(flow);
                    }
                }
            }
        }
    }
}

