/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.tree.TreeNode;

public class DataStepProgramRedeployerAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DataStepProgramRedeployerAction.class);
    private ScheduleManager m_schmgr;
    private JobNode m_node;
    private Object[] m_elementList;

    public DataStepProgramRedeployerAction(ServerJobInfo info, ScheduleManager plugin, JobNode node) {
        this(DataStepProgramRedeployerAction.makeSingleIntoList(info), plugin);
        this.m_node = node;
    }

    private static Object[] makeSingleIntoList(ServerJobInfo info) {
        Object[] elementList = new Object[]{info};
        return elementList;
    }

    public DataStepProgramRedeployerAction(Object[] joblist, ScheduleManager plugin) {
        this.m_elementList = joblist;
        this.m_schmgr = plugin;
        String nameText = m_bundle.getString("DataStepProgramRedeployerAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_DeployJob));
        this.putValue("ShortDescription", m_bundle.getString("DataStepProgramRedeployerAction.Description.txt"));
    }

    public void dispose() {
        this.m_elementList = null;
        this.m_schmgr = null;
        this.m_node = null;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Frame frame = this.m_schmgr.getMainFrame();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.m_elementList.length <= 0) {
                return;
            }
            if (this.m_elementList.length == 1) {
                ServerJobInfo info = (ServerJobInfo)this.m_elementList[0];
                DisplayInfo jinfo = info.getJobInfo();
                if (jinfo instanceof JobInfo) {
                    TreeNode parent;
                    if (this.m_schmgr.redeploy(info, jinfo, null) == 1 && this.m_node != null && (parent = this.m_node.getParent()) instanceof FlowNode) {
                        ((FlowNode)((Object)parent)).refresh();
                    }
                } else {
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("DataStepProgramRedeployerAction.ErrorMsg.UnableToExecute.fmt", (Object)jinfo.getName()), (String)m_bundle.getString("DataStepProgramRedeployerAction.Title.txt"), (int)2, (int)-1);
                }
            } else if (this.m_elementList.length > 1) {
                ArrayList<DisplayInfo> djobs = new ArrayList<DisplayInfo>();
                for (int x = 0; x < this.m_elementList.length; ++x) {
                    ServerInfoInterface info = (ServerInfoInterface)this.m_elementList[x];
                    if (info instanceof ServerJobInfo) {
                        DisplayInfo jinfo = ((ServerJobInfo)info).getJobInfo();
                        djobs.add(jinfo);
                        continue;
                    }
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("DataStepProgramRedeployerAction.ErrorMsg.UnableToRedeploy.fmt", (Object)info.getMetadataObject(this.m_schmgr.getServerUtilities()).getName()), (String)m_bundle.getString("DataStepProgramRedeployerAction.Title.txt"), (int)2, (int)-1);
                }
                this.m_schmgr.redeploy(djobs, null);
            } else {
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("DataStepProgramRedeployerAction.ErrorMsg.UnableToExecute.fmt", (Object)""), (String)m_bundle.getString("DataStepProgramRedeployerAction.Title.txt"), (int)2, (int)-1);
            }
        }
        catch (SchedulerException se) {
            MessageUtil.displayMessage((Frame)frame, (String)se.getMessage(), (String)m_bundle.getString("DataStepProgramRedeployerAction.Title.txt"), (int)0, (int)-1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("DataStepProgramRedeployerAction.ErrorMsg.UnableToExecute.fmt", (Object)message), (String)m_bundle.getString("DataStepProgramRedeployerAction.Title.txt"), (int)2, (int)-1);
        }
        frame.setCursor(Cursor.getPredefinedCursor(0));
    }
}

